/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.client.tools;

import com.sun.jaw.impl.agent.services.mlet.MLetSrvMO;
import com.sun.jaw.reference.client.adaptor.AdaptorMO;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.ObjectName;
import java.net.InetAddress;
import java.util.Vector;

public class MLetSrvInvoker {
    private AdaptorMO MoFactory = null;
    private String host;
    private int port;
    private String logicalName;
    private boolean isConnected = false;
    private String mletName = "com.sun.jaw.impl.agent.services.mlet.MLetSrvMO";
    private MLetSrvMO remoteMlet;
    private static int defaultPort = 8081;
    private static String usage = "Usage: \n\tjava [-DHOST=hostName] [-DPORT=port] com.sun.jaw.impl.agent.services.mlet.MLetSrvInvoker mlet1 ... mletn\nwhere\n\tHOST: hostname of target agent\n\tPORT: port number\n\tmlet..mletn: URLs to load (http or file)\n\nexample: java  com.sun.jaw.impl.agent.services.mlet.MLetSrvInvoker file:/opt/SUNWconn/jaw/etc/launch/test";

    public MLetSrvInvoker(String string, int n) throws ClassNotFoundException {
        this.port = n;
        this.host = string;
        this.logicalName = null;
        this.createAdaptor("com.sun.jaw.impl.adaptor.http.AdaptorClient");
    }

    public MLetSrvInvoker(String string, String string2, String string3, int n) throws ClassNotFoundException {
        this.port = n;
        this.host = string3;
        this.logicalName = string2;
        this.createAdaptor(string);
    }

    public void connect() throws CommunicationException {
        try {
            this.MoFactory.connect(null, this.host, this.port, this.logicalName);
        }
        catch (Exception exception) {
            throw new CommunicationException("Error: Fails to connect to agent");
        }
        String string = this.mletName;
        try {
            String string2 = this.MoFactory.getDomain();
            string = new String(String.valueOf(string2) + ":" + this.mletName);
            Vector vector = this.MoFactory.getObject(new ObjectName(string), null);
            if (vector.size() == 0) {
                throw new CommunicationException("Error: Cannot find object \"" + string + "\" for representing mlet service");
            }
            this.remoteMlet = (MLetSrvMO)vector.firstElement();
        }
        catch (Exception exception) {
            throw new CommunicationException("Error: Cannot find object \"" + string + "\" for representing mlet service");
        }
        this.isConnected = true;
    }

    private void createAdaptor(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = null;
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            this.MoFactory = (AdaptorMO)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Error: Cannot find class \"" + string + "\".");
            throw new ClassNotFoundException(string);
        }
    }

    public void disconnect() {
        try {
            this.MoFactory.disconnect();
        }
        catch (Exception exception) {}
        this.isConnected = false;
        this.MoFactory = null;
    }

    public String getMletName() {
        return this.mletName;
    }

    public void loadMlet(String string) throws CommunicationException {
        if (!this.isConnected) {
            throw new CommunicationException("Error: Service not connected");
        }
        try {
            this.remoteMlet.performLoadURL(string);
        }
        catch (Exception exception) {
            throw new CommunicationException("Error: Fails to load mlet \"" + string + "\"");
        }
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            MLetSrvInvoker.usage();
            System.exit(1);
        }
        int n = (string = System.getProperty("PORT")) == null ? defaultPort : Integer.parseInt(string);
        String string2 = null;
        string2 = System.getProperty("HOST");
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                System.err.println("Error: Cannot get local host name");
                System.exit(1);
            }
        }
        MLetSrvInvoker mLetSrvInvoker = null;
        try {
            mLetSrvInvoker = new MLetSrvInvoker(string2, n);
            mLetSrvInvoker.connect();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                mLetSrvInvoker.loadMlet(stringArray[n2]);
                System.out.println("Loading of \"" + stringArray[n2] + "\" completed");
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            ++n2;
        }
        mLetSrvInvoker.disconnect();
        System.exit(0);
    }

    public void setMletName(String string) {
        this.mletName = string;
    }

    private static void usage() {
        System.err.println(usage);
    }
}

