/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.MibStoreIfSrv;
import com.sun.jaw.snmp.common.SnmpDataTypeEnums;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpStatusException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MibStore
implements MibStoreIfSrv,
SnmpDataTypeEnums {
    private SnmpOid sysUpTimeOid;
    private SnmpOid sysUpTimeOid0;
    static String[][] defaultVarList = new String[][]{{"sysDescr", "1.3.6.1.2.1.1.1", "S"}, {"sysObjectID", "1.3.6.1.2.1.1.2", "O"}, {"sysUpTime", "1.3.6.1.2.1.1.3", "T"}, {"sysContact", "1.3.6.1.2.1.1.4", "S"}, {"sysName", "1.3.6.1.2.1.1.5", "S"}, {"sysLocation", "1.3.6.1.2.1.1.6", "S"}, {"sysServices", "1.3.6.1.2.1.1.7", "I"}, {"ifIndex", "1.3.6.1.2.1.2.2.1.1", "I"}, {"ifDescr", "1.3.6.1.2.1.2.2.1.2", "S"}, {"ifName", "1.3.6.1.2.1.31.1.1.1.1", "S"}, {"ifType", "1.3.6.1.2.1.2.2.1.3", "I"}, {"ifSpeed", "1.3.6.1.2.1.2.2.1.5", "C"}, {"ifInOctets", "1.3.6.1.2.1.2.2.1.10", "C"}};
    private static Hashtable oidStore = new Hashtable();
    private static boolean minimumLoaded = false;

    public MibStore() throws SnmpStatusException {
        this.initializeMibs();
    }

    public static synchronized void addMib(MibStoreIfSrv mibStoreIfSrv) throws SnmpStatusException {
        Vector vector = mibStoreIfSrv.mibElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray = (String[])enumeration.nextElement();
            oidStore.put(stringArray[0], stringArray);
        }
    }

    public SnmpOid getSysUpTimeOid() throws SnmpStatusException {
        if (this.sysUpTimeOid == null) {
            this.sysUpTimeOid = new SnmpOid("sysUpTime");
        }
        return this.sysUpTimeOid;
    }

    public SnmpOid getSysUpTimeOid0() throws SnmpStatusException {
        if (this.sysUpTimeOid0 == null) {
            this.sysUpTimeOid0 = new SnmpOid("sysUpTime.0");
        }
        return this.sysUpTimeOid0;
    }

    private synchronized void initializeMibs() {
        if (minimumLoaded) {
            return;
        }
        try {
            MibStore.loadMib(defaultVarList);
            this.sysUpTimeOid = null;
            this.sysUpTimeOid0 = null;
            minimumLoaded = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Unable to load Initial minimum mibs.");
            System.exit(1);
        }
    }

    public static synchronized void loadMib(String[][] stringArray) {
        try {
            int n = 0;
            while (true) {
                String[] stringArray2 = stringArray[n];
                if (Debug.isLevelSet((int)4096)) {
                    Debug.print((int)2048, (Object)("MibStore::loadMib: load " + stringArray2[0]));
                }
                oidStore.put(stringArray2[0], stringArray2);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public int mapNameToType(String string) {
        int n = string.equals("I") ? 2 : (string.equals("C") ? 65 : (string.equals("G") ? 66 : (string.equals("T") ? 67 : (string.equals("S") ? 4 : (string.equals("OI") ? 6 : (string.equals("NU") ? 5 : (string.equals("C64") ? 70 : (string.equals("U") ? 71 : (string.equals("O") ? 68 : (string.equals("IP") ? 64 : (string.equals("TA") ? 254 : (string.equals("EN") ? 48 : 255))))))))))));
        return n;
    }

    public String mapTypeToName(int n) {
        switch (n) {
            case 2: {
                return "Integer32";
            }
            case 66: {
                return "Gauge32";
            }
            case 65: {
                return "Counter32";
            }
            case 70: {
                return "Counter64";
            }
            case 67: {
                return "TimeTicks";
            }
            case 4: {
                return "String";
            }
            case 6: {
                return "Object Identifier";
            }
            case 64: {
                return "IpAddress";
            }
            case 48: {
                return "Table Entry";
            }
            case 254: {
                return "Table";
            }
            case 68: {
                return "Opaque";
            }
            case 71: {
                return "Unsigned32";
            }
            case 5: {
                return "Null";
            }
        }
        return "Unknown";
    }

    public Vector mibElements() {
        Vector vector = new Vector();
        Enumeration enumeration = oidStore.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public String[] resolveMibVariable(String string) throws SnmpStatusException {
        String[] stringArray = (String[])oidStore.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        int n = string.indexOf(46);
        if (n < 0) {
            throw new SnmpStatusException("Variable name <" + string + "> not found in Oid repository");
        }
        if (n == 0) {
            string = string.substring(1, string.length());
        }
        Enumeration enumeration = oidStore.elements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray2 = (String[])enumeration.nextElement();
            if (!stringArray2[1].equals(string)) continue;
            return stringArray2;
        }
        throw new SnmpStatusException("Variable name <" + string + "> not found in Oid repository");
    }
}

