/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.manager.internal.RequestCounter;
import com.sun.jaw.snmp.manager.internal.SnmpQManager;
import java.util.Date;

public abstract class Request {
    protected static final int stBase = 1;
    public static final int stInProgress = 1;
    public static final int stWaitingToSend = 3;
    public static final int stWaitingForReply = 5;
    public static final int stReceivedReply = 9;
    public static final int stAborted = 16;
    public static final int stTimeout = 32;
    public static final int stInternalError = 64;
    public static final int stResultsAvailable = 128;
    public static final int stNeverUsed = 256;
    private static RequestCounter requestCounter = new RequestCounter();
    protected int retry = 0;
    protected int timeout = 5000;
    private int reqState = 256;
    private long prevPollTime = 0L;
    private long nextPollTime = 0L;
    private long waitTimeForResponse;
    private Date debugDate = new Date();
    private int requestId = 0;

    protected Request() {
    }

    public void action() {
        if (!this.inProgress()) {
            return;
        }
        while (true) {
            try {
                if (this.retry == 0) {
                    this.invokeOnReady();
                } else if (this.retry < this.getMaxRetry()) {
                    this.invokeOnRetry();
                } else {
                    this.invokeOnTimeout();
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ++this.retry;
                System.err.println("Request hit out of memory situation...");
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    public abstract boolean allowMultiplex();

    public abstract void cancelRequest();

    public final synchronized long getAbsMaxTimeToWait() {
        if (this.prevPollTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.waitTimeForResponse;
    }

    public final synchronized long getAbsNextPollTime() {
        return this.nextPollTime;
    }

    public abstract int getMaxRetry();

    public final synchronized long getPollTimestamp() {
        return this.prevPollTime;
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    public final synchronized int getRequestStatus() {
        return this.reqState;
    }

    public final synchronized int getRetryCount() {
        return this.retry;
    }

    public final synchronized boolean inProgress() {
        return (this.reqState & 1) == 1;
    }

    protected final synchronized void initNewRequest() {
        this.requestId = requestCounter.getNewId();
    }

    protected abstract void invokeOnReady();

    public abstract void invokeOnResponse(Object var1);

    protected abstract void invokeOnRetry();

    protected abstract void invokeOnTimeout();

    public final synchronized boolean isAborted() {
        return (this.reqState & 0x10) == 16;
    }

    public final synchronized boolean isResultAvailable() {
        return this.reqState == 128;
    }

    protected abstract void processResponse() throws SnmpStatusException;

    private void schedulePoll() {
        this.retry = 0;
        this.initNewRequest();
        this.setRequestStatus(3);
        SnmpQManager.getTheInstance().addRequest(this);
    }

    public final synchronized void setPreviousPollTimestamp(long l) {
        this.prevPollTime = l;
    }

    protected final void setRequestSentTime(long l) {
        if (++this.retry > 1) {
            this.timeout *= 2;
        }
        this.setPreviousPollTimestamp(l);
        this.waitTimeForResponse = this.prevPollTime + (long)this.timeout;
        this.setRequestStatus(5);
        Debug.print((int)2048, (Object)"Request::setRequestSentTime: Request Successfully sent. ");
        SnmpQManager.getTheInstance().addWaiting(this);
    }

    protected final synchronized void setRequestStatus(int n) {
        this.reqState = n;
    }

    public final synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    protected synchronized void startRequest(long l) {
        this.nextPollTime = l;
        this.prevPollTime = 0L;
        this.schedulePoll();
    }

    static final String statusDescription(int n) {
        switch (n) {
            case 3: {
                return "Waiting to send.";
            }
            case 5: {
                return "Waiting for reply.";
            }
            case 9: {
                return "Response arrived.";
            }
            case 16: {
                return "Aborted by user.";
            }
            case 32: {
                return "Timeout Occured.";
            }
            case 64: {
                return "Internal error.";
            }
            case 128: {
                return "Results available";
            }
            case 256: {
                return "Request in createAndWait state";
            }
        }
        return "Unknown Request state.";
    }

    public synchronized void stopRequest() {
        this.setRequestStatus(16);
        SnmpQManager.getTheInstance().removeRequest(this);
        this.requestId = 0;
    }

    public long timeRemainingForAction(long l) {
        switch (this.reqState) {
            case 3: {
                return this.nextPollTime - l;
            }
            case 5: {
                return this.waitTimeForResponse - l;
            }
        }
        return -1L;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("RequestId = " + this.requestId);
        stringBuffer.append("   Status = " + Request.statusDescription(this.reqState));
        stringBuffer.append("  Timeout/MaxRetry/Retry = " + this.timeout + "/" + this.getMaxRetry() + "/" + this.retry);
        if (this.prevPollTime > 0L) {
            this.debugDate.setTime(this.prevPollTime);
            stringBuffer.append("\nPrevPolled = " + this.debugDate.toString());
        } else {
            stringBuffer.append("\nNeverPolled");
        }
        stringBuffer.append(" / RemainingTime(millis) = " + this.timeRemainingForAction(System.currentTimeMillis()));
        return stringBuffer.toString();
    }
}

