/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.MibStoreIfSrv;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.manager.DatagramHandlerIf;
import com.sun.jaw.snmp.manager.MibStore;
import com.sun.jaw.snmp.manager.SnmpSocket;
import com.sun.jaw.snmp.manager.SnmpTrapAgent;
import com.sun.jaw.snmp.manager.SnmpVar;
import com.sun.jaw.snmp.manager.internal.SnmpQManager;
import com.sun.jaw.snmp.manager.internal.SnmpResponseHandler;
import java.net.SocketException;

public class SnmpMain {
    private static SnmpMain snmpMain;
    private static MibStore mibStore;
    private static SnmpTrapAgent snmpTrapAgent;
    SnmpQManager snmpQman = null;

    static {
        snmpTrapAgent = null;
    }

    private SnmpMain() throws SnmpStatusException {
        Object object;
        try {
            object = Class.forName("com.sun.jaw.snmp.manager.MibStore");
            mibStore = (MibStore)((Class)object).newInstance();
            SnmpVar.meta = mibStore;
            SnmpOid.meta = mibStore;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.snmpQman = SnmpQManager.getTheInstance();
        object = new SnmpResponseHandler(this.snmpQman);
        try {
            SnmpSocket snmpSocket = new SnmpSocket((DatagramHandlerIf)object);
            snmpSocket.setDefaultSnmpSocket();
        }
        catch (SocketException socketException) {
            System.err.println("Unable to initialize Snmp Datagram socket.");
            Debug.print((int)2048, (Object)" SnmpMain::new: Unable to initialize Snmp Datagram socket");
            Debug.printException((Exception)socketException);
            throw new SnmpStatusException("Unable to initialize Snmp Datagram Socket");
        }
        Debug.print((int)2048, (Object)" SnmpMain::new: All servers initialized successfully.");
    }

    private SnmpMain(MibStoreIfSrv mibStoreIfSrv) throws SnmpStatusException {
        this();
        MibStore.addMib(mibStoreIfSrv);
    }

    public synchronized void finalize() {
        if (snmpMain == null) {
            return;
        }
        Debug.print((int)2048, (Object)" SnmpMain::finalize: Shutting all servers.");
        snmpMain = null;
        this.snmpQman = null;
    }

    public static MibStoreIfSrv getMibStore() {
        return mibStore;
    }

    public static SnmpTrapAgent getSnmpTrapAgent() {
        return snmpTrapAgent;
    }

    public static synchronized void initializeSNMP() throws SnmpStatusException {
        if (snmpMain == null) {
            Debug.print((int)2048, (Object)" SnmpMain::initializeSNMP: Initializing SNMP internals.");
            snmpMain = new SnmpMain();
        }
        Debug.print((int)2048, (Object)" SnmpMain::initializeSNMP: SNMP internals initialized OK.");
    }

    public static synchronized void initializeSNMP(MibStoreIfSrv mibStoreIfSrv) throws SnmpStatusException {
        if (snmpMain == null) {
            Debug.print((int)2048, (Object)" SnmpMain::initializeSNMP: Initializing SNMP internals.");
            snmpMain = new SnmpMain(mibStoreIfSrv);
        } else {
            MibStore.addMib(mibStoreIfSrv);
        }
        Debug.print((int)2048, (Object)" SnmpMain::initializeSNMP: SNMP internals initialized OK.");
    }

    public static void setSnmpTrapAgent(SnmpTrapAgent snmpTrapAgent) {
        SnmpMain.snmpTrapAgent = snmpTrapAgent;
    }
}

