/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.snmp.common.SnmpPduFactory;
import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.manager.SnmpConst;
import com.sun.jaw.snmp.manager.SnmpParameters;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpPeer
implements Serializable {
    protected int portNum = 161;
    protected int maxVarbindLimit = SnmpConst.MAX_VARBIND_LIMIT;
    protected int maxSnmpPacketSize = SnmpConst.defaultSnmpRequestPktSize;
    protected int maxRetries = 3;
    protected int timeout = 3000;
    protected SnmpPduFactoryIf pduFactory = new SnmpPduFactory();
    private long _maxrtt;
    private long _minrtt;
    private long _avgrtt;
    private SnmpParameters _snmpParameter = new SnmpParameters();
    InetAddress[] _devAddrList = null;
    private InetAddress _devAddr = null;
    int _addrIndex = 0;

    public SnmpPeer(String string) throws UnknownHostException {
        this(string, 161);
    }

    public SnmpPeer(String string, int n) throws UnknownHostException {
        this.useIPAddress(string);
        this.portNum = n;
    }

    public SnmpPeer(InetAddress inetAddress) {
        this._devAddr = inetAddress;
    }

    public boolean allowSnmpSets() {
        return this._snmpParameter.allowSnmpSets();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void finalize() {
        this._devAddr = null;
        this._devAddrList = null;
        this._snmpParameter = null;
    }

    public long getAvgRtt() {
        return this._avgrtt;
    }

    public final InetAddress getDestAddr() {
        return this._devAddr;
    }

    public final InetAddress[] getDestAddrList() {
        return this._devAddrList;
    }

    public final int getDestPort() {
        return this.portNum;
    }

    public final String getDevName() {
        return this.getDestAddr().getHostName();
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public long getMaxRtt() {
        return this._maxrtt;
    }

    public final int getMaxSnmpPktSize() {
        return this.maxSnmpPacketSize;
    }

    public long getMinRtt() {
        return this._minrtt;
    }

    public final SnmpPduFactoryIf getPduFactory() {
        return this.pduFactory;
    }

    public final SnmpParameters getSnmpParam() {
        return this._snmpParameter;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized int getVarbindLimit() {
        return this.maxVarbindLimit;
    }

    public final synchronized String ipAddressInUse() {
        byte[] byArray = this._devAddr.getAddress();
        return new String(String.valueOf(byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF));
    }

    public final synchronized void setDestPort(int n) {
        this.portNum = n;
    }

    public final synchronized void setMaxRetries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxRetries = n;
    }

    public final synchronized void setMaxSnmpPktSize(int n) {
        this.maxSnmpPacketSize = n;
    }

    public final synchronized void setPduFactory(SnmpPduFactoryIf snmpPduFactoryIf) {
        if (snmpPduFactoryIf == null) {
            snmpPduFactoryIf = new SnmpPduFactory();
        }
        this.pduFactory = snmpPduFactoryIf;
    }

    public final synchronized void setSnmpParam(SnmpParameters snmpParameters) {
        this._snmpParameter = snmpParameters;
    }

    public final synchronized void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = n;
    }

    public final synchronized void setVarbindLimit(int n) {
        this.maxVarbindLimit = n;
    }

    public String toString() {
        return "Peer/Port : " + this.getDevName() + "/" + this.getDestPort();
    }

    protected void updateRttStats(long l) {
        if (this._minrtt > l) {
            this._minrtt = l;
        } else if (this._maxrtt < l) {
            this._maxrtt = l;
        } else {
            this._avgrtt = l;
        }
    }

    public final synchronized void useAddressList(InetAddress[] inetAddressArray) {
        this._devAddrList = inetAddressArray;
        this._addrIndex = 0;
        this.useNextAddress();
    }

    public final synchronized void useIPAddress(String string) throws UnknownHostException {
        this._devAddr = InetAddress.getByName(string);
    }

    public final synchronized void useNextAddress() {
        if (this._devAddrList == null) {
            return;
        }
        if (this._addrIndex > this._devAddrList.length) {
            this._addrIndex = 0;
        }
        this._devAddr = this._devAddrList[this._addrIndex++];
    }
}

