/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.SnmpDefinitions;
import com.sun.jaw.snmp.common.SnmpMessage;
import com.sun.jaw.snmp.common.SnmpPduBulk;
import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpPduRequest;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpTooBigException;
import com.sun.jaw.snmp.common.SnmpVarBind;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.SnmpHandlerIf;
import com.sun.jaw.snmp.manager.SnmpParameters;
import com.sun.jaw.snmp.manager.SnmpPeer;
import com.sun.jaw.snmp.manager.SnmpPollRequest;
import com.sun.jaw.snmp.manager.SnmpSession;
import com.sun.jaw.snmp.manager.SnmpSocket;
import com.sun.jaw.snmp.manager.SnmpVar;
import com.sun.jaw.snmp.manager.SnmpVarbindList;
import com.sun.jaw.snmp.manager.Timestamp;
import com.sun.jaw.snmp.manager.internal.ReqRedirectSrvIf;
import com.sun.jaw.snmp.manager.internal.SnmpTooBig;
import java.io.IOException;
import java.io.Serializable;

public class SnmpRequest
extends Request
implements Serializable,
SnmpDefinitions {
    protected SnmpVarbindList varbindList = null;
    protected int errorStatus = 0;
    protected int errorIndex = 0;
    int command = 0;
    protected SnmpPeer thePeer;
    protected SnmpSession session;
    protected SnmpHandlerIf callback = null;
    protected int nonRepeaters = 0;
    protected int maxRepetitions = 0;
    private ReqRedirectSrvIf proxy;
    private SnmpPduPacket requestPdu;
    private SnmpPduRequest responsePdu;
    Timestamp responseTimestamp = null;
    private SnmpVar[] internalVb = null;
    private String reason = null;
    private int options = 7;
    private static final int CREATED_BY_USER = 1;
    private static final int CREATED_INTERNALLY = 2;
    private int mode = 1;

    public SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, int n) throws SnmpStatusException {
        this.session = snmpSession;
        this.thePeer = snmpPeer;
        this.callback = snmpHandlerIf;
        switch (n) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                this.command = n;
                break;
            }
            case 253: {
                this.command = 161;
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command. " + n);
            }
        }
        this.session.addRequest(this);
        this.setTimeout(this.thePeer.timeout);
    }

    public SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, int n, int n2) throws SnmpStatusException {
        this(snmpSession, snmpPeer, snmpHandlerIf, 165);
        this.nonRepeaters = n;
        this.maxRepetitions = n2;
    }

    public final boolean allowMultiplex() {
        return (this.options & 1) == 1;
    }

    public final void cancelRequest() {
        if (this.proxy != null) {
            ReqRedirectSrvIf reqRedirectSrvIf = this.proxy;
            this.proxy = null;
            reqRedirectSrvIf.cancel(this);
        }
        this.deleteRequest();
        this.errorStatus = 225;
        super.stopRequest();
        this.notifyClient();
    }

    private final synchronized SnmpPduPacket constructPduPacket() {
        SnmpPduRequest snmpPduRequest = null;
        Throwable throwable = null;
        try {
            if (this.command == 165) {
                SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                snmpPduBulk.nonRepeaters = this.nonRepeaters;
                snmpPduBulk.maxRepetitions = this.maxRepetitions;
                snmpPduRequest = snmpPduBulk;
            } else {
                SnmpPduRequest snmpPduRequest2;
                snmpPduRequest = snmpPduRequest2 = new SnmpPduRequest();
                snmpPduRequest.type = this.command;
            }
            snmpPduRequest.version = this.getParam().getProtocolVersion();
            snmpPduRequest.community = this.getParam().encodeAuthentication(this.command);
            snmpPduRequest.requestId = this.getRequestId();
            snmpPduRequest.varBindList = this.internalVb;
            if (Debug.isLevelSet((int)2048)) {
                Debug.printFormatted((Object)"SnmpRequest::constructPduPacket: Packet built.");
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            throwable = snmpStatusException;
            this.errorStatus = 227;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception) {
            throwable = exception;
            this.errorStatus = 242;
            this.reason = exception.getMessage();
        }
        if (throwable != null) {
            Debug.printException((Exception)throwable);
            snmpPduRequest = null;
            this.queueResponse();
        }
        return snmpPduRequest;
    }

    protected final synchronized void deleteRequest() {
        this.session.deleteRequest(this);
    }

    public void finalize() {
        this.callback = null;
        this.varbindList = null;
        this.session = null;
        this.thePeer = null;
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
    }

    public boolean fixPduOnError() {
        return (this.options & 2) == 2 && this.command != 165;
    }

    public boolean fixTooBigError() {
        return (this.options & 4) == 4 && this.command != 165;
    }

    final synchronized boolean fixVarbindList(SnmpVar[] snmpVarArray, int n) {
        Debug.print((int)2048, (Object)("SnmpRequest::fixVarbindList: Fix Pdu at index ========" + n));
        int n2 = n;
        SnmpVar snmpVar = null;
        int n3 = 0;
        while (n3 < snmpVarArray.length) {
            if (snmpVarArray[n3] != null && --n < 0) break;
            ++n3;
        }
        if (n3 >= snmpVarArray.length) {
            this.reason = "Fix varbind.: Can't find varbind with idx = " + n2;
            System.err.println(this.reason);
            return false;
        }
        snmpVar = snmpVarArray[n3];
        snmpVarArray[n3] = null;
        switch (this.getCommand()) {
            case 160: {
                snmpVar.setValueNoSuchInstance();
                break;
            }
            case 161: {
                snmpVar.setValueEndOfMibView();
                break;
            }
        }
        return true;
    }

    public final int getCommand() {
        return this.command;
    }

    public final synchronized int getErrorIndex() {
        return this.errorIndex;
    }

    public final synchronized int getErrorStatus() {
        return this.errorStatus;
    }

    public final int getMaxRetry() {
        if (this.command == 163) {
            return 1;
        }
        return this.getPeer().maxRetries;
    }

    public final int getOptions() {
        return this.options;
    }

    public final SnmpParameters getParam() {
        return this.thePeer.getSnmpParam();
    }

    public final SnmpPeer getPeer() {
        return this.thePeer;
    }

    final synchronized String getRequestCreationType() {
        switch (this.mode) {
            case 1: {
                return "UserCreated.";
            }
            case 2: {
                return "Internal_" + this.callback.getClass().getName();
            }
        }
        return "UnknownRequest????";
    }

    public final synchronized SnmpVarbindList getRequestVbList() {
        return this.varbindList;
    }

    public final synchronized SnmpVarbindList getResponseVbList() {
        if (this.inProgress()) {
            return null;
        }
        return this.varbindList;
    }

    public final SnmpSession getSnmpSession() {
        return this.session;
    }

    public final synchronized SnmpVarbindList getVarbindList() {
        return this.varbindList;
    }

    protected void handleError(String string) {
        this.setRequestStatus(128);
        Debug.print((int)2048, (Object)("SnmpRequest::handleError:Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking user defined callback...\n" + this.getVarbindList().vbListToString()));
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.getErrorStatus(), this.getErrorIndex(), this.getVarbindList());
            }
        }
        catch (Exception exception) {
            System.err.println("Exception generated by user callback.");
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("OutOfMemory Error generated by user callback.");
            outOfMemoryError.printStackTrace();
            Thread.currentThread();
            Thread.yield();
        }
    }

    protected void handleInternalError(String string) {
        this.setRequestStatus(64);
        if (this.reason == null) {
            this.reason = string;
        }
        Debug.print((int)2048, (Object)("SnmpRequest::handleInternalError: Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking internal error user defined callback...\n" + this.getVarbindList().vbListToString()));
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpInternalError(this, this.reason);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception generated by user callback.");
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("OutOfMemory Error generated by user callback.");
            outOfMemoryError.printStackTrace();
            Thread.currentThread();
            Thread.yield();
        }
    }

    protected void handleSuccess() {
        this.setRequestStatus(128);
        Debug.print((int)2048, (Object)"SnmpRequest::handleSuccess: NoError. Invoking user defined callback...");
        if (!(this instanceof SnmpPollRequest)) {
            this.deleteRequest();
        }
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.errorStatus, this.errorIndex, this.getVarbindList());
            }
        }
        catch (Exception exception) {
            System.err.println("Exception generated by user callback.");
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("OutOfMemory Error generated by user callback.");
            outOfMemoryError.printStackTrace();
            Thread.currentThread();
            Thread.yield();
        }
    }

    protected void handleTimeout() {
        this.setRequestStatus(32);
        Debug.print((int)2048, (Object)("SnmpRequest::handleTimeout: Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Timeout. Invoking user defined callback..."));
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollTimeout(this);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception generated by user callback.");
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("OutOfMemory Error generated by user callback.");
            outOfMemoryError.printStackTrace();
            Thread.currentThread();
            Thread.yield();
        }
    }

    private boolean handleTooBigError() {
        if (!this.fixTooBigError()) {
            return false;
        }
        if (this.varbindList.size() < 2) {
            this.setErrorStatusAndIndex(232, 0);
            return false;
        }
        try {
            Debug.print((int)2048, (Object)"SnmpRequest::handleTooBigError: Handling Too big error.");
            this.proxy = new SnmpTooBig(this, this.getVarbindList());
            return true;
        }
        catch (Exception exception) {
            this.reason = exception.getMessage();
            this.setErrorStatusAndIndex(240, 0);
            return false;
        }
    }

    protected synchronized void initializeAndFire(long l) {
        this.responsePdu = null;
        this.requestPdu = null;
        this.reason = null;
        this.proxy = null;
        if (l == 0L) {
            super.startRequest(System.currentTimeMillis());
        } else {
            super.startRequest(l);
        }
        this.setErrorStatusAndIndex(0, 0);
    }

    protected final void invokeOnReady() {
        if (this.requestPdu == null) {
            if (this.varbindList.size() > this.getPeer().getVarbindLimit()) {
                Debug.print((int)2048, (Object)("SnmpRequest::invokeOnReady:Attempt toobig. vblist exceeds max allowed for peer. Actual = " + this.varbindList.size() + " Allowed = " + this.getPeer().getVarbindLimit()));
                this.setErrorStatusAndIndex(231, 0);
                if (!this.handleTooBigError()) {
                    this.queueResponse();
                }
                return;
            }
            this.requestPdu = this.constructPduPacket();
        }
        if (this.requestPdu != null && !this.sendPdu()) {
            this.queueResponse();
        }
    }

    public final void invokeOnResponse(Object object) {
        if (object != null) {
            if (object instanceof SnmpPduRequest) {
                this.responsePdu = (SnmpPduRequest)object;
            } else {
                return;
            }
        }
        this.setRequestStatus(9);
        this.queueResponse();
    }

    protected final void invokeOnRetry() {
        this.invokeOnReady();
    }

    protected final void invokeOnTimeout() {
        this.errorStatus = 224;
        this.queueResponse();
    }

    public boolean isInternalRequest() {
        return this.mode == 2;
    }

    public final synchronized void notifyClient() {
        this.notifyAll();
    }

    private final synchronized void parsePduPacket(SnmpPduRequest snmpPduRequest) throws SnmpStatusException {
        if (snmpPduRequest == null) {
            return;
        }
        this.errorStatus = snmpPduRequest.errorStatus;
        this.errorIndex = snmpPduRequest.errorIndex;
        if (this.errorStatus == 0) {
            if (this.command == 165) {
                this.updateVarbindList(snmpPduRequest.varBindList);
            } else {
                this.updateInternalVbWithResult(this.command, snmpPduRequest.varBindList);
            }
            this.responseTimestamp = new Timestamp();
            this.getVarbindList().setTimestamp(this.responseTimestamp);
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        switch (this.errorStatus) {
            case 2: {
                if (!this.fixPduOnError()) break;
                if (this.fixVarbindList(this.internalVb, this.errorIndex)) {
                    if (this.getVarbindList().checkForUnspecifiedValue()) {
                        this.setErrorStatusAndIndex(230, 0);
                        break;
                    }
                    this.setErrorStatusAndIndex(0, 0);
                    break;
                }
                this.setErrorStatusAndIndex(240, 0);
                break;
            }
            case 1: {
                if (!this.fixTooBigError() || this.varbindList.size() <= 1) break;
                this.setErrorStatusAndIndex(231, 0);
                break;
            }
        }
        if (Debug.isLevelSet((int)2048)) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("SnmpRequest::parsePduPacket: Recvd response.  ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
            Debug.print((int)2048, (Object)stringBuffer.toString());
        }
    }

    public final void processResponse() throws SnmpStatusException {
        Debug.print((int)2048, (Object)("SnmpRequest::processResponse: errstatus = " + this.errorStatus));
        if (!this.inProgress()) {
            this.responsePdu = null;
            return;
        }
        if (this.errorStatus >= 240) {
            this.handleInternalError("Internal Error...");
            return;
        }
        try {
            this.parsePduPacket(this.responsePdu);
            this.responsePdu = null;
            switch (this.errorStatus) {
                case 0: {
                    this.handleSuccess();
                    return;
                }
                case 224: {
                    this.handleTimeout();
                    return;
                }
                case 240: {
                    this.handleInternalError("Unknown internal error.  deal with it later!");
                    return;
                }
                case 231: {
                    this.setErrorStatusAndIndex(1, 0);
                    if (this.handleTooBigError()) {
                        return;
                    }
                    this.handleError("Cannot handle too-big situation...");
                    return;
                }
                case 230: {
                    this.initializeAndFire(0L);
                    return;
                }
            }
            if (this.command != 163 && this.command != 165) {
                this.translateErrorIndex();
            }
            this.handleError("Error status set in packet...!!");
            return;
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = 226;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.reason = exception.getMessage();
        }
        this.handleInternalError(this.reason);
    }

    private final void queueResponse() {
        this.getSnmpSession().addResponse(this);
    }

    private boolean sendPdu() {
        try {
            this.responseTimestamp = null;
            this.responsePdu = null;
            SnmpPduFactoryIf snmpPduFactoryIf = this.thePeer.getPduFactory();
            SnmpMessage snmpMessage = snmpPduFactoryIf.encodePdu(this.requestPdu, this.thePeer.getMaxSnmpPktSize());
            if (snmpMessage == null) {
                Debug.print((int)2048, (Object)"SnmpRequest::sendPdu: pdu factory returned a null value.");
                throw new SnmpStatusException(242);
            }
            int n = this.thePeer.getMaxSnmpPktSize();
            byte[] byArray = new byte[n];
            int n2 = snmpMessage.encodeMessage(byArray);
            if (Debug.isLevelSet((int)4096)) {
                Debug.print((int)2048, (Object)(" Dump : \n" + snmpMessage.printMessage()));
            }
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            snmpTooBigException.printStackTrace();
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            Debug.print((int)2048, (Object)"SnmpRequest::sendPdu:Packet Overflow while building Request.");
            return this.handleTooBigError();
        }
        catch (IOException iOException) {
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            this.setErrorStatusAndIndex(242, 0);
            this.reason = exception.getMessage();
        }
        return false;
    }

    final void sendPduPacket(byte[] byArray, int n) throws IOException {
        SnmpSocket snmpSocket;
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("SnmpRequest::sendPduPacket: Send to peer. " + this.thePeer.toString() + "Length = " + n));
        }
        if (Debug.isLevelSet((int)4096)) {
            Debug.print((int)2048, (Object)(" Dump : \n" + SnmpMessage.dumpHexBuffer((byte[])byArray, (int)0, (int)n)));
        }
        SnmpSocket snmpSocket2 = snmpSocket = this.getSnmpSession().getSocket();
        synchronized (snmpSocket2) {
            snmpSocket.sendPacket(byArray, n, this.thePeer.getDestAddr(), this.thePeer.getDestPort());
            this.setRequestSentTime(System.currentTimeMillis());
        }
    }

    final synchronized void setCallback(SnmpHandlerIf snmpHandlerIf) {
        this.callback = snmpHandlerIf;
    }

    public final synchronized void setErrorStatusAndIndex(int n, int n2) {
        this.errorStatus = n;
        this.errorIndex = n2;
    }

    public final void setInternalRequest() {
        this.mode = 2;
    }

    public final synchronized void setOptions(int n) {
        if (!this.inProgress()) {
            this.options = n;
            if (!this.fixPduOnError() || !this.fixTooBigError()) {
                this.options &= 0xFFFFFFFE;
            }
        }
    }

    public final void setProxyObject(ReqRedirectSrvIf reqRedirectSrvIf) {
        this.proxy = reqRedirectSrvIf;
    }

    public final synchronized void setVarbindList(SnmpVarbindList snmpVarbindList) {
        this.varbindList = snmpVarbindList;
        if (this.internalVb == null || this.internalVb.length != this.varbindList.size()) {
            this.internalVb = new SnmpVar[this.varbindList.size()];
        }
        this.varbindList.copyInto(this.internalVb);
    }

    public static String snmpErrorToString(int n) {
        switch (n) {
            case 0: {
                return "NoError";
            }
            case 1: {
                return "TooBig";
            }
            case 2: {
                return "NoSuchName";
            }
            case 3: {
                return "BadValue";
            }
            case 4: {
                return "ReadOnly";
            }
            case 5: {
                return "GeneralError";
            }
            case 225: {
                return "UserAborted";
            }
            case 227: {
                return "EncodingError";
            }
            case 228: {
                return "RequestPacketOverflow";
            }
            case 229: {
                return "EndOfTable";
            }
            case 240: {
                return "InternalError";
            }
            case 224: {
                return "Timeout";
            }
        }
        return "Unknown Error = " + n;
    }

    public synchronized void start(SnmpVarbindList snmpVarbindList, long l) throws SnmpStatusException {
        this.start(snmpVarbindList, true, l);
    }

    public synchronized void start(SnmpVarbindList snmpVarbindList, boolean bl, long l) throws SnmpStatusException {
        if (this.inProgress()) {
            throw new SnmpStatusException("Request already in progress.");
        }
        switch (this.getCommand()) {
            case 163: {
                if (this.getParam().getProtocolVersion() == 1) {
                    this.options = 0;
                }
                if (bl) {
                    this.setVarbindList((SnmpVarbindList)snmpVarbindList.clone());
                    break;
                }
                this.setVarbindList(snmpVarbindList);
                break;
            }
            case 160: 
            case 161: 
            case 165: {
                if (bl) {
                    this.setVarbindList(snmpVarbindList.cloneWithoutValue());
                    break;
                }
                this.setVarbindList(snmpVarbindList);
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command.  Should never happen. ??!! " + this.getCommand());
            }
        }
        this.initializeAndFire(l);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(String.valueOf(super.toString()) + " " + this.getRequestCreationType());
        stringBuffer.append("\n" + this.thePeer.toString());
        stringBuffer.append(" SnmpCmd = " + SnmpPduPacket.pduTypeToString((int)this.command));
        stringBuffer.append("  RequestOptions = " + this.options);
        return stringBuffer.toString();
    }

    final void translateErrorIndex() {
        if (!this.fixPduOnError()) {
            return;
        }
        SnmpVarbindList snmpVarbindList = this.getVarbindList();
        int n = snmpVarbindList.size();
        int n2 = 0;
        while (n2 < n) {
            if (!snmpVarbindList.getSnmpVarAt(n2).hasVbException()) {
                --this.errorIndex;
                if (this.errorIndex == 0) {
                    this.errorIndex = n2;
                    return;
                }
            }
            ++n2;
        }
    }

    private void updateInternalVbWithResult(int n, SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null || snmpVarBindArray.length == 0) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case 160: 
            case 163: {
                int n3 = 0;
                while (n3 < this.internalVb.length && n2 < snmpVarBindArray.length) {
                    SnmpVar snmpVar = this.internalVb[n3];
                    if (snmpVar != null) {
                        SnmpVarBind snmpVarBind = snmpVarBindArray[n2];
                        snmpVar.setSnmpValue(snmpVarBind.value);
                        ++n2;
                    }
                    ++n3;
                }
                break;
            }
            case 161: {
                int n4 = 0;
                while (n4 < this.internalVb.length && n2 < snmpVarBindArray.length) {
                    SnmpVar snmpVar = this.internalVb[n4];
                    if (snmpVar != null) {
                        SnmpVarBind snmpVarBind = snmpVarBindArray[n2];
                        snmpVar.setSnmpValue(snmpVarBind.value);
                        snmpVar.oid = snmpVarBind.oid;
                        ++n2;
                    }
                    ++n4;
                }
                break;
            }
        }
    }

    private void updateVarbindList(SnmpVarBind[] snmpVarBindArray) {
        this.varbindList = new SnmpVarbindList();
        int n = 0;
        while (n < snmpVarBindArray.length) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[n];
            SnmpVar snmpVar = new SnmpVar(snmpVarBind.oid);
            snmpVar.setSnmpValue(snmpVarBind.value);
            this.varbindList.addVariable(snmpVar);
            ++n;
        }
    }

    public final boolean waitForCompletion(long l) throws SnmpStatusException {
        if (!this.inProgress()) {
            return true;
        }
        if (this instanceof SnmpPollRequest) {
            throw new SnmpStatusException("Not supported for SnmpPollRequest objects");
        }
        if (this.session.thisSessionContext()) {
            SnmpHandlerIf snmpHandlerIf = this.callback;
            this.callback = null;
            this.session.waitForResponse(this, l);
            this.callback = snmpHandlerIf;
        } else {
            SnmpRequest snmpRequest = this;
            synchronized (snmpRequest) {
                SnmpHandlerIf snmpHandlerIf = this.callback;
                try {
                    this.callback = null;
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
                this.callback = snmpHandlerIf;
            }
        }
        return this.inProgress() ^ true;
    }
}

