/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.SnmpDefinitions;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.SnmpAuthHandlerIf;
import com.sun.jaw.snmp.manager.SnmpHandlerIf;
import com.sun.jaw.snmp.manager.SnmpManagerSrvIf;
import com.sun.jaw.snmp.manager.SnmpOptions;
import com.sun.jaw.snmp.manager.SnmpPeer;
import com.sun.jaw.snmp.manager.SnmpPollRequest;
import com.sun.jaw.snmp.manager.SnmpRequest;
import com.sun.jaw.snmp.manager.SnmpSocket;
import com.sun.jaw.snmp.manager.SnmpVarbindList;
import com.sun.jaw.snmp.manager.internal.SnmpQManager;
import com.sun.jaw.snmp.manager.internal.SnmpResponseHandler;
import java.io.Serializable;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public final class SnmpSession
implements SnmpManagerSrvIf,
SnmpDefinitions,
Runnable,
Serializable {
    SnmpAuthHandlerIf auth;
    private Thread _myThread = null;
    private Stack _respq = new Stack();
    private SnmpSocket _theSocket = null;
    private SnmpPeer _defaultPeer = null;
    private Request _syncReq;
    public String sessionName;
    private Hashtable _requestList = new Hashtable();
    public SnmpOptions snmpOptions = new SnmpOptions();
    private static final String sccs_id = "@(#)SnmpSession.java 3.5 99/06/23 SMI";

    public SnmpSession(String string) {
        this(string, null);
    }

    public SnmpSession(String string, SnmpAuthHandlerIf snmpAuthHandlerIf) {
        this.sessionName = string;
        this.initialize();
    }

    public SnmpSession(String string, SnmpPeer snmpPeer, SnmpAuthHandlerIf snmpAuthHandlerIf) {
        this(string, snmpAuthHandlerIf);
        this._defaultPeer = snmpPeer;
    }

    final synchronized void addRequest(Request request) throws SnmpStatusException {
        this.checkSanity();
        this._requestList.put(request, request);
    }

    protected void addResponse(Request request) {
        SnmpRequest snmpRequest = (SnmpRequest)request;
        if (this.isSessionActive()) {
            if (this.syncInProgress() && (snmpRequest = (SnmpRequest)request).isInternalRequest()) {
                if (Debug.isLevelSet((int)2048)) {
                    Debug.print((int)2048, (Object)("SnmpSession::addResponse: Session in sync mode.  processing internal request only .. " + request.getRequestId()));
                }
                this.processResponse(request);
                return;
            }
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this._respq.push(request);
                this.notifyAll();
            }
        } else {
            System.err.println("Peer thread dead.  So response is dropped..." + request.getRequestId());
        }
    }

    public boolean anyPendingResponses() {
        return this._respq.isEmpty() ^ true;
    }

    public final synchronized void cancelAllRequests() {
        if (this._requestList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this._requestList.elements();
        while (enumeration.hasMoreElements()) {
            ((Request)enumeration.nextElement()).cancelRequest();
        }
        this._requestList.clear();
    }

    private synchronized void cancelAllResponses() {
        if (this._respq != null) {
            this._syncReq = null;
            this._respq.removeAllElements();
            this.notifyAll();
        }
    }

    public boolean checkResponseFor(Request request) {
        return this._respq.contains(request);
    }

    synchronized boolean checkSanity() throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(String.valueOf(this.sessionName) + " : Session is dead...");
        }
        return true;
    }

    protected final synchronized void deleteRequest(SnmpRequest snmpRequest) {
        this._requestList.remove(snmpRequest);
        if (this._syncReq != null && this._syncReq == snmpRequest) {
            this.resetSyncMode();
        }
    }

    public final synchronized void destroySession() {
        this.cancelAllRequests();
        this.cancelAllResponses();
        this.getSocket().deregister(this);
        this._theSocket = null;
        this.killSessionThread();
    }

    public void finalize() {
        if (this._respq != null) {
            this._respq.removeAllElements();
        }
        this._respq = null;
        if (this._theSocket != null) {
            this._theSocket.close();
        }
        this._theSocket = null;
    }

    public synchronized Vector getAllRequestsForPeer(SnmpPeer snmpPeer) {
        Vector<SnmpRequest> vector = new Vector<SnmpRequest>();
        Enumeration enumeration = this._requestList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpRequest snmpRequest = (SnmpRequest)enumeration.nextElement();
            if (snmpRequest.getPeer() != snmpPeer) continue;
            vector.addElement(snmpRequest);
        }
        return vector;
    }

    public final SnmpPeer getDefaultPeer() {
        return this._defaultPeer;
    }

    protected final Thread getDispatcher() {
        return this._myThread;
    }

    public final String getName() {
        return this.sessionName;
    }

    public final SnmpSocket getSocket() {
        return this._theSocket;
    }

    private synchronized void initialize() {
        if (this._theSocket == null) {
            this._theSocket = SnmpSocket.getDefaultSnmpSocket();
        }
        this._theSocket.register(this);
        if (this._myThread == null) {
            this._myThread = new Thread(this);
        }
        if (!this._myThread.isAlive()) {
            this._myThread.start();
        }
    }

    public final synchronized boolean isEquivalent(SnmpSession snmpSession) {
        if (this == snmpSession) {
            return true;
        }
        return this.getSocket().equals(snmpSession.getSocket());
    }

    public final synchronized boolean isSessionActive() {
        return this._myThread != null && this._myThread.isAlive();
    }

    private synchronized void killSessionThread() {
        if (this.isSessionActive()) {
            Debug.print((int)2048, (Object)("SnmpSession::killSessionThread: Destroying session " + this.sessionName));
            if (Thread.currentThread() != this._myThread) {
                this._myThread = null;
                this.notifyAll();
            } else {
                this._myThread = null;
            }
        }
    }

    final SnmpRequest makeAsyncBulkRequest(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n, int n2) throws SnmpStatusException {
        this.checkSanity();
        SnmpRequest snmpRequest = new SnmpRequest(this, snmpPeer, snmpHandlerIf, n, n2);
        snmpRequest.setOptions(this.snmpOptions.getOptions());
        snmpRequest.start(snmpVarbindList, true, 0L);
        return snmpRequest;
    }

    final SnmpPollRequest makeAsyncPollRequest(SnmpPeer snmpPeer, int n, SnmpHandlerIf snmpHandlerIf, int n2, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        this.checkSanity();
        SnmpPollRequest snmpPollRequest = new SnmpPollRequest(this, snmpPeer, snmpHandlerIf, n);
        snmpPollRequest.setPollFrequency(n2);
        snmpPollRequest.setOptions(this.snmpOptions.getOptions());
        snmpPollRequest.startPoll(snmpVarbindList, true, 0);
        return snmpPollRequest;
    }

    final SnmpRequest makeAsyncRequest(SnmpPeer snmpPeer, int n, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        this.checkSanity();
        SnmpRequest snmpRequest = new SnmpRequest(this, snmpPeer, snmpHandlerIf, n);
        snmpRequest.setOptions(this.snmpOptions.getOptions());
        snmpRequest.start(snmpVarbindList, true, 0L);
        return snmpRequest;
    }

    synchronized Request nextResponse(long l) {
        if (this._respq.isEmpty()) {
            try {
                if (Debug.isLevelSet((int)2048)) {
                    Debug.print((int)2048, (Object)"SnmpSession::nextResponse: Blocking for response.");
                }
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._respq.isEmpty()) {
            return null;
        }
        Request request = (Request)this._respq.firstElement();
        this._respq.removeElementAt(0);
        return request;
    }

    private void processResponse(Request request) {
        while (request != null && this._myThread != null) {
            try {
                if (request == null) continue;
                if (Debug.isLevelSet((int)2048)) {
                    Debug.printFormatted((Object)("SnmpSession::run: Processing response to req = " + request.getRequestId()));
                }
                request.processResponse();
                request = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                request = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.err.println("OutofMemory error in Session thread " + this.sessionName);
                outOfMemoryError.printStackTrace();
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    private synchronized void resetSyncMode() {
        if (this._syncReq == null) {
            return;
        }
        this._syncReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    public void run() {
        this._myThread = Thread.currentThread();
        this._myThread.setPriority(5);
        this.initialize();
        Request request = null;
        while (this._myThread != null) {
            try {
                request = this.nextResponse(0L);
                if (request == null) continue;
                this.processResponse(request);
            }
            catch (ThreadDeath threadDeath) {
                this._myThread = null;
                Debug.print((int)2048, (Object)("SnmpSession::run: Session thread Unexpectedly shutting down " + this.sessionName));
                throw threadDeath;
            }
        }
        Debug.print((int)2048, (Object)("SnmpSession::run: Session thread shutting down" + this.sessionName));
        this._myThread = null;
    }

    public final void setDefaultPeer(SnmpPeer snmpPeer) {
        this._defaultPeer = snmpPeer;
    }

    public final void setName(String string) {
        if (string == null) {
            string = "UnNamedSession";
        } else {
            this.sessionName = string;
        }
    }

    private synchronized void setSyncMode(Request request) {
        this._syncReq = request;
    }

    public final SnmpRequest snmpGet(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        return this.snmpGet(this._defaultPeer, snmpHandlerIf, snmpVarbindList);
    }

    public final SnmpRequest snmpGet(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        return this.makeAsyncRequest(snmpPeer, 160, snmpHandlerIf, snmpVarbindList);
    }

    public final SnmpRequest snmpGetBulk(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n, int n2) throws SnmpStatusException {
        return this.snmpGetBulk(this._defaultPeer, snmpHandlerIf, snmpVarbindList, n, n2);
    }

    public final SnmpRequest snmpGetBulk(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n, int n2) throws SnmpStatusException {
        return this.makeAsyncBulkRequest(snmpPeer, snmpHandlerIf, snmpVarbindList, n, n2);
    }

    public final SnmpRequest snmpGetNext(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        return this.snmpGetNext(this._defaultPeer, snmpHandlerIf, snmpVarbindList);
    }

    public final SnmpRequest snmpGetNext(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        return this.makeAsyncRequest(snmpPeer, 161, snmpHandlerIf, snmpVarbindList);
    }

    public final SnmpRequest snmpGetNextPoll(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n) throws SnmpStatusException {
        return this.snmpGetNextPoll(this._defaultPeer, snmpHandlerIf, snmpVarbindList, n);
    }

    public final SnmpRequest snmpGetNextPoll(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n) throws SnmpStatusException {
        return this.makeAsyncPollRequest(snmpPeer, 161, snmpHandlerIf, n, snmpVarbindList);
    }

    public final SnmpRequest snmpGetPoll(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n) throws SnmpStatusException {
        return this.snmpGetPoll(this._defaultPeer, snmpHandlerIf, snmpVarbindList, n);
    }

    public final SnmpRequest snmpGetPoll(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, int n) throws SnmpStatusException {
        return this.makeAsyncPollRequest(snmpPeer, 160, snmpHandlerIf, n, snmpVarbindList);
    }

    public final SnmpRequest snmpSet(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        return this.snmpSet(this._defaultPeer, snmpHandlerIf, snmpVarbindList);
    }

    public final SnmpRequest snmpSet(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        if (snmpVarbindList.isEmpty()) {
            throw new SnmpStatusException("Varbind list is empty for SNMP Set.");
        }
        if (!snmpPeer.allowSnmpSets()) {
            throw new SnmpStatusException("Parameters may not have been configured for doing SNMP SET's.");
        }
        if (!snmpVarbindList.checkForValidValues()) {
            throw new SnmpStatusException("One or more varbind has no valid value.");
        }
        return this.makeAsyncRequest(snmpPeer, 163, snmpHandlerIf, snmpVarbindList);
    }

    public final SnmpRequest snmpWalkUntil(SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, SnmpOid snmpOid) throws SnmpStatusException {
        return this.snmpWalkUntil(this._defaultPeer, snmpHandlerIf, snmpVarbindList, snmpOid);
    }

    public final SnmpRequest snmpWalkUntil(SnmpPeer snmpPeer, SnmpHandlerIf snmpHandlerIf, SnmpVarbindList snmpVarbindList, SnmpOid snmpOid) throws SnmpStatusException {
        this.checkSanity();
        SnmpPollRequest snmpPollRequest = new SnmpPollRequest(this, snmpPeer, snmpHandlerIf, 253);
        snmpPollRequest.setOptions(this.snmpOptions.getOptions());
        snmpPollRequest.startPoll(snmpVarbindList, snmpOid, true, 0);
        return snmpPollRequest;
    }

    public synchronized boolean syncInProgress() {
        return this._syncReq != null;
    }

    public boolean thisSessionContext() {
        return Thread.currentThread() == this.getDispatcher();
    }

    public final String toString() {
        return "SnmpSession : " + this.sessionName;
    }

    public final synchronized void useExclusiveSocket() throws SocketException {
        SnmpResponseHandler snmpResponseHandler = new SnmpResponseHandler(SnmpQManager.getTheInstance());
        SnmpSocket snmpSocket = new SnmpSocket(snmpResponseHandler);
        this.useExclusiveSocket(snmpSocket);
    }

    public final synchronized void useExclusiveSocket(SnmpSocket snmpSocket) {
        if (this._theSocket != null) {
            this._theSocket.deregister(this);
        }
        this._theSocket = snmpSocket;
        this._theSocket.register(this);
    }

    void waitForResponse(Request request, long l) {
        if (!request.inProgress()) {
            return;
        }
        this.setSyncMode(request);
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("SnmpSession::waitForResponse: Session switching to sync mode for request " + request.getRequestId()));
        }
        long l2 = l <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + l;
        while (request.inProgress() || this.syncInProgress()) {
            l = l2 - System.currentTimeMillis();
            if (l <= 0L) break;
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this._respq.removeElement(request)) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Object var7_6 = null;
                    continue;
                }
            }
            try {
                this.processResponse(request);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.resetSyncMode();
    }
}

