/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.manager.DatagramHandlerIf;
import com.sun.jaw.snmp.manager.SnmpConst;
import com.sun.jaw.snmp.manager.internal.SnmpQManager;
import com.sun.jaw.snmp.manager.internal.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SnmpSocket
implements Runnable {
    int responseBufSize = SnmpConst.defaultSnmpResponsePktSize;
    private int _pktsSent = 0;
    private int _pktsRecvd = 0;
    private int _errors = 0;
    private DatagramHandlerIf _dgramHdlr = null;
    private static SnmpSocket _defaultSnmpSocket = null;
    private Thread _sockThread = null;
    private DatagramSocket _socket;
    private Hashtable _hashList = new Hashtable();
    private byte[] _buffer = null;

    public SnmpSocket(DatagramHandlerIf datagramHandlerIf) throws SocketException {
        Debug.print((int)2048, (Object)"SnmpSocket::new: Creating new SnmpSocket...");
        this._socket = new DatagramSocket();
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = datagramHandlerIf;
        this._sockThread = new Thread(this);
        this._sockThread.start();
    }

    public synchronized void close() {
        if (this == SnmpSocket.getDefaultSnmpSocket()) {
            return;
        }
        if (this._hashList.isEmpty()) {
            Debug.print((int)2048, (Object)("SnmpSocket::close: Closing and destroying socket -> " + this.toString()));
            if (this._socket != null) {
                this._socket.close();
            }
            this._socket = null;
            if (this._sockThread != null && this._sockThread.isAlive()) {
                this._sockThread.stop();
            }
            this._sockThread = null;
        }
    }

    public static final synchronized SnmpSocket createNewDefaultSnmpSocket() throws SocketException {
        SnmpResponseHandler snmpResponseHandler = new SnmpResponseHandler(SnmpQManager.getTheInstance());
        SnmpSocket snmpSocket = new SnmpSocket(snmpResponseHandler);
        snmpSocket.setDefaultSnmpSocket();
        return snmpSocket;
    }

    public final synchronized void deregister(Object object) {
        this._hashList.remove(object);
        Debug.print((int)2048, (Object)("SnmpSocket::deregister: DeRegisterUser. -> " + object.toString()));
        this.close();
    }

    public synchronized void finalize() {
        this.close();
    }

    public final synchronized Enumeration getAllRegisteredUsers() {
        return this._hashList.elements();
    }

    public static final SnmpSocket getDefaultSnmpSocket() {
        return _defaultSnmpSocket;
    }

    public final synchronized int getInPkts() {
        return this._pktsRecvd;
    }

    public final synchronized int getOutPkts() {
        return this._pktsSent;
    }

    public final synchronized int getPktsErrors() {
        return this._errors;
    }

    public final int getResponsePktSize() {
        return this.responseBufSize;
    }

    public final synchronized int getUserCount() {
        return this._hashList.size();
    }

    private synchronized void handleDatagram(DatagramPacket datagramPacket) {
        this._dgramHdlr.processDatagram(datagramPacket);
    }

    private synchronized void handleJavaError(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            throwable.printStackTrace();
            Thread.currentThread();
            Thread.yield();
            return;
        }
        this._socket.close();
        this._socket = null;
        System.err.println("SnmpSocket : Global Internal error");
        Thread.currentThread();
        Thread.yield();
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public final synchronized void performResetPktStatistics() {
        this._pktsSent = 0;
        this._pktsRecvd = 0;
        this._errors = 0;
    }

    public final synchronized void register(Object object) {
        this._hashList.put(object, object);
        Debug.print((int)2048, (Object)("SnmpSocket::register: RegisterUser. -> " + object.toString()));
    }

    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(this._buffer, this._buffer.length);
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("SnmpSocket::run: " + Thread.currentThread().toString() + " : Blocking for Receiveing packet."));
                    }
                    this._socket.receive(datagramPacket);
                    ++this._pktsRecvd;
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("SnmpSocket::run:" + Thread.currentThread().toString() + " : Received a packet."));
                    }
                    if (datagramPacket.getLength() <= 0) continue block5;
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("SnmpSocket::run: Received packet.  From : " + datagramPacket.getAddress().toString() + "  Length = " + datagramPacket.getLength()));
                    }
                    this.handleDatagram(datagramPacket);
                }
            }
            catch (IOException iOException) {
                ++this._errors;
                System.err.println(iOException.getMessage());
                if (this._socket != null) {
                    this._socket.close();
                }
                this._socket = null;
                if (this._sockThread != null && this._sockThread.isAlive()) {
                    this._sockThread.stop();
                }
                this._sockThread = null;
                continue;
            }
            catch (Exception exception) {
                ++this._errors;
                System.err.println("Exception in socket thread....");
                exception.printStackTrace();
                continue;
            }
            catch (ThreadDeath threadDeath) {
                ++this._errors;
                System.err.println("Socket Thread DEAD........" + this.toString());
                this._sockThread = null;
                this.close();
                throw threadDeath;
            }
            catch (Error error) {
                ++this._errors;
                this.handleJavaError(error);
                continue;
            }
            break;
        }
    }

    public synchronized void sendPacket(DatagramPacket datagramPacket) throws IOException {
        block4: {
            try {
                if (this.isValid()) {
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("SnmpSocket::sendPacket: Sending DgramPkt. Length = " + datagramPacket.getLength() + " through Socket = " + this._socket.toString()));
                    }
                    this._socket.send(datagramPacket);
                    ++this._pktsSent;
                    break block4;
                }
                throw new IOException("Invalid state of SnmpSocket.");
            }
            catch (IOException iOException) {
                System.err.println("Io error while sending");
                System.err.println(iOException.getMessage());
                ++this._errors;
                throw iOException;
            }
        }
    }

    public synchronized void sendPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, n2);
        this.sendPacket(datagramPacket);
    }

    public final synchronized void setDefaultSnmpSocket() throws SocketException {
        if (this.isValid()) {
            if (_defaultSnmpSocket != null) {
                SnmpSocket snmpSocket = _defaultSnmpSocket;
                synchronized (snmpSocket) {
                    _defaultSnmpSocket = this;
                }
            } else {
                _defaultSnmpSocket = this;
            }
        } else {
            throw new SocketException("Cannot set an invalid socket as default.");
        }
    }

    public final synchronized void setResponsePktSize(int n) {
        if (this.responseBufSize != n) {
            this.responseBufSize = n;
            this._buffer = new byte[this.responseBufSize];
        }
    }

    public synchronized String toString() {
        String string = "SnmpSocket : ";
        string = this.isValid() ? String.valueOf(string) + this._socket.toString() : String.valueOf(string) + "Socket invalid state. ";
        string = String.valueOf(string) + " User count = " + this._hashList.size() + " Pkts Sent = " + this._pktsSent + " Pkts Recvd = " + this._pktsRecvd + " Errors = " + this._errors;
        return string;
    }
}

