/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.SnmpMessage;
import com.sun.jaw.snmp.common.SnmpPduFactory;
import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpPduRequest;
import com.sun.jaw.snmp.common.SnmpPduTrap;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.manager.SnmpConst;
import com.sun.jaw.snmp.manager.SnmpMain;
import com.sun.jaw.snmp.manager.SnmpTrapListener;
import com.sun.jaw.snmp.manager.SnmpV2TrapListener;
import com.sun.jaw.snmp.manager.internal.SnmpTrapHandler;
import com.sun.jaw.snmp.manager.internal.SnmpV2TrapHandler;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpTrapAgent
implements Runnable {
    private int port = 162;
    private DatagramSocket dSocket = null;
    private Vector trapReceivers;
    private Vector v2TrapReceivers;
    private SnmpPduFactoryIf pduFactory = new SnmpPduFactory();

    public SnmpTrapAgent() throws SocketException, SnmpStatusException {
        this(162);
    }

    public SnmpTrapAgent(int n) throws SocketException, SnmpStatusException {
        SnmpMain.initializeSNMP();
        this.port = n;
        this.dSocket = new DatagramSocket(this.port);
        this.trapReceivers = new Vector();
        this.v2TrapReceivers = new Vector();
    }

    public void addTrapListener(SnmpTrapListener snmpTrapListener) {
        this.trapReceivers.addElement(snmpTrapListener);
    }

    public void addV2TrapListener(SnmpV2TrapListener snmpV2TrapListener) {
        this.v2TrapReceivers.addElement(snmpV2TrapListener);
    }

    public boolean containsTrapReceiver(SnmpTrapListener snmpTrapListener) {
        return this.trapReceivers.contains(snmpTrapListener);
    }

    public boolean containsV2TrapReceiver(SnmpV2TrapListener snmpV2TrapListener) {
        return this.v2TrapReceivers.contains(snmpV2TrapListener);
    }

    public SnmpPduFactoryIf getPduFactory() {
        return this.pduFactory;
    }

    public Enumeration getTrapListeners() {
        return this.trapReceivers.elements();
    }

    public Enumeration getV2TrapListeners() {
        return this.v2TrapReceivers.elements();
    }

    public void removeTrapListener(SnmpTrapListener snmpTrapListener) {
        this.trapReceivers.removeElement(snmpTrapListener);
    }

    public void removeV2TrapListener(SnmpV2TrapListener snmpV2TrapListener) {
        this.v2TrapReceivers.removeElement(snmpV2TrapListener);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread thread;
                    Runnable runnable;
                    Object object;
                    Enumeration enumeration;
                    Vector vector;
                    SnmpPduTrap snmpPduTrap;
                    byte[] byArray = new byte[SnmpConst.defaultSnmpRequestPktSize];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, SnmpConst.defaultSnmpRequestPktSize);
                    this.dSocket.setSoTimeout(0);
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)"SnmpTrapAgent::run: now waiting for traps");
                    }
                    this.dSocket.receive(datagramPacket);
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)"SnmpTrapAgent::run: received a packet");
                    }
                    SnmpMessage snmpMessage = new SnmpMessage();
                    snmpMessage.address = datagramPacket.getAddress();
                    snmpMessage.port = datagramPacket.getPort();
                    snmpMessage.decodeMessage(datagramPacket.getData(), datagramPacket.getLength());
                    SnmpPduPacket snmpPduPacket = this.pduFactory.decodePdu(snmpMessage);
                    if (snmpPduPacket.type == 164) {
                        snmpPduTrap = (SnmpPduTrap)snmpPduPacket;
                        vector = this.trapReceivers;
                        synchronized (vector) {
                            enumeration = this.trapReceivers.elements();
                            while (enumeration.hasMoreElements()) {
                                object = (SnmpTrapListener)enumeration.nextElement();
                                runnable = new SnmpTrapHandler((SnmpTrapListener)object, snmpPduTrap);
                                thread = new Thread(runnable);
                                thread.start();
                            }
                        }
                    }
                    if (snmpPduPacket.type == 167) {
                        snmpPduTrap = (SnmpPduRequest)snmpPduPacket;
                        vector = this.v2TrapReceivers;
                        synchronized (vector) {
                            enumeration = this.v2TrapReceivers.elements();
                            while (enumeration.hasMoreElements()) {
                                object = (SnmpV2TrapListener)enumeration.nextElement();
                                runnable = new SnmpV2TrapHandler((SnmpV2TrapListener)object, (SnmpPduRequest)snmpPduTrap);
                                thread = new Thread(runnable);
                                thread.start();
                            }
                        }
                    }
                    Debug.print((int)2048, (Object)"SnmpTrapAgent::run: trashed the packet because it's not a trap");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setPduFactory(SnmpPduFactoryIf snmpPduFactoryIf) {
        if (snmpPduFactoryIf == null) {
            snmpPduFactoryIf = new SnmpPduFactory();
        }
        this.pduFactory = snmpPduFactoryIf;
    }
}

