/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager.internal;

import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.SnmpPeer;
import com.sun.jaw.snmp.manager.SnmpRequest;
import java.net.InetAddress;
import java.util.Vector;

class SendQ
extends Vector {
    final long sendQ_pollMargin = 0L;

    SendQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized void addRequest(Request request) {
        long l = request.getAbsNextPollTime();
        int n = this.size();
        while (n > 0) {
            if (l < this.getRequestAt(n - 1).getAbsNextPollTime()) break;
            --n;
        }
        if (n == this.size()) {
            this.addElement(request);
            this.notifyClients();
        } else {
            this.insertElementAt(request, n);
        }
    }

    public synchronized SnmpPduFactoryIf findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactoryIf snmpPduFactoryIf = null;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2 && snmpPduFactoryIf == null) {
            SnmpPeer snmpPeer;
            Request request = this.getRequestAt(n3);
            if (request instanceof SnmpRequest && (snmpPeer = ((SnmpRequest)request).getPeer()).getDestAddr().equals(inetAddress) && snmpPeer.getDestPort() == n) {
                snmpPduFactoryIf = snmpPeer.getPduFactory();
            }
            ++n3;
        }
        return snmpPduFactoryIf;
    }

    public synchronized Vector getAllOutstandingRequest(long l) {
        Vector<Request> vector = new Vector<Request>();
        block0: do {
            this.waitUntilReady();
            long l2 = System.currentTimeMillis() + l;
            int n = this.size();
            while (n > 0) {
                Request request = this.getRequestAt(n - 1);
                if (request.getAbsNextPollTime() > l2) continue block0;
                vector.addElement(request);
                --n;
            }
        } while (vector.isEmpty());
        this.elementCount -= vector.size();
        return vector;
    }

    public synchronized Request getOutstandingRequest() {
        this.waitUntilReady();
        Request request = (Request)this.lastElement();
        --this.elementCount;
        return request;
    }

    public Request getRequestAt(int n) {
        return (Request)this.elementAt(n);
    }

    synchronized void introduceSleep(long l) {
        long l2 = System.currentTimeMillis();
        while (true) {
            try {
                this.wait(l);
                if (System.currentTimeMillis() - l2 < l) continue;
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized String printAllRequest(long l) {
        if (this.isEmpty()) {
            return "------- SendQ empty.......";
        }
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer("\n------------------------ Requests in SendQ -> " + n);
        int n2 = 0;
        while (n2 < n) {
            Request request = this.getRequestAt(n2);
            stringBuffer.append("\n" + n2 + ". (" + request.toString() + " RemainingTimeToSend = " + request.timeRemainingForAction(l) + "  ) ................................\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public synchronized Request removeRequest(long l) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Request request = this.getRequestAt(n2);
            if (l == (long)request.getRequestId()) {
                this.removeElementAt(n2);
                return request;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty()) {
            System.err.println(String.valueOf(Thread.currentThread().toString()) + " Fatal BUG ::: Blocking on newq permenantly.  But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized boolean waitUntilReady() {
        while (true) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                Request request = (Request)this.lastElement();
                l = request.getAbsNextPollTime() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
    }
}

