/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager.internal;

import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.internal.SendQ;
import com.sun.jaw.snmp.manager.internal.SnmpSendServer;
import com.sun.jaw.snmp.manager.internal.SnmpTimerServer;
import com.sun.jaw.snmp.manager.internal.WaitQ;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;

public final class SnmpQManager
implements Serializable {
    static final long pollMargin = 900L;
    private SendQ newq = new SendQ(20, 5);
    private WaitQ waitq = new WaitQ(20, 5);
    private static SnmpQManager theSnmpq = new SnmpQManager();
    private ThreadGroup queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
    private Thread requestQThread = null;
    private Thread timerQThread = null;

    private SnmpQManager() {
        this.startQThreads();
    }

    public void addRequest(Request request) {
        this.newq.addRequest(request);
    }

    public void addWaiting(Request request) {
        this.waitq.addWaiting(request);
    }

    public SnmpPduFactoryIf findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactoryIf snmpPduFactoryIf = this.newq.findPduFactory(inetAddress, n);
        if (snmpPduFactoryIf == null) {
            snmpPduFactoryIf = this.waitq.findPduFactory(inetAddress, n);
        }
        return snmpPduFactoryIf;
    }

    public Vector getAllOutstandingRequest(long l) {
        return this.newq.getAllOutstandingRequest(l);
    }

    public Request getOutstandingRequest() {
        return this.newq.getOutstandingRequest();
    }

    public static SnmpQManager getTheInstance() {
        return theSnmpq;
    }

    public Request getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    public String listQContents() {
        try {
            long l = System.currentTimeMillis();
            StringBuffer stringBuffer = new StringBuffer("******* Qdump begins ****\n");
            stringBuffer.append(String.valueOf(this.newq.printAllRequest(l)) + "\n");
            stringBuffer.append(String.valueOf(this.waitq.printAllRequest(l)) + "\n");
            stringBuffer.append("********* Qdump ends ***********\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Request removeRequest(long l) {
        Request request = null;
        request = this.newq.removeRequest(l);
        if (request == null) {
            request = this.waitq.removeRequest(l);
        }
        return request;
    }

    public void removeRequest(Request request) {
        this.newq.removeElement(request);
        this.waitq.removeElement(request);
    }

    public void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public String statusReport() {
        return new String("Requests outstanding/waiting : " + this.newq.size() + "/" + this.waitq.size() + " Send/timer servers : " + this.requestQThread.isAlive() + "/" + this.timerQThread.isAlive());
    }
}

