/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager.internal;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.SnmpMessage;
import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpPduRequest;
import com.sun.jaw.snmp.manager.DatagramHandlerIf;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.internal.SnmpQManager;
import java.net.DatagramPacket;

public class SnmpResponseHandler
implements DatagramHandlerIf {
    SnmpQManager snmpq = null;

    public SnmpResponseHandler() {
        this.snmpq = SnmpQManager.getTheInstance();
    }

    public SnmpResponseHandler(SnmpQManager snmpQManager) {
        this.snmpq = snmpQManager;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("SnmpResponseHandler::processDatagram: Received from peer " + datagramPacket.getAddress().toString() + " Length = " + n));
        }
        if (Debug.isLevelSet((int)4096)) {
            Debug.print((int)2048, (Object)(" Dump : \n" + SnmpMessage.dumpHexBuffer((byte[])byArray, (int)0, (int)n)));
        }
        try {
            SnmpMessage snmpMessage = new SnmpMessage();
            snmpMessage.decodeMessage(byArray, n);
            snmpMessage.address = datagramPacket.getAddress();
            snmpMessage.port = datagramPacket.getPort();
            SnmpPduFactoryIf snmpPduFactoryIf = this.snmpq.findPduFactory(snmpMessage.address, snmpMessage.port);
            if (snmpPduFactoryIf == null) {
                Debug.print((int)2048, (Object)("SnmpResponseHandler::processDatagram: Dropping packet.  Unable to find the pdu factory for = " + snmpMessage.address + ":" + snmpMessage.port));
            } else {
                SnmpPduPacket snmpPduPacket = snmpPduFactoryIf.decodePdu(snmpMessage);
                if (snmpPduPacket == null) {
                    Debug.print((int)2048, (Object)"SnmpResponseHandler::processDatagram: Dropping packet.  Pdu factory returned a null value");
                } else if (snmpPduPacket instanceof SnmpPduRequest) {
                    SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                    Request request = this.snmpq.removeRequest(snmpPduRequest.requestId);
                    if (request != null) {
                        request.invokeOnResponse(snmpPduRequest);
                    } else {
                        Debug.print((int)2048, (Object)("SnmpResponseHandler::processDatagram: Dropping packet.  Unable to find corresponding for requestId = " + snmpPduRequest.requestId));
                    }
                } else {
                    Debug.print((int)2048, (Object)"SnmpResponseHandler::processDatagram: Dropping packet.  The packet does not contain a response");
                }
                snmpPduPacket = null;
            }
        }
        catch (Exception exception) {
            Debug.print((int)2048, (Object)"SnmpResponseHandler::processDatagram: Exception while processsing ");
            Debug.printException((Exception)exception);
        }
    }
}

