/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager.internal;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.SnmpPeer;
import com.sun.jaw.snmp.manager.SnmpRequest;
import com.sun.jaw.snmp.manager.SnmpSession;
import com.sun.jaw.snmp.manager.internal.MultiplexRequest;
import com.sun.jaw.snmp.manager.internal.SnmpQManager;
import java.util.Enumeration;
import java.util.Vector;

public final class SnmpSendServer
extends Thread
implements Runnable {
    SnmpQManager snmpq = null;
    private static String myname = "SnmpSendServer";
    private boolean tryMultiplexing = false;
    private int intervalRange = 5000;
    private Vector readyPool;
    private Vector assortedReqList = new Vector();

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, myname);
        this.snmpq = snmpQManager;
        this.start();
    }

    public final synchronized void activateMultiplex(boolean bl) {
        this.tryMultiplexing = bl;
    }

    void addToAssortedList(SnmpRequest snmpRequest) {
        SimilarRequestList similarRequestList;
        if (this.assortedReqList.isEmpty()) {
            SimilarRequestList similarRequestList2 = new SimilarRequestList(snmpRequest);
            this.assortedReqList.addElement(similarRequestList2);
            return;
        }
        Enumeration enumeration = this.assortedReqList.elements();
        while (enumeration.hasMoreElements()) {
            similarRequestList = (SimilarRequestList)enumeration.nextElement();
            if (!similarRequestList.belongsHere(snmpRequest)) continue;
            similarRequestList.addElement(snmpRequest);
            return;
        }
        similarRequestList = new SimilarRequestList(snmpRequest);
        this.assortedReqList.addElement(similarRequestList);
    }

    void fireAssortedRequests() {
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)"SnmpSendServer::fireAssortedRequests: Firing Assorted requests.");
        }
        while (!this.assortedReqList.isEmpty()) {
            SimilarRequestList similarRequestList = (SimilarRequestList)this.assortedReqList.lastElement();
            similarRequestList.action();
            this.assortedReqList.removeElementAt(this.assortedReqList.size() - 1);
        }
    }

    void fireRequest(Request request) {
        if (request != null && request.inProgress()) {
            if (Debug.isLevelSet((int)2048)) {
                Debug.printFormatted((Object)("SnmpSendServer::fireRequest: Firing request directly. -> " + request.getRequestId()));
            }
            request.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            Request request = (Request)vector.lastElement();
            if (request != null && request.inProgress()) {
                this.fireRequest(request);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    public final synchronized boolean multiplex() {
        return this.tryMultiplexing;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (Debug.isLevelSet((int)2048)) {
                Debug.printFormatted((Object)"SnmpSendServer::prepareAndSendRequest: Blocking for requests.");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
        } else if (Debug.isLevelSet((int)2048)) {
            Debug.print((int)2048, (Object)"SnmpSendServer::prepareAndSendRequest: Requests from a previous block left unprocessed. Will try again");
        }
        if (Debug.isLevelSet((int)2048)) {
            Debug.print((int)2048, (Object)("SnmpSendServer::prepareAndSendRequest: List of requests to send : " + this.reqListToString(this.readyPool)));
        }
        if (this.multiplex() && this.readyPool.size() >= 2) ** GOTO lbl20
        this.fireRequestList(this.readyPool);
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (SnmpRequest)this.readyPool.lastElement();
            if (var1_1 != null && var1_1.inProgress()) {
                if (var1_1.allowMultiplex()) {
                    this.addToAssortedList(var1_1);
                } else {
                    this.fireRequest(var1_1);
                }
            }
            this.readyPool.removeElementAt(this.readyPool.size() - 1);
lbl20:
            // 2 sources

            ** while (!this.readyPool.isEmpty())
        }
lbl21:
        // 1 sources

        this.fireAssortedRequests();
        this.readyPool.removeAllElements();
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        stringBuffer.append("RequestId/Options -> ");
        while (enumeration.hasMoreElements()) {
            object = (Request)enumeration.nextElement();
            stringBuffer.append(String.valueOf(((Request)object).getRequestId()) + "/" + ((SnmpRequest)object).getOptions() + " ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        Debug.print((int)2048, (Object)"SnmpSendServer::run: ==> Thread Started .........");
        while (true) {
            try {
                while (true) {
                    this.prepareAndSendRequest();
                }
            }
            catch (Exception exception) {
                Debug.print((int)2048, (Object)"SnmpSendServer::run: Exception in send server....");
                Debug.printException((Exception)exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                Debug.print((int)2048, (Object)"SnmpSendServer::run: Exiting... Fatal error");
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Debug.print((int)2048, (Object)"SnmpSendServer::run: Outofmemory");
                continue;
            }
            catch (Error error) {
                error.printStackTrace();
                throw error;
            }
            break;
        }
    }

    private void takeAnap(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {}
    }

    final class SimilarRequestList
    extends Vector {
        SnmpPeer _peer;
        SnmpSession _session;
        int _cmd;
        MultiplexRequest _currentMuxReq;

        SimilarRequestList(SnmpRequest snmpRequest) {
            this._peer = snmpRequest.getPeer();
            this._session = snmpRequest.getSnmpSession();
            this._cmd = snmpRequest.getCommand();
            this.addElement(snmpRequest);
        }

        public void action() {
            if (Debug.isLevelSet((int)4096)) {
                Debug.print((int)2048, (Object)("SnmpSendServer::action: List of requests directed to peer : " + this.describe()));
            }
            while (!this.isEmpty()) {
                SnmpRequest snmpRequest;
                if (this._currentMuxReq == null) {
                    if (this.size() < 2) {
                        this.fireRequestDirect((Request)this.firstElement());
                        this.removeAllElements();
                        break;
                    }
                    this._currentMuxReq = new MultiplexRequest(this.getPeer(), this.getSession(), this.getCommand());
                }
                if (this._currentMuxReq.addRequest(snmpRequest = (SnmpRequest)this.lastElement())) {
                    --this.elementCount;
                    continue;
                }
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
            if (this._currentMuxReq != null) {
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
        }

        public boolean belongsHere(SnmpRequest snmpRequest) {
            if (this._cmd != snmpRequest.getCommand()) {
                return false;
            }
            return this._peer.equals(snmpRequest.getPeer()) && this._session.isEquivalent(snmpRequest.getSnmpSession());
        }

        public String describe() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(String.valueOf(this._peer.toString()) + " -> ");
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(String.valueOf(((Request)this.elementData[n2]).getRequestId()) + " ");
                ++n2;
            }
            return stringBuffer.toString();
        }

        void fireRequestDirect(Request request) {
            if (request != null && request.inProgress()) {
                if (Debug.isLevelSet((int)2048)) {
                    Debug.printFormatted((Object)("SnmpSendServer::fireRequestDirect: Firing request directly. -> " + request.getRequestId()));
                }
                request.action();
            }
        }

        public int getCommand() {
            return this._cmd;
        }

        public SnmpPeer getPeer() {
            return this._peer;
        }

        public SnmpSession getSession() {
            return this._session;
        }
    }
}

