/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager.internal;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.common.SnmpDefinitions;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.SnmpHandlerIf;
import com.sun.jaw.snmp.manager.SnmpPeer;
import com.sun.jaw.snmp.manager.SnmpRequest;
import com.sun.jaw.snmp.manager.SnmpSession;
import com.sun.jaw.snmp.manager.SnmpVarbindList;
import com.sun.jaw.snmp.manager.Timestamp;
import com.sun.jaw.snmp.manager.internal.ReqRedirectSrvIf;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class SnmpTooBig
implements SnmpHandlerIf,
SnmpDefinitions,
ReqRedirectSrvIf,
Serializable {
    private SnmpRequest _rootRequest;
    private Vector _subRequestList;
    static final String nl = "\n";
    private static final String sccs_id = "@(#)SnmpTooBig.java 1.5 97/08/05 SMI";

    public SnmpTooBig(SnmpRequest snmpRequest, SnmpVarbindList snmpVarbindList) throws SnmpStatusException {
        this._rootRequest = snmpRequest;
        Debug.print((int)2048, (Object)"SnmpTooBig::new: Initializing too-big handler.");
        int n = snmpVarbindList.size();
        if (n < 2) {
            throw new SnmpStatusException("VarbindList has only one element...");
        }
        SnmpVarbindList snmpVarbindList2 = new SnmpVarbindList(snmpVarbindList);
        this._subRequestList = new Vector();
        SnmpVarbindList snmpVarbindList3 = snmpVarbindList2.splitAt(n / 2);
        SnmpRequest snmpRequest2 = this.createRequest();
        SnmpRequest snmpRequest3 = this.createRequest();
        this._subRequestList.addElement(snmpRequest2);
        this._subRequestList.addElement(snmpRequest3);
        snmpRequest2.start(snmpVarbindList2, false, 0L);
        snmpRequest3.start(snmpVarbindList3, false, 0L);
        if (Debug.isLevelSet((int)2048)) {
            this.debugMessage("new", this.subRequestToString());
        }
    }

    private synchronized void addRequest(SnmpRequest snmpRequest, SnmpRequest snmpRequest2) {
        int n = this._subRequestList.indexOf(snmpRequest);
        if (n < 0) {
            this._subRequestList.addElement(snmpRequest);
            this._subRequestList.addElement(snmpRequest2);
        } else {
            this._subRequestList.insertElementAt(snmpRequest2, ++n);
        }
    }

    public synchronized void cancel() {
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            Request request = (Request)enumeration.nextElement();
            if (!request.inProgress()) continue;
            request.cancelRequest();
        }
    }

    public synchronized void cancel(SnmpRequest snmpRequest) {
        this.cancel();
    }

    synchronized boolean checkRemainingRequests(Request request) {
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            Request request2 = (Request)enumeration.nextElement();
            if (request2 == request || !request2.inProgress()) continue;
            return false;
        }
        return true;
    }

    private synchronized SnmpRequest createRequest() throws SnmpStatusException {
        SnmpRequest snmpRequest = null;
        snmpRequest = new SnmpRequest(this.getSnmpSession(), this.getPeer(), this, this.getCommand());
        int n = this._rootRequest.getOptions();
        snmpRequest.setOptions(n & 0xFFFFFFFB);
        snmpRequest.setInternalRequest();
        this.debugMessage("createRequest", "Created a new sub-request for toobig handling.");
        return snmpRequest;
    }

    private void debugMessage(String string, String string2) {
        Debug.print((int)2048, (Object)("SnmpTooBig::" + string + "(root= " + this._rootRequest.getRequestId() + "):" + string2));
    }

    synchronized int determineRealIndex(SnmpRequest snmpRequest) {
        int n = 0;
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpRequest snmpRequest2 = (SnmpRequest)enumeration.nextElement();
            if (snmpRequest2 == snmpRequest) break;
            n += snmpRequest2.getVarbindList().size();
        }
        return n;
    }

    private synchronized void doSubRequests(SnmpVarbindList snmpVarbindList, SnmpRequest snmpRequest) throws SnmpStatusException {
        int n = snmpVarbindList.size();
        if (n < 2) {
            throw new SnmpStatusException("VarbindList has only one element...");
        }
        SnmpVarbindList snmpVarbindList2 = snmpVarbindList.splitAt(n / 2);
        if (Debug.isLevelSet((int)4096)) {
            this.debugMessage("doSubRequests", "After spliting varbind: first half:\n" + snmpVarbindList.vbListToString());
            this.debugMessage("doSubRequests", "second half:\n" + snmpVarbindList2.vbListToString());
        }
        SnmpRequest snmpRequest2 = this.createRequest();
        if (snmpRequest == null) {
            snmpRequest = this.createRequest();
        }
        this.addRequest(snmpRequest, snmpRequest2);
        snmpRequest.start(snmpVarbindList, false, 0L);
        snmpRequest2.start(snmpVarbindList2, false, 0L);
        if (Debug.isLevelSet((int)2048)) {
            this.debugMessage("doSubRequests", this.subRequestToString());
        }
    }

    public final int getCommand() {
        return this._rootRequest.getCommand();
    }

    public final SnmpPeer getPeer() {
        return this._rootRequest.getPeer();
    }

    public final SnmpSession getSnmpSession() {
        return this._rootRequest.getSnmpSession();
    }

    synchronized void handleError(SnmpRequest snmpRequest, int n, int n2) {
        int n3 = 0;
        this.cancel();
        if (n2 >= 0) {
            n3 = this.determineRealIndex(snmpRequest) + n2;
        }
        this.debugMessage("handleError", "Error occured while handling too-big error");
        this.operationComplete(n, n3, snmpRequest.getPollTimestamp());
    }

    synchronized void handleSuccess(SnmpRequest snmpRequest, SnmpVarbindList snmpVarbindList) {
        if (this.checkRemainingRequests(snmpRequest)) {
            Timestamp timestamp = snmpVarbindList.getTimestamp();
            this._rootRequest.getVarbindList().setTimestamp(timestamp);
            this.operationComplete(0, 0, snmpRequest.getPollTimestamp());
            return;
        }
    }

    private void operationComplete(int n, int n2, long l) {
        this._rootRequest.setErrorStatusAndIndex(n, n2);
        this._rootRequest.setPreviousPollTimestamp(l);
        this._rootRequest.invokeOnResponse(null);
    }

    public synchronized void processSnmpInternalError(SnmpRequest snmpRequest, String string) {
        this.cancel();
        this.operationComplete(240, 0, snmpRequest.getPollTimestamp());
    }

    public synchronized void processSnmpPollData(SnmpRequest snmpRequest, int n, int n2, SnmpVarbindList snmpVarbindList) {
        switch (n) {
            case 0: {
                this.handleSuccess(snmpRequest, snmpVarbindList);
                break;
            }
            case 1: 
            case 228: 
            case 231: {
                if (snmpVarbindList.size() > 2) {
                    this.debugMessage("processSnmpPollData", "Too-big error within too-big handler");
                    try {
                        this.doSubRequests(snmpVarbindList, snmpRequest);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.processSnmpInternalError(snmpRequest, "Creating sub-requests to handle too-big error");
                    }
                    break;
                }
                this.debugMessage("processSnmpPollData", "Too-big error within too-big handler : varbindlist size = 1");
                this.handleError(snmpRequest, 232, 0);
                break;
            }
            default: {
                this.handleError(snmpRequest, n, n2);
            }
        }
    }

    public synchronized void processSnmpPollTimeout(SnmpRequest snmpRequest) {
        this.cancel();
        this.operationComplete(224, 0, snmpRequest.getPollTimestamp());
    }

    synchronized String subRequestToString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            Request request = (Request)enumeration.nextElement();
            stringBuffer.append("/" + request.getRequestId());
        }
        return stringBuffer.toString();
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        boolean bl = false;
        return stringBuffer.toString();
    }
}

