/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.manager.internal;

import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.manager.Request;
import com.sun.jaw.snmp.manager.SnmpPeer;
import com.sun.jaw.snmp.manager.SnmpRequest;
import java.net.InetAddress;
import java.util.Vector;

class WaitQ
extends Vector {
    WaitQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized void addWaiting(Request request) {
        long l = request.getAbsMaxTimeToWait();
        int n = this.size();
        while (n > 0) {
            if (l < this.getRequestAt(n - 1).getAbsMaxTimeToWait()) break;
            --n;
        }
        if (n == this.size()) {
            this.addElement(request);
            this.notifyClients();
        } else {
            this.insertElementAt(request, n);
        }
    }

    public synchronized SnmpPduFactoryIf findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactoryIf snmpPduFactoryIf = null;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2 && snmpPduFactoryIf == null) {
            SnmpPeer snmpPeer;
            Request request = this.getRequestAt(n3);
            if (request instanceof SnmpRequest && (snmpPeer = ((SnmpRequest)request).getPeer()).getDestAddr().equals(inetAddress) && snmpPeer.getDestPort() == n) {
                snmpPduFactoryIf = snmpPeer.getPduFactory();
            }
            ++n3;
        }
        return snmpPduFactoryIf;
    }

    public Request getRequestAt(int n) {
        return (Request)this.elementAt(n);
    }

    public synchronized Request getTimeoutRequests() {
        this.waitUntilReady();
        Request request = (Request)this.lastElement();
        --this.elementCount;
        return request;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized String printAllRequest(long l) {
        if (this.isEmpty()) {
            return "------- WaitQ empty.......";
        }
        StringBuffer stringBuffer = new StringBuffer("\n------------------------ Requests in WaitQ -> " + this.size());
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Request request = this.getRequestAt(n2);
            stringBuffer.append("\n" + n2 + ". (" + request.toString() + " RemainingTimeToSend = " + request.timeRemainingForAction(l) + "  ) ................................\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public synchronized Request removeRequest(long l) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Request request = this.getRequestAt(n2);
            if (l == (long)request.getRequestId()) {
                this.removeElementAt(n2);
                return request;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty()) {
            System.err.println(String.valueOf(Thread.currentThread().toString()) + " Fatal BUG ::: Blocking on waitq permenantly.  But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized boolean waitUntilReady() {
        while (true) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                Request request = (Request)this.lastElement();
                l = request.getAbsMaxTimeToWait() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
    }
}

