/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.http;

import com.sun.jaw.reference.common.CommunicationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class AdaptorSocket
extends com.sun.jaw.impl.adaptor.comm.AdaptorSocket {
    private ServerSocket serverSocket = null;
    private Socket sckAccept = null;
    private Socket clientSocket = null;
    private InputStream inputStream = null;
    private int backlog = 10;
    private static final String sccs_id = "@(#)AdaptorSocket.java 3.2 01/26/99 SMI";

    public AdaptorSocket() {
    }

    public AdaptorSocket(int n) {
        this.port = n;
    }

    public com.sun.jaw.impl.adaptor.comm.AdaptorSocket createClientSocket() {
        AdaptorSocket adaptorSocket = new AdaptorSocket(0);
        adaptorSocket.setTimeout(this.getTimeout());
        return adaptorSocket;
    }

    public com.sun.jaw.impl.adaptor.comm.AdaptorSocket createServerSocket(int n) {
        return new AdaptorSocket(n);
    }

    public void doBind() throws IOException {
        this.serverSocket = new ServerSocket(this.port, this.backlog);
        this.setTimeout(30000);
    }

    public void doConnect(String string, int n) throws UnknownHostException, IOException, CommunicationException {
        this.clientSocket = new Socket(string, n);
        this.clientSocket.setSoTimeout(this.getTimeout());
    }

    public void doDisconnect() throws IOException, CommunicationException {
        if (this.serverSocket != null) {
            this.sckAccept.close();
            this.sckAccept = null;
        } else if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
    }

    public InputStream doGetInputStream() throws IOException {
        return this.inputStream;
    }

    public InputStream doReceive() throws IOException {
        if (this.serverSocket != null) {
            this.sckAccept = this.serverSocket.accept();
            this.sckAccept.setSoTimeout(this.getTimeout());
            this.inputStream = this.sckAccept.getInputStream();
        } else {
            this.inputStream = this.clientSocket.getInputStream();
        }
        return this.doGetInputStream();
    }

    public void doSend(String string, byte[] byArray) throws IOException {
        OutputStream outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        outputStream.write(string.getBytes());
        if (byArray != null) {
            outputStream.write(byArray);
        }
        outputStream.flush();
    }

    public void doUnbind() throws IOException {
        this.serverSocket.close();
    }

    public InetAddress getLocalAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getInetAddress();
        }
        return this.clientSocket.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.clientSocket.getLocalPort();
    }

    public String getProtocol() {
        return "http";
    }

    public InetAddress getRemoteAddress() {
        if (this.serverSocket != null) {
            return this.sckAccept.getInetAddress();
        }
        return this.clientSocket.getInetAddress();
    }

    public int getRemotePort() {
        if (this.serverSocket != null) {
            return this.sckAccept.getPort();
        }
        return this.clientSocket.getPort();
    }

    public String toString() {
        return this.serverSocket.toString();
    }
}

