/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.udp;

import com.sun.jaw.reference.common.CommunicationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AdaptorSocket
extends com.sun.jaw.impl.adaptor.comm.AdaptorSocket {
    private DatagramSocket serverSocket = null;
    private DatagramSocket serverReplySocket = null;
    private int msgSize = 10240;
    private byte[] msg = new byte[this.msgSize];
    private DatagramPacket datagramPkt = null;
    private DatagramSocket clientSocket = null;
    private InputStream inputStream = null;
    private static final String sccs_id = "@(#)AdaptorSocket.java 3.4 03/26/99 SMI";

    public AdaptorSocket() {
    }

    public AdaptorSocket(int n) {
        this();
        this.port = n;
    }

    public Object clone() {
        AdaptorSocket adaptorSocket = (AdaptorSocket)super.clone();
        adaptorSocket.msg = (byte[])this.msg.clone();
        adaptorSocket.datagramPkt = new DatagramPacket(adaptorSocket.msg, this.datagramPkt.getLength(), this.datagramPkt.getAddress(), this.datagramPkt.getPort());
        adaptorSocket.inputStream = new ByteArrayInputStream(adaptorSocket.datagramPkt.getData(), 0, adaptorSocket.datagramPkt.getLength());
        return adaptorSocket;
    }

    public com.sun.jaw.impl.adaptor.comm.AdaptorSocket createClientSocket() {
        AdaptorSocket adaptorSocket = new AdaptorSocket(0);
        adaptorSocket.setTimeout(this.getTimeout());
        return adaptorSocket;
    }

    public com.sun.jaw.impl.adaptor.comm.AdaptorSocket createServerSocket(int n) {
        return new AdaptorSocket(n);
    }

    public void doBind() throws IOException {
        this.serverSocket = new DatagramSocket(this.port);
    }

    public void doConnect(String string, int n) throws UnknownHostException, IOException {
        this.clientSocket = new DatagramSocket();
        InetAddress inetAddress = null;
        inetAddress = InetAddress.getByName(string);
        this.datagramPkt = new DatagramPacket(this.msg, this.msgSize, inetAddress, n);
    }

    public void doDisconnect() throws IOException, CommunicationException {
        if (this.serverSocket != null) {
            if (this.serverReplySocket != null) {
                this.serverReplySocket.close();
            }
        } else if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
    }

    public InputStream doGetInputStream() throws IOException {
        return this.inputStream;
    }

    public InputStream doReceive() throws IOException {
        if (this.msg.length != this.msgSize) {
            this.msg = new byte[this.msgSize];
        }
        this.datagramPkt = new DatagramPacket(this.msg, this.msg.length);
        if (this.serverSocket != null) {
            this.serverSocket.receive(this.datagramPkt);
        } else {
            this.clientSocket.setSoTimeout(this.getTimeout());
            this.clientSocket.receive(this.datagramPkt);
        }
        this.inputStream = new ByteArrayInputStream(this.datagramPkt.getData(), 0, this.datagramPkt.getLength());
        return this.doGetInputStream();
    }

    public void doSend(String string, byte[] byArray) throws IOException {
        DatagramSocket datagramSocket = this.serverSocket != null ? (this.serverReplySocket = new DatagramSocket()) : this.clientSocket;
        byte[] byArray2 = new byte[string.length() + (byArray != null ? byArray.length : 0)];
        System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, string.length(), byArray.length);
        }
        this.datagramPkt = new DatagramPacket(byArray2, byArray2.length, this.getRemoteAddress(), this.getRemotePort());
        datagramSocket.send(this.datagramPkt);
    }

    public void doUnbind() throws IOException {
        this.serverSocket.close();
    }

    public InetAddress getLocalAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalAddress();
        }
        return this.clientSocket.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.clientSocket.getLocalPort();
    }

    public int getMsgSize() {
        return this.msgSize;
    }

    public String getProtocol() {
        return "udp";
    }

    public InetAddress getRemoteAddress() {
        if (this.serverSocket != null) {
            return this.datagramPkt.getAddress();
        }
        return this.datagramPkt.getAddress();
    }

    public int getRemotePort() {
        if (this.serverSocket != null) {
            return this.datagramPkt.getPort();
        }
        return this.datagramPkt.getPort();
    }

    public void setMsgSize(int n) {
        this.msgSize = n;
    }

    public String toString() {
        return this.serverSocket.toString();
    }
}

