/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.alarm;

import com.sun.jaw.impl.agent.services.alarm.AlarmClockEvent;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockListener;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class AlarmClock
implements Runnable,
Serializable,
ActivatableIf {
    private Long timeout = new Long(10000L);
    private transient Thread alarmClock = null;
    private transient Vector listeners = new Vector();
    private Framework cmf = null;
    private ObjectName acObjectName = null;

    public void addAlarmClockListener(AlarmClockListener alarmClockListener) {
        this.listeners.addElement(alarmClockListener);
    }

    public void deleteCmf() {
        this.alarmClock.stop();
        this.alarmClock = null;
    }

    public Integer getTimeout() {
        return new Integer(this.timeout.intValue());
    }

    public Long getTimeoutAsLong() {
        return this.timeout;
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        this.cmf = framework;
        this.acObjectName = objectName;
        if (bl) {
            framework.addDBObject((Object)this, objectName);
        } else {
            framework.addObject((Object)this, objectName);
        }
    }

    public boolean isActive() {
        return this.alarmClock != null;
    }

    private void notifyAlarmClock() {
        AlarmClockEvent alarmClockEvent = new AlarmClockEvent(this);
        Vector vector = (Vector)this.listeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ((AlarmClockListener)vector.elementAt(n)).handleAlarmClock(alarmClockEvent);
            ++n;
        }
    }

    public synchronized void performStart() {
        if (this.alarmClock == null) {
            this.alarmClock = this.cmf == null ? new Thread(this) : this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.acObjectName, (Runnable)this);
            this.alarmClock.start();
        }
    }

    public synchronized void performStop() {
        Thread thread = this.alarmClock;
        if (thread != null) {
            thread.stop();
            this.alarmClock = null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new Vector();
    }

    public void removeAlarmClockListener(AlarmClockListener alarmClockListener) {
        this.listeners.removeElement(alarmClockListener);
    }

    public void run() {
        try {
            Thread.sleep(this.timeout);
            this.alarmClock = null;
            this.notifyAlarmClock();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setTimeout(Integer n) {
        this.setTimeoutAsLong(new Long(n.longValue()));
    }

    public void setTimeoutAsLong(Long l) {
        this.timeout = l;
    }
}

