/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.scheduler;

import com.sun.jaw.impl.agent.services.alarm.AlarmClock;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockEvent;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockListener;
import com.sun.jaw.impl.agent.services.scheduler.SchedulerEvent;
import com.sun.jaw.impl.agent.services.scheduler.SchedulerListener;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class Scheduler
implements AlarmClockListener,
Serializable,
ActivatableIf {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private Vector schVector = new Vector();
    private transient Vector listeners = new Vector();
    private Framework cmf = null;
    private transient boolean stateOnOff = false;
    private boolean notifyPastEvents = false;
    private static final int SCHED_EVENT_INDEX = 0;
    private static final int SCHED_DATE_INDEX = 1;
    private static final int SCHED_PERIOD_INDEX = 2;
    private static final int SCHED_NB_REP_INDEX = 3;
    private static final int ALARM_CLOCK_INDEX = 4;
    private static final String sccs_id = "@(#)Scheduler.java 3.5 99/03/10 SMI";
    private static final long serialVersionUID = -8245065877041422162L;

    public void addSchedulerListener(SchedulerListener schedulerListener) {
        this.listeners.addElement(schedulerListener);
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public Date getDateFromEvent(SchedulerEvent schedulerEvent) {
        Object[] objectArray = this.getElementAt(schedulerEvent, 0);
        if (objectArray == null) {
            return null;
        }
        Date date = (Date)objectArray[1];
        return new Date(date.getTime());
    }

    public Date getDateFromIndex(int n) {
        try {
            Object[] objectArray = (Object[])this.schVector.elementAt(n);
            Date date = (Date)objectArray[1];
            return new Date(date.getTime());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private synchronized Object[] getElementAt(Object object, int n) {
        Enumeration enumeration = this.schVector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (objectArray[n] != object) continue;
            return objectArray;
        }
        return null;
    }

    public synchronized SchedulerEvent[] getListOfEvents() {
        int n = this.getNumberOfEvents();
        SchedulerEvent[] schedulerEventArray = new SchedulerEvent[n];
        Object[] objectArray = null;
        int n2 = 0;
        while (n2 < n) {
            objectArray = (Object[])this.schVector.elementAt(n2);
            schedulerEventArray[n2] = (SchedulerEvent)objectArray[0];
            ++n2;
        }
        return schedulerEventArray;
    }

    public Long getNbRepetitionsFromEvent(SchedulerEvent schedulerEvent) {
        Object[] objectArray = this.getElementAt(schedulerEvent, 0);
        if (objectArray == null) {
            return null;
        }
        Long l = (Long)objectArray[3];
        return new Long(l);
    }

    public Long getNbRepetitionsFromIndex(int n) {
        try {
            Object[] objectArray = (Object[])this.schVector.elementAt(n);
            Long l = (Long)objectArray[3];
            return new Long(l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public boolean getNotifyPastEvents() {
        return this.notifyPastEvents;
    }

    public int getNumberOfEvents() {
        return this.schVector.size();
    }

    public Long getPeriodInMillisFromEvent(SchedulerEvent schedulerEvent) {
        Object[] objectArray = this.getElementAt(schedulerEvent, 0);
        if (objectArray == null) {
            return null;
        }
        Long l = (Long)objectArray[2];
        return new Long(l);
    }

    public Long getPeriodInMillisFromIndex(int n) {
        try {
            Object[] objectArray = (Object[])this.schVector.elementAt(n);
            Long l = (Long)objectArray[2];
            return new Long(l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void handleAlarmClock(AlarmClockEvent alarmClockEvent) {
        AlarmClock alarmClock = (AlarmClock)alarmClockEvent.getSource();
        Object[] objectArray = this.getElementAt(alarmClock, 4);
        SchedulerEvent schedulerEvent = (SchedulerEvent)objectArray[0];
        this.notifyScheduler(schedulerEvent);
        this.performUpdateVector(objectArray);
    }

    public boolean isActive() {
        return this.stateOnOff;
    }

    public boolean isListOfEventsEmpty() {
        return this.schVector.isEmpty();
    }

    private synchronized void notifyPastEvents(Date date, boolean bl) {
        Enumeration enumeration = this.schVector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            SchedulerEvent schedulerEvent = (SchedulerEvent)objectArray[0];
            Date date2 = (Date)objectArray[1];
            while (date.after(date2) && this.getElementAt(schedulerEvent, 0) != null) {
                if (bl) {
                    this.notifyScheduler(schedulerEvent);
                    Debug.print(128, (Object)"");
                    Debug.print(128, (Object)("Scheduler::notifyPastEvents: Past event notified = " + schedulerEvent));
                    Debug.print(128, (Object)"");
                }
                this.performUpdateVector(objectArray);
            }
        }
    }

    private void notifyScheduler(SchedulerEvent schedulerEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ((SchedulerListener)vector.elementAt(n)).handleScheduler(schedulerEvent);
            ++n;
        }
    }

    public synchronized void performAddEvent(SchedulerEvent schedulerEvent, Date date) throws InstanceAlreadyExistException, InvalidPropertyValueException {
        this.performAddEvent(schedulerEvent, date, 0L, 0L);
    }

    public synchronized void performAddEvent(SchedulerEvent schedulerEvent, Date date, long l) throws InstanceAlreadyExistException, InvalidPropertyValueException {
        this.performAddEvent(schedulerEvent, date, l, 0L);
    }

    public synchronized void performAddEvent(SchedulerEvent schedulerEvent, Date date, long l, long l2) throws InstanceAlreadyExistException, InvalidPropertyValueException {
        Date date2 = new Date();
        Debug.print(128, (Object)"");
        Debug.print(128, (Object)("Scheduler::performAddEvent: Event classe = " + schedulerEvent.getClass()));
        Debug.print(128, (Object)("Scheduler::performAddEvent: Event date   = " + date));
        Debug.print(128, (Object)("Scheduler::performAddEvent: Event period = " + l));
        Debug.print(128, (Object)("Scheduler::performAddEvent: Event nb of repetitions = " + l2));
        Debug.print(128, (Object)"");
        Object[] objectArray = this.getElementAt(schedulerEvent, 0);
        if (objectArray != null) {
            Debug.print(128, (Object)("Scheduler::performAddEvent: Invalid event value = " + schedulerEvent));
            Debug.print(128, (Object)"");
            throw new InstanceAlreadyExistException("Scheduler event to add already in the vector");
        }
        if (l < 0L || l2 < 0L) {
            Debug.print(128, (Object)("Scheduler::performAddEvent: Invalid periodicity values = " + l + " milliseconds for period"));
            Debug.print(128, (Object)("Scheduler::performAddEvent: Invalid periodicity values = " + l2 + " for nb of repetitions"));
            Debug.print(128, (Object)"");
            throw new InvalidPropertyValueException("Negative values for the periodicity");
        }
        if (date2.after(date)) {
            long l3 = date.getTime() + (l2 - 1L) * l;
            if (l == 0L || l2 != 0L && date2.getTime() > l3) {
                Debug.print(128, (Object)("Scheduler::performAddEvent: Invalid date value = " + date));
                Debug.print(128, (Object)"");
                throw new InvalidPropertyValueException("Date event before the current date");
            }
        }
        if (date2.after(date)) {
            Debug.print(128, (Object)("Scheduler::performAddEvent: Invalid date value = " + date + " before the current date"));
            Debug.print(128, (Object)"Scheduler::performAddEvent: Scheduler event updated with:");
            while (date2.after(date)) {
                date.setTime(date.getTime() + l);
                l2 = Math.max(0L, l2 - 1L);
            }
            Debug.print(128, (Object)("\tEvent date   = " + date));
            Debug.print(128, (Object)("\tEvent period = " + l));
            Debug.print(128, (Object)("\tEvent nb of repetitions = " + l2));
            Debug.print(128, (Object)"");
        }
        Object[] objectArray2 = new Object[5];
        AlarmClock alarmClock = new AlarmClock();
        objectArray2[0] = schedulerEvent;
        objectArray2[1] = date;
        objectArray2[2] = new Long(l);
        objectArray2[3] = new Long(l2);
        objectArray2[4] = alarmClock;
        this.schVector.addElement(objectArray2);
        alarmClock.addAlarmClockListener(this);
        if (this.stateOnOff) {
            alarmClock.setTimeoutAsLong(new Long(date.getTime() - date2.getTime()));
            alarmClock.performStart();
        }
    }

    public synchronized void performRemoveAllEvents() {
        Enumeration enumeration = this.schVector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            AlarmClock alarmClock = (AlarmClock)objectArray[4];
            alarmClock.performStop();
            alarmClock = null;
        }
        this.schVector.removeAllElements();
    }

    public synchronized void performRemoveEvent(int n) throws InstanceNotFoundException {
        try {
            Object[] objectArray = (Object[])this.schVector.elementAt(n);
            AlarmClock alarmClock = (AlarmClock)objectArray[4];
            alarmClock.performStop();
            alarmClock = null;
            this.schVector.removeElement(objectArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.print(128, (Object)"");
            Debug.print(128, (Object)("Scheduler::performRemoveEvent: Invalid index value = " + n));
            Debug.print(128, (Object)"");
            throw new InstanceNotFoundException("Specified index out of bounds");
        }
    }

    public synchronized void performRemoveEvent(SchedulerEvent schedulerEvent) throws InstanceNotFoundException {
        Object[] objectArray = this.getElementAt(schedulerEvent, 0);
        if (objectArray == null) {
            Debug.print(128, (Object)"");
            Debug.print(128, (Object)("Scheduler::performRemoveEvent: Invalid event value = " + schedulerEvent));
            Debug.print(128, (Object)"");
            throw new InstanceNotFoundException("Scheduler event to remove not in the vector");
        }
        AlarmClock alarmClock = (AlarmClock)objectArray[4];
        alarmClock.performStop();
        alarmClock = null;
        this.schVector.removeElement(objectArray);
    }

    public synchronized void performStart() {
        Debug.print(128, (Object)"Scheduler::performStart: Start the Scheduler.");
        if (!this.stateOnOff) {
            Date date = new Date();
            Enumeration enumeration = this.schVector.elements();
            this.notifyPastEvents(date, this.notifyPastEvents);
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                Date date2 = (Date)objectArray[1];
                AlarmClock alarmClock = (AlarmClock)objectArray[4];
                alarmClock.setTimeoutAsLong(new Long(date2.getTime() - date.getTime()));
                alarmClock.performStart();
            }
            this.stateOnOff = true;
        } else {
            Debug.print(128, (Object)"Scheduler::performStart: The Scheduler is already activated.");
        }
    }

    public synchronized void performStop() {
        Debug.print(128, (Object)"Scheduler::performStop: Stop the Scheduler service.");
        if (this.stateOnOff) {
            Enumeration enumeration = this.schVector.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                AlarmClock alarmClock = (AlarmClock)objectArray[4];
                alarmClock.performStop();
            }
            this.stateOnOff = false;
        } else {
            Debug.print(128, (Object)"Scheduler::performStop: The Scheduler service is already deactivated.");
        }
    }

    private synchronized void performUpdateVector(Object[] objectArray) {
        SchedulerEvent schedulerEvent = (SchedulerEvent)objectArray[0];
        Date date = (Date)objectArray[1];
        Long l = (Long)objectArray[2];
        Long l2 = (Long)objectArray[3];
        AlarmClock alarmClock = (AlarmClock)objectArray[4];
        if (l != 0L) {
            if (l2 == 0L || l2 > 1L) {
                date.setTime(date.getTime() + l);
                objectArray[3] = new Long(Math.max(0L, l2 - 1L));
                l2 = (Long)objectArray[3];
                if (this.stateOnOff) {
                    alarmClock.setTimeoutAsLong(new Long(l));
                    alarmClock.performStart();
                }
                Debug.print(128, (Object)"");
                Debug.print(128, (Object)("Scheduler::performUpdateVector: Event classe = " + schedulerEvent.getClass()));
                Debug.print(128, (Object)("Scheduler::performUpdateVector: Event date   = " + date));
                Debug.print(128, (Object)("Scheduler::performUpdateVector: Event period = " + l));
                Debug.print(128, (Object)("Scheduler::performUpdateVector: Event nb of repetitions remaining = " + l2));
                Debug.print(128, (Object)"");
            } else {
                alarmClock.performStop();
                alarmClock = null;
                this.schVector.removeElement(objectArray);
            }
        } else {
            alarmClock.performStop();
            alarmClock = null;
            this.schVector.removeElement(objectArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new Vector();
        if (this.schVector == null) {
            this.schVector = new Vector();
        }
    }

    public void removeSchedulerListener(SchedulerListener schedulerListener) {
        this.listeners.removeElement(schedulerListener);
    }

    public void setNotifyPastEvents(boolean bl) {
        this.notifyPastEvents = bl;
    }
}

