/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.common;

import com.sun.jaw.reference.common.internal.CheckJawStaticMethodPermission;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;

public class Debug {
    public static final int NO_DEBUG = 0;
    public static final int CMF_DEBUG = 1;
    public static final int ADP_DEBUG = 2;
    public static final int REP_DEBUG = 4;
    public static final int EXCPT_DEBUG = 8;
    public static final int META_DEBUG = 16;
    public static final int TRACE_DEBUG = 128;
    public static final int REL_DEBUG = 256;
    public static final int MLET_DEBUG = 512;
    public static final int DISCO_DEBUG = 1024;
    public static final int SNMP_DEBUG = 2048;
    public static final int HEAVY_DEBUG = 4096;
    public static final int THREAD_DEBUG = 8192;
    private static int level = 0;
    private static boolean default_debug = false;
    private static PrintWriter log_debug = null;

    public static void flush() {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if (log_debug != null) {
            log_debug.flush();
        } else {
            System.err.flush();
        }
    }

    public static int getLevel() {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        return level;
    }

    public static PrintWriter getLog() {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        return log_debug;
    }

    public static boolean isLevelSet(int n) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        return (level & n) != 0;
    }

    public static void parseDebugProperties() {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        Properties properties = System.getProperties();
        Debug.setOffAll();
        if (properties.getProperty("DEBUG_OUTPUT") != null) {
            try {
                log_debug = new PrintWriter((Writer)new BufferedWriter(new FileWriter(properties.getProperty("DEBUG_OUTPUT"))), true);
            }
            catch (IOException iOException) {
                System.err.println("Unable to create file for logging debug messages, standard error stream will be used instead: " + iOException);
            }
        }
        if (properties.getProperty("DEBUG_ALL") != null || properties.getProperty("DEBUG") != null) {
            Debug.setOnAll();
            Debug.setOff(4096);
        }
        if (properties.getProperty("DEFAULT") != null) {
            Debug.setDefault(true);
        }
        if (properties.getProperty("DEBUG_CMF") != null) {
            Debug.setOn(1);
        }
        if (properties.getProperty("DEBUG_TRACE") != null) {
            Debug.setOn(128);
        }
        if (properties.getProperty("DEBUG_ADP") != null) {
            Debug.setOn(2);
        }
        if (properties.getProperty("DEBUG_EXCPT") != null) {
            Debug.setOn(8);
        }
        if (properties.getProperty("DEBUG_REPO") != null) {
            Debug.setOn(4);
        }
        if (properties.getProperty("DEBUG_META") != null) {
            Debug.setOn(16);
        }
        if (properties.getProperty("DEBUG_RELA") != null) {
            Debug.setOn(256);
        }
        if (properties.getProperty("DEBUG_MLET") != null) {
            Debug.setOn(512);
        }
        if (properties.getProperty("DEBUG_DISCO") != null) {
            Debug.setOn(1024);
        }
        if (properties.getProperty("DEBUG_SNMP") != null) {
            Debug.setOn(2048);
        }
        if (properties.getProperty("DEBUG_HEAVY") != null) {
            Debug.setOn(4096);
        }
        if (properties.getProperty("DEBUG_THREAD") != null) {
            Debug.setOn(8192);
        }
    }

    public static void print(int n, Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if ((level & n) != 0) {
            Debug.printFormatted(object);
        }
    }

    public static void print(Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if (default_debug) {
            Debug.printFormatted(object);
        }
    }

    public static void print(boolean bl, Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if (default_debug && bl) {
            Debug.printFormatted(object);
        }
    }

    public static void printException(Exception exception) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if ((level & 8) != 0) {
            if (log_debug != null) {
                exception.printStackTrace(log_debug);
            } else {
                exception.printStackTrace();
            }
        }
    }

    public static void printFormatted(Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if (log_debug != null) {
            log_debug.println(object);
        } else {
            System.err.println(object);
        }
    }

    public static void println(int n, Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if ((level & n) != 0) {
            Debug.printFormatted(String.valueOf(String.valueOf(object)) + "\n");
        }
    }

    public static void println(Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if (default_debug) {
            Debug.printFormatted(String.valueOf(String.valueOf(object)) + "\n");
        }
    }

    public static void println(boolean bl, Object object) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        if (default_debug && bl) {
            Debug.printFormatted(String.valueOf(String.valueOf(object)) + "\n");
        }
    }

    public static void setDefault(boolean bl) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        default_debug = bl;
    }

    public static void setLevel(int n) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        level = n;
    }

    public static void setLog(PrintWriter printWriter) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        log_debug = printWriter;
    }

    public static void setOff(int n) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        level &= ~n;
    }

    public static void setOffAll() {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        level = 0;
        Debug.setDefault(false);
    }

    public static void setOn(int n) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        level |= n;
    }

    public static void setOnAll() {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.Debug");
        level = -1;
        Debug.setDefault(true);
    }
}

