/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.common;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.internal.CheckJawStaticMethodPermission;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class LoaderRepository
implements Serializable {
    private static Vector list = new Vector();
    private static Hashtable search = new Hashtable();

    public static void addClassLoader(ClassLoader classLoader) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.LoaderRepository");
        Debug.println("LoaderRepository::addClassLoader: Adding " + classLoader);
        list.addElement(classLoader);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.LoaderRepository");
        return LoaderRepository.loadClass((Vector)list.clone(), string);
    }

    private static Class loadClass(Vector vector, String string) throws ClassNotFoundException {
        Object var2_2 = null;
        int n = 0;
        while (n < vector.size()) {
            try {
                return ((ClassLoader)vector.elementAt(n)).loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n;
            }
        }
        throw new ClassNotFoundException(string);
    }

    public static Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Class clazz;
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.LoaderRepository");
        Debug.println("LoaderRepository::loadClassWithout: " + string + "\twithout " + classLoader);
        Vector vector = (Vector)list.clone();
        if (classLoader == null) {
            return LoaderRepository.loadClass(vector, string);
        }
        vector.removeElement(classLoader);
        LoaderRepository.startValidSearch(classLoader, string);
        try {
            clazz = LoaderRepository.loadClass(vector, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            LoaderRepository.stopValidSearch(classLoader, string);
            throw throwable;
        }
        LoaderRepository.stopValidSearch(classLoader, string);
        return clazz;
    }

    public static void removeClassLoader(ClassLoader classLoader) {
        CheckJawStaticMethodPermission.checkPermission("com.sun.jaw.reference.common.LoaderRepository");
        list.removeElement(classLoader);
    }

    private static synchronized void startValidSearch(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Vector<ClassLoader> vector = (Vector<ClassLoader>)search.get(string);
        if (vector != null && vector.contains(classLoader)) {
            Debug.println("LoaderRepository::startValidSearch: already requested loader=" + classLoader + " class= " + string);
            throw new ClassNotFoundException(string);
        }
        if (vector == null) {
            vector = new Vector<ClassLoader>(1);
            search.put(string, vector);
        }
        vector.addElement(classLoader);
        Debug.println("LoaderRepository::startValidSearch: loader=" + classLoader + " class= " + string);
    }

    private static synchronized void stopValidSearch(ClassLoader classLoader, String string) {
        Vector vector = (Vector)search.get(string);
        if (vector != null) {
            vector.removeElement(classLoader);
            Debug.println("LoaderRepository:: stopValidSearch loader=" + classLoader + " class= " + string);
        }
    }
}

