/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.common;

import com.sun.jaw.reference.common.MBeanInfo;
import com.sun.jaw.reference.common.internal.MBeanIntrospectorImpl;
import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MBeanIntrospector {
    private static Class[] indexedGetters = new Class[1];
    private static Class[] indexedSetters;

    static {
        MBeanIntrospector.indexedGetters[0] = Integer.TYPE;
        indexedSetters = new Class[2];
        MBeanIntrospector.indexedSetters[0] = Integer.TYPE;
    }

    public static Constructor findConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
        }
        catch (Exception exception) {
            return null;
        }
        return constructor;
    }

    public static Method findGetter(Class clazz, String string) {
        Method method = MBeanIntrospector.findMethod(clazz, "get" + string, null);
        if (method == null) {
            method = MBeanIntrospector.findMethod(clazz, "is" + string, null);
        }
        return method;
    }

    public static Method findIndexedGetter(Class clazz, String string) {
        Method method = MBeanIntrospector.findMethod(clazz, "get" + string, indexedGetters);
        if (method == null) {
            method = MBeanIntrospector.findMethod(clazz, "is" + string, indexedGetters);
        }
        return method;
    }

    public static Method findIndexedSetter(Class clazz, String string) {
        return MBeanIntrospector.findMethod(clazz, "set" + string, 2);
    }

    public static Method findIndexedSetter(Class clazz, String string, Class clazz2) {
        MBeanIntrospector.indexedSetters[1] = clazz2;
        Method method = MBeanIntrospector.findMethod(clazz, "set" + string, indexedSetters);
        while (method == null && indexedSetters[1].getSuperclass() != null) {
            MBeanIntrospector.indexedSetters[1] = indexedSetters[1].getSuperclass();
            method = MBeanIntrospector.findMethod(clazz, "set" + string, indexedSetters);
        }
        return method;
    }

    public static String[] findListOfActions(Class clazz, boolean bl) {
        return new String[0];
    }

    public static String[] findListOfProperties(Class clazz, boolean bl) {
        return new String[0];
    }

    public static Method findMethod(Class clazz, String string) {
        Method method = null;
        try {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length && !methodArray[n].getName().equals(string)) {
                ++n;
            }
            if (n < methodArray.length) {
                method = methodArray[n];
            }
        }
        catch (Exception exception) {}
        return method;
    }

    protected static Method findMethod(Class clazz, String string, int n) {
        Method method = null;
        try {
            Method[] methodArray = clazz.getMethods();
            int n2 = 0;
            boolean bl = false;
            while (n2 < methodArray.length && !bl) {
                bl = methodArray[n2].getName().equals(string);
                if (bl) {
                    bl = methodArray[n2].getParameterTypes().length == n;
                }
                ++n2;
            }
            if (bl) {
                method = methodArray[n2 - 1];
            }
        }
        catch (Exception exception) {}
        return method;
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {}
        return method;
    }

    public static Method findPerform(Class clazz, String string, Class[] classArray) {
        return MBeanIntrospector.findMethod(clazz, "perform" + string, classArray);
    }

    public static Method findSetter(Class clazz, String string) {
        return MBeanIntrospector.findMethod(clazz, "set" + string, 1);
    }

    public static Method findSetter(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        Method method = MBeanIntrospector.findMethod(clazz, "set" + string, classArray);
        while (method == null && classArray[0].getSuperclass() != null) {
            classArray[0] = classArray[0].getSuperclass();
            method = MBeanIntrospector.findMethod(clazz, "set" + string, classArray);
        }
        return method;
    }

    public static void flushCaches() {
        MBeanIntrospectorImpl.flushCaches();
    }

    public static void flushFromCaches(Class clazz) {
        MBeanIntrospectorImpl.flushFromCaches(clazz);
    }

    public static MBeanInfo getMBeanInfo(Class clazz) throws IntrospectionException {
        return MBeanIntrospectorImpl.getMBeanInfo(clazz);
    }

    public static MBeanInfo getMBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        return MBeanIntrospectorImpl.getMBeanInfo(clazz, clazz2);
    }
}

