/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.common.internal;

import com.sun.jaw.reference.common.MBeanIndexedProperty;
import com.sun.jaw.reference.common.internal.MBeanIntrospectorImpl;
import com.sun.jaw.reference.common.internal.MBeanPropertyImpl;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class MBeanIndexedPropertyImpl
extends MBeanPropertyImpl
implements MBeanIndexedProperty {
    private Class type = null;
    private boolean canRead = false;
    private boolean canWrite = false;
    private transient Class indexedPropertyType = null;
    private transient Method indexedReadMethod = null;
    private transient Method indexedWriteMethod = null;

    MBeanIndexedPropertyImpl(MBeanIndexedPropertyImpl mBeanIndexedPropertyImpl) {
        super(mBeanIndexedPropertyImpl);
        this.indexedReadMethod = mBeanIndexedPropertyImpl.indexedReadMethod;
        this.indexedWriteMethod = mBeanIndexedPropertyImpl.indexedWriteMethod;
        this.indexedPropertyType = mBeanIndexedPropertyImpl.indexedPropertyType;
        this.type = mBeanIndexedPropertyImpl.type;
        this.canRead = mBeanIndexedPropertyImpl.canRead;
        this.canWrite = mBeanIndexedPropertyImpl.canWrite;
    }

    MBeanIndexedPropertyImpl(MBeanPropertyImpl mBeanPropertyImpl, MBeanPropertyImpl mBeanPropertyImpl2) {
        super(mBeanPropertyImpl, mBeanPropertyImpl2);
        MBeanIndexedPropertyImpl mBeanIndexedPropertyImpl;
        if (mBeanPropertyImpl instanceof MBeanIndexedPropertyImpl) {
            mBeanIndexedPropertyImpl = (MBeanIndexedPropertyImpl)mBeanPropertyImpl;
            this.indexedReadMethod = mBeanIndexedPropertyImpl.indexedReadMethod;
            this.indexedWriteMethod = mBeanIndexedPropertyImpl.indexedWriteMethod;
            this.indexedPropertyType = mBeanIndexedPropertyImpl.indexedPropertyType;
            this.type = mBeanIndexedPropertyImpl.type;
        }
        if (mBeanPropertyImpl2 instanceof MBeanIndexedPropertyImpl) {
            mBeanIndexedPropertyImpl = (MBeanIndexedPropertyImpl)mBeanPropertyImpl2;
            if (mBeanIndexedPropertyImpl.indexedReadMethod != null) {
                this.indexedReadMethod = mBeanIndexedPropertyImpl.indexedReadMethod;
            }
            if (mBeanIndexedPropertyImpl.indexedWriteMethod != null) {
                this.indexedWriteMethod = mBeanIndexedPropertyImpl.indexedWriteMethod;
            }
            this.indexedPropertyType = mBeanIndexedPropertyImpl.indexedPropertyType;
            this.type = mBeanIndexedPropertyImpl.type;
        }
        this.findIndexedPropertyRights();
    }

    public MBeanIndexedPropertyImpl(String string, Method method, Method method2) throws IntrospectionException {
        super(string, null, null);
        this.indexedReadMethod = method;
        this.indexedWriteMethod = method2;
        this.findIndexedPropertyType();
        this.findIndexedPropertyRights();
    }

    private void findIndexedPropertyRights() {
        if (this.indexedReadMethod != null) {
            this.canRead = true;
        }
        if (this.indexedWriteMethod != null) {
            this.canWrite = true;
        }
    }

    private void findIndexedPropertyType() throws IntrospectionException {
        Object object;
        this.indexedPropertyType = null;
        if (this.indexedReadMethod != null) {
            object = this.indexedReadMethod.getParameterTypes();
            if (((Class<?>[])object).length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            this.indexedPropertyType = this.indexedReadMethod.getReturnType();
            if (this.indexedPropertyType == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (this.indexedWriteMethod != null) {
            object = this.indexedWriteMethod.getParameterTypes();
            if (((Class<?>[])object).length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (this.indexedPropertyType != null && this.indexedPropertyType != object[1]) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods");
            }
            this.indexedPropertyType = object[1];
        }
        if (!((object = this.getPropertyType()) == null || ((Class)object).isArray() && ((Class)object).getComponentType() == this.indexedPropertyType)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods");
        }
        this.type = MBeanIntrospectorImpl.toSerializable(this.indexedPropertyType);
    }

    public Class getIndexedPropertyType() {
        return this.indexedPropertyType;
    }

    public Method getIndexedReadMethod() {
        return this.indexedReadMethod;
    }

    public Class getIndexedType() {
        return this.type;
    }

    public Method getIndexedWriteMethod() {
        return this.indexedWriteMethod;
    }

    public boolean isIndexedReadable() {
        return this.canRead;
    }

    public boolean isIndexedWritable() {
        return this.canWrite;
    }
}

