/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.common.internal;

import com.sun.jaw.reference.common.MBeanInfo;
import com.sun.jaw.reference.common.internal.MBeanActionImpl;
import com.sun.jaw.reference.common.internal.MBeanIndexedPropertyImpl;
import com.sun.jaw.reference.common.internal.MBeanInfoImpl;
import com.sun.jaw.reference.common.internal.MBeanPropertyImpl;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class MBeanIntrospectorImpl {
    private Class beanClass;
    private MBeanInfo superBeanInfo;
    private Hashtable actions = new Hashtable();
    private Hashtable properties = new Hashtable();
    private static Hashtable mbeanInfoCache = new Hashtable();
    private static Hashtable declaredMethodCache = new Hashtable();
    private static Hashtable primitiveobjects = new Hashtable();

    static {
        primitiveobjects.put(Boolean.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Boolean"));
        primitiveobjects.put(Character.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Character"));
        primitiveobjects.put(Byte.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Byte"));
        primitiveobjects.put(Short.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Short"));
        primitiveobjects.put(Integer.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Integer"));
        primitiveobjects.put(Long.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Long"));
        primitiveobjects.put(Float.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Float"));
        primitiveobjects.put(Double.TYPE, MBeanIntrospectorImpl.getClass("java.lang.Double"));
    }

    private MBeanIntrospectorImpl(Class clazz, Class clazz2) throws IntrospectionException {
        Class clazz3;
        Object object;
        this.beanClass = clazz;
        if (clazz2 != null) {
            boolean bl = false;
            object = clazz.getSuperclass();
            while (object != null) {
                if (object == clazz2) {
                    bl = true;
                }
                object = ((Class)object).getSuperclass();
            }
            if (!bl) {
                throw new IntrospectionException(String.valueOf(clazz2.getName()) + " not superclass of " + clazz.getName());
            }
        }
        if ((clazz3 = clazz.getSuperclass()) != clazz2) {
            if (clazz2 == null) {
                this.superBeanInfo = (MBeanInfo)mbeanInfoCache.get(clazz3);
                if (this.superBeanInfo == null) {
                    object = new MBeanIntrospectorImpl(clazz3, null);
                    this.superBeanInfo = super.getMBeanInfo();
                    mbeanInfoCache.put(clazz3, this.superBeanInfo);
                }
            } else {
                object = new MBeanIntrospectorImpl(clazz3, clazz2);
                this.superBeanInfo = super.getMBeanInfo();
            }
        }
    }

    private void addAction(MBeanActionImpl mBeanActionImpl) {
        String string = mBeanActionImpl.getMethod().getName();
        MBeanActionImpl mBeanActionImpl2 = (MBeanActionImpl)this.actions.get(string);
        if (mBeanActionImpl2 == null) {
            this.actions.put(string, mBeanActionImpl);
            return;
        }
        Class<?>[] classArray = mBeanActionImpl.getMethod().getParameterTypes();
        Class<?>[] classArray2 = mBeanActionImpl2.getMethod().getParameterTypes();
        boolean bl = false;
        if (classArray.length == classArray2.length) {
            bl = true;
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n] != classArray2[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            MBeanActionImpl mBeanActionImpl3 = new MBeanActionImpl(mBeanActionImpl2, mBeanActionImpl);
            this.actions.put(string, mBeanActionImpl3);
            return;
        }
        String string2 = this.makeQualifiedActionName(mBeanActionImpl);
        mBeanActionImpl2 = (MBeanActionImpl)this.actions.get(string2);
        if (mBeanActionImpl2 == null) {
            this.actions.put(string2, mBeanActionImpl);
            return;
        }
        MBeanActionImpl mBeanActionImpl4 = new MBeanActionImpl(mBeanActionImpl2, mBeanActionImpl);
        this.actions.put(string2, mBeanActionImpl4);
    }

    private void addProperty(MBeanPropertyImpl mBeanPropertyImpl) {
        String string = mBeanPropertyImpl.getName();
        MBeanPropertyImpl mBeanPropertyImpl2 = (MBeanPropertyImpl)this.properties.get(string);
        if (mBeanPropertyImpl2 == null) {
            this.properties.put(string, mBeanPropertyImpl);
            return;
        }
        Class clazz = mBeanPropertyImpl2.getType();
        Class clazz2 = mBeanPropertyImpl.getType();
        if (clazz != null && clazz2 != null && clazz != clazz2) {
            this.properties.put(string, mBeanPropertyImpl);
            return;
        }
        MBeanPropertyImpl mBeanPropertyImpl3 = mBeanPropertyImpl2 instanceof MBeanIndexedPropertyImpl || mBeanPropertyImpl instanceof MBeanIndexedPropertyImpl ? new MBeanIndexedPropertyImpl(mBeanPropertyImpl2, mBeanPropertyImpl) : new MBeanPropertyImpl(mBeanPropertyImpl2, mBeanPropertyImpl);
        this.properties.put(string, mBeanPropertyImpl3);
    }

    protected static String findSignature(Class clazz) {
        return clazz.getName();
    }

    protected static String[] findSignatures(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = MBeanIntrospectorImpl.findSignature(classArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static void flushCaches() {
        mbeanInfoCache.clear();
        declaredMethodCache.clear();
    }

    public static void flushFromCaches(Class clazz) {
        mbeanInfoCache.remove(clazz);
        declaredMethodCache.remove(clazz);
    }

    private static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private MBeanInfoImpl getMBeanInfo() {
        MBeanPropertyImpl[] mBeanPropertyImplArray = this.getTargetPropertyInfo();
        MBeanActionImpl[] mBeanActionImplArray = this.getTargetActionInfo();
        return new MBeanInfoImpl(this.beanClass.getName(), mBeanPropertyImplArray, mBeanActionImplArray);
    }

    public static MBeanInfo getMBeanInfo(Class clazz) throws IntrospectionException {
        MBeanInfoImpl mBeanInfoImpl = (MBeanInfoImpl)mbeanInfoCache.get(clazz);
        if (mBeanInfoImpl == null) {
            mBeanInfoImpl = new MBeanIntrospectorImpl(clazz, null).getMBeanInfo();
            mbeanInfoCache.put(clazz, mBeanInfoImpl);
        }
        return new MBeanInfoImpl(mBeanInfoImpl);
    }

    public static MBeanInfo getMBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        MBeanInfoImpl mBeanInfoImpl = new MBeanIntrospectorImpl(clazz, clazz2).getMBeanInfo();
        return new MBeanInfoImpl(mBeanInfoImpl);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        Class clazz2 = clazz;
        Method[] methodArray = (Method[])declaredMethodCache.get(clazz2);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = clazz2.getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            Class[] classArray = method.getParameterTypes();
            Class<?> clazz3 = method.getReturnType();
            int n2 = method.getModifiers();
            if (!Modifier.isPublic(n2) || Modifier.isStatic(n2) || !MBeanIntrospectorImpl.isSerializable(classArray) || !MBeanIntrospectorImpl.isSerializable(clazz3)) {
                methodArray[n] = null;
            }
            ++n;
        }
        declaredMethodCache.put(clazz, methodArray);
        return methodArray;
    }

    private MBeanActionImpl[] getTargetActionInfo() {
        Object object;
        MBeanActionImpl[] mBeanActionImplArray;
        int n;
        Object[] objectArray;
        if (this.superBeanInfo != null) {
            objectArray = (MBeanActionImpl[])this.superBeanInfo.getActions();
            n = 0;
            while (n < objectArray.length) {
                this.addAction((MBeanActionImpl)objectArray[n]);
                ++n;
            }
        }
        objectArray = MBeanIntrospectorImpl.getPublicDeclaredMethods(this.beanClass);
        n = 0;
        while (n < objectArray.length) {
            mBeanActionImplArray = objectArray[n];
            if (mBeanActionImplArray != null) {
                object = mBeanActionImplArray.getName();
                MBeanActionImpl mBeanActionImpl = null;
                try {
                    if (((String)object).startsWith("perform") && !((String)object).equals("perform")) {
                        mBeanActionImpl = new MBeanActionImpl(((String)object).substring(7), (Method)mBeanActionImplArray);
                    }
                }
                catch (IntrospectionException introspectionException) {
                    mBeanActionImpl = null;
                }
                if (mBeanActionImpl != null) {
                    this.addAction(mBeanActionImpl);
                }
            }
            ++n;
        }
        mBeanActionImplArray = new MBeanActionImpl[this.actions.size()];
        object = this.actions.elements();
        int n2 = 0;
        while (n2 < mBeanActionImplArray.length) {
            mBeanActionImplArray[n2] = (MBeanActionImpl)object.nextElement();
            ++n2;
        }
        return mBeanActionImplArray;
    }

    private MBeanPropertyImpl[] getTargetPropertyInfo() {
        Object object;
        MBeanPropertyImpl[] mBeanPropertyImplArray;
        int n;
        Object[] objectArray;
        if (this.superBeanInfo != null) {
            objectArray = (MBeanPropertyImpl[])this.superBeanInfo.getProperties();
            n = 0;
            while (n < objectArray.length) {
                this.addProperty((MBeanPropertyImpl)objectArray[n]);
                ++n;
            }
        }
        objectArray = MBeanIntrospectorImpl.getPublicDeclaredMethods(this.beanClass);
        n = 0;
        while (n < objectArray.length) {
            mBeanPropertyImplArray = objectArray[n];
            if (mBeanPropertyImplArray != null) {
                object = mBeanPropertyImplArray.getName();
                Class<?>[] classArray = mBeanPropertyImplArray.getParameterTypes();
                Class<?> clazz = mBeanPropertyImplArray.getReturnType();
                int n2 = classArray.length;
                MBeanPropertyImpl mBeanPropertyImpl = null;
                try {
                    if (n2 == 0) {
                        if (((String)object).startsWith("get") && !((String)object).equals("get")) {
                            mBeanPropertyImpl = new MBeanPropertyImpl(((String)object).substring(3), (Method)mBeanPropertyImplArray, null);
                        } else if (clazz == Boolean.TYPE && ((String)object).startsWith("is") && !((String)object).equals("is")) {
                            mBeanPropertyImpl = new MBeanPropertyImpl(((String)object).substring(2), (Method)mBeanPropertyImplArray, null);
                        }
                    } else if (n2 == 1) {
                        if (classArray[0] == Integer.TYPE && ((String)object).startsWith("get") && !((String)object).equals("get")) {
                            mBeanPropertyImpl = new MBeanIndexedPropertyImpl(((String)object).substring(3), (Method)mBeanPropertyImplArray, null);
                        } else if (clazz == Void.TYPE && ((String)object).startsWith("set") && !((String)object).equals("set")) {
                            mBeanPropertyImpl = new MBeanPropertyImpl(((String)object).substring(3), null, (Method)mBeanPropertyImplArray);
                        }
                    } else if (n2 == 2 && classArray[0] == Integer.TYPE && ((String)object).startsWith("set") && !((String)object).equals("set")) {
                        mBeanPropertyImpl = new MBeanIndexedPropertyImpl(((String)object).substring(3), null, (Method)mBeanPropertyImplArray);
                    }
                }
                catch (IntrospectionException introspectionException) {
                    mBeanPropertyImpl = null;
                }
                if (mBeanPropertyImpl != null) {
                    this.addProperty(mBeanPropertyImpl);
                }
            }
            ++n;
        }
        mBeanPropertyImplArray = new MBeanPropertyImpl[this.properties.size()];
        object = this.properties.elements();
        int n3 = 0;
        while (n3 < mBeanPropertyImplArray.length) {
            mBeanPropertyImplArray[n3] = (MBeanPropertyImpl)object.nextElement();
            ++n3;
        }
        return mBeanPropertyImplArray;
    }

    private static boolean isSerializable(Class clazz) {
        return clazz.isPrimitive() || MBeanIntrospectorImpl.getClass("java.io.Serializable").isAssignableFrom(clazz) && !clazz.equals(MBeanIntrospectorImpl.getClass("java.lang.Class"));
    }

    private static boolean isSerializable(Class[] classArray) {
        int n = 0;
        while (n < classArray.length) {
            if (!MBeanIntrospectorImpl.isSerializable(classArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String makeQualifiedActionName(MBeanActionImpl mBeanActionImpl) {
        Method method = mBeanActionImpl.getMethod();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append("=");
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(":");
            stringBuffer.append(classArray[n].getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static Class toSerializable(Class clazz) {
        if (clazz == null || clazz.equals(Void.TYPE) || clazz.equals(MBeanIntrospectorImpl.getClass("java.lang.Void"))) {
            return null;
        }
        if (clazz.isPrimitive()) {
            return (Class)primitiveobjects.get(clazz);
        }
        return clazz;
    }

    protected static Class[] toSerializable(Class[] classArray) {
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = MBeanIntrospectorImpl.toSerializable(classArray[n]);
            ++n;
        }
        return classArray;
    }
}

