/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.common.internal;

import com.sun.jaw.reference.common.MBeanProperty;
import com.sun.jaw.reference.common.internal.MBeanFeatureImpl;
import com.sun.jaw.reference.common.internal.MBeanIntrospectorImpl;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class MBeanPropertyImpl
extends MBeanFeatureImpl
implements MBeanProperty {
    private Class type = null;
    private boolean canWrite = false;
    private boolean canRead = false;
    private transient Class propertyType = null;
    private transient Method readMethod = null;
    private transient Method writeMethod = null;

    MBeanPropertyImpl(MBeanPropertyImpl mBeanPropertyImpl) {
        super(mBeanPropertyImpl);
        this.readMethod = mBeanPropertyImpl.readMethod;
        this.writeMethod = mBeanPropertyImpl.writeMethod;
        this.propertyType = mBeanPropertyImpl.propertyType;
        this.type = mBeanPropertyImpl.type;
        this.canRead = mBeanPropertyImpl.canRead;
        this.canWrite = mBeanPropertyImpl.canWrite;
    }

    MBeanPropertyImpl(MBeanPropertyImpl mBeanPropertyImpl, MBeanPropertyImpl mBeanPropertyImpl2) {
        super(mBeanPropertyImpl, mBeanPropertyImpl2);
        Method method = mBeanPropertyImpl.readMethod;
        Method method2 = mBeanPropertyImpl2.readMethod;
        this.readMethod = method;
        if (method2 != null) {
            this.readMethod = method2;
        }
        if (method != null && method2 != null && method.getDeclaringClass() == method2.getDeclaringClass() && method.getReturnType() == Boolean.TYPE && method2.getReturnType() == Boolean.TYPE && method.getName().indexOf("is") == 0 && method2.getName().indexOf("get") == 0) {
            this.readMethod = method;
        }
        this.writeMethod = mBeanPropertyImpl.writeMethod;
        if (mBeanPropertyImpl2.writeMethod != null) {
            this.writeMethod = mBeanPropertyImpl2.writeMethod;
        }
        try {
            this.findPropertyType();
        }
        catch (IntrospectionException introspectionException) {
            throw new Error("MBeanPropertyImpl: internal error while merging PDs");
        }
        this.findPropertyRights();
    }

    public MBeanPropertyImpl(String string, Method method, Method method2) throws IntrospectionException {
        super(string);
        this.readMethod = method;
        this.writeMethod = method2;
        this.findPropertyType();
        this.findPropertyRights();
    }

    private void findPropertyRights() {
        if (this.readMethod != null) {
            this.canRead = true;
        }
        if (this.writeMethod != null) {
            this.canWrite = true;
        }
    }

    private void findPropertyType() throws IntrospectionException {
        this.propertyType = null;
        if (this.readMethod != null) {
            if (this.readMethod.getParameterTypes().length != 0) {
                throw new IntrospectionException("bad read method arg count");
            }
            this.propertyType = this.readMethod.getReturnType();
            if (this.propertyType == Void.TYPE) {
                throw new IntrospectionException("read method " + this.readMethod.getName() + " returns void");
            }
        }
        if (this.writeMethod != null) {
            Class<?>[] classArray = this.writeMethod.getParameterTypes();
            if (classArray.length != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            if (this.propertyType != null && this.propertyType != classArray[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            this.propertyType = classArray[0];
        }
        this.type = MBeanIntrospectorImpl.toSerializable(this.propertyType);
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Class getType() {
        return this.type;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isReadable() {
        return this.canRead;
    }

    public boolean isWritable() {
        return this.canWrite;
    }
}

