/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.query;

import com.sun.jaw.reference.query.BadAttributeValueException;
import com.sun.jaw.reference.query.BadBinaryOpExpressionException;
import com.sun.jaw.reference.query.BadStringOperationException;
import com.sun.jaw.reference.query.InvalidApplicationException;
import com.sun.jaw.reference.query.NumericValue;
import com.sun.jaw.reference.query.Query;
import com.sun.jaw.reference.query.StringValueExp;
import com.sun.jaw.reference.query.ValueExp;

public class BinaryOpExpression
extends ValueExp {
    private static String sccs_id = "@(#)BinaryOpExpression.java 3.1 09/29/98 SMI";
    private int op;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryOpExpression() {
    }

    public BinaryOpExpression(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.op = n;
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public ValueExp apply(Object object) throws BadStringOperationException, BadBinaryOpExpressionException, BadAttributeValueException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(object);
        ValueExp valueExp2 = this.exp2.apply(object);
        boolean bl = valueExp instanceof NumericValue;
        if (bl) {
            if (((NumericValue)valueExp).isLong()) {
                long l = ((NumericValue)valueExp).longValue();
                long l2 = ((NumericValue)valueExp2).longValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(l + l2);
                    }
                    case 2: {
                        return Query.value(l * l2);
                    }
                    case 1: {
                        return Query.value(l - l2);
                    }
                    case 3: {
                        return Query.value(l / l2);
                    }
                    default: {
                        throw new BadBinaryOpExpressionException(this);
                    }
                }
            }
            double d = ((NumericValue)valueExp).doubleValue();
            double d2 = ((NumericValue)valueExp2).doubleValue();
            switch (this.op) {
                case 0: {
                    return Query.value(d + d2);
                }
                case 2: {
                    return Query.value(d * d2);
                }
                case 1: {
                    return Query.value(d - d2);
                }
                case 3: {
                    return Query.value(d / d2);
                }
                default: {
                    throw new BadBinaryOpExpressionException(this);
                }
            }
        } else {
            String string = ((StringValueExp)valueExp).getValue();
            String string2 = ((StringValueExp)valueExp2).getValue();
            switch (this.op) {
                case 0: {
                    return new StringValueExp(String.valueOf(string) + string2);
                }
            }
            throw new BadStringOperationException(this.opString());
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public int getOperator() {
        return this.op;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    private String opString() throws BadBinaryOpExpressionException {
        switch (this.op) {
            case 0: {
                return "+";
            }
            case 2: {
                return "*";
            }
            case 1: {
                return "-";
            }
            case 3: {
                return "/";
            }
        }
        throw new BadBinaryOpExpressionException(this);
    }

    public String toString() {
        try {
            return String.valueOf(String.valueOf(this.exp1)) + " " + this.opString() + " " + this.exp2;
        }
        catch (BadBinaryOpExpressionException badBinaryOpExpressionException) {
            return "invalid expression";
        }
    }
}

