/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.query;

import com.sun.jaw.reference.query.BadAttributeValueException;
import com.sun.jaw.reference.query.BadBinaryOpExpressionException;
import com.sun.jaw.reference.query.BadStringOperationException;
import com.sun.jaw.reference.query.BooleanValue;
import com.sun.jaw.reference.query.InvalidApplicationException;
import com.sun.jaw.reference.query.NumericValue;
import com.sun.jaw.reference.query.QueryExp;
import com.sun.jaw.reference.query.StringValueExp;
import com.sun.jaw.reference.query.ValueExp;

public class BinaryRelQueryExp
extends QueryExp {
    private static String sccs_id = "@(#)BinaryRelQueryExp.java 3.1 09/29/98 SMI";
    private int relOp;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryRelQueryExp() {
    }

    public BinaryRelQueryExp(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.relOp = n;
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
    }

    public boolean apply(Object object) throws BadStringOperationException, BadBinaryOpExpressionException, BadAttributeValueException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(object);
        ValueExp valueExp2 = this.exp2.apply(object);
        boolean bl = valueExp instanceof NumericValue;
        boolean bl2 = valueExp instanceof BooleanValue;
        if (bl) {
            if (((NumericValue)valueExp).isLong()) {
                long l = ((NumericValue)valueExp).longValue();
                long l2 = ((NumericValue)valueExp2).longValue();
                switch (this.relOp) {
                    case 0: {
                        return l > l2;
                    }
                    case 1: {
                        return l < l2;
                    }
                    case 2: {
                        return l >= l2;
                    }
                    case 3: {
                        return l <= l2;
                    }
                    case 4: {
                        return l == l2;
                    }
                    default: {
                        return false;
                    }
                }
            }
            double d = ((NumericValue)valueExp).doubleValue();
            double d2 = ((NumericValue)valueExp2).doubleValue();
            switch (this.relOp) {
                case 0: {
                    return d > d2;
                }
                case 1: {
                    return d < d2;
                }
                case 2: {
                    return d >= d2;
                }
                case 3: {
                    return d <= d2;
                }
                case 4: {
                    return d == d2;
                }
                default: {
                    return false;
                }
            }
        }
        if (bl2) {
            boolean bl3 = ((BooleanValue)valueExp).getValue();
            boolean bl4 = ((BooleanValue)valueExp2).getValue();
            switch (this.relOp) {
                case 0: {
                    return bl3 && !bl4;
                }
                case 1: {
                    return !bl3 && bl4;
                }
                case 2: {
                    return bl3 || !bl4;
                }
                case 3: {
                    return !bl3 || bl4;
                }
                case 4: {
                    return bl3 == bl4;
                }
                default: {
                    return false;
                }
            }
        }
        String string = ((StringValueExp)valueExp).getValue();
        String string2 = ((StringValueExp)valueExp2).getValue();
        switch (this.relOp) {
            case 0: {
                return string.compareTo(string2) > 0;
            }
            case 1: {
                return string.compareTo(string2) < 0;
            }
            case 2: {
                return string.compareTo(string2) >= 0;
            }
            case 3: {
                return string.compareTo(string2) <= 0;
            }
            case 4: {
                return string.compareTo(string2) == 0;
            }
        }
        return false;
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
        }
        return "=";
    }

    public String toString() {
        return "(" + this.exp1 + ") " + this.relOpString() + " (" + this.exp2 + ")";
    }
}

