/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.common;

import com.sun.jaw.reference.common.Enumerated;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpValue;

public class SnmpInt
extends SnmpValue {
    static final String name = "Integer32";
    protected long value = 0L;

    public SnmpInt(int n) throws IllegalArgumentException {
        if (!this.isInitValueValid(n)) {
            throw new IllegalArgumentException();
        }
        this.value = n;
    }

    public SnmpInt(long l) throws IllegalArgumentException {
        if (!this.isInitValueValid(l)) {
            throw new IllegalArgumentException();
        }
        this.value = l;
    }

    public SnmpInt(Enumerated enumerated) throws IllegalArgumentException {
        this(enumerated.intValue());
    }

    public SnmpInt(Integer n) throws IllegalArgumentException {
        this((int)n);
    }

    public SnmpInt(Long l) throws IllegalArgumentException {
        this((long)l);
    }

    public SnmpInt(boolean bl) {
        this.value = bl ? 1 : 2;
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        if (snmpOid.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        snmpOid2.append(snmpOid);
    }

    public final synchronized Object clone() {
        SnmpInt snmpInt = null;
        try {
            snmpInt = (SnmpInt)super.clone();
            snmpInt.value = this.value;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpInt;
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public String getTypeName() {
        return name;
    }

    public int intValue() {
        return (int)this.value;
    }

    protected boolean isInitValueValid(int n) {
        return n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE;
    }

    protected boolean isInitValueValid(long l) {
        return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
    }

    public long longValue() {
        return this.value;
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            throw new SnmpStatusException(2);
        }
        return n + 1;
    }

    public Integer toInteger() {
        return new Integer((int)this.value);
    }

    public Long toLong() {
        return new Long(this.value);
    }

    public SnmpOid toOid() {
        return new SnmpOid(this.value);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            return new SnmpOid(lArray[n]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

