/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.Article;
import com.sun.prodreg.RegException;
import com.sun.prodreg.Revision;
import com.sun.prodreg._;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;

class PKGArticle
extends Article {
    String abbreviation;
    boolean loaded = false;
    boolean partOfOS = false;
    boolean partOfMetaCluster = false;
    private static DateFormat dfinst = DateFormat.getDateTimeInstance(2, 3);
    private static DateFormat dfshort = DateFormat.getDateInstance(3);
    private static DateFormat dfmed = DateFormat.getDateInstance(2);

    PKGArticle(String string) throws RegException {
        super(string);
        this.abbreviation = string;
        this.setAttribute("uninstall", "x");
    }

    void assessDamage() {
        if (this.health != 1) {
            return;
        }
        File file = new File("/var/sadm/pkg/" + this.abbreviation + "/pkginfo");
        if (file.exists()) {
            this.health = 3;
        } else {
            this.damageReason = _.__("packageRemovedWoInstallerEr");
            this.health = 2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date gropeVERSION(String string) {
        int n = string.indexOf(",REV=");
        if (n < 0) {
            return null;
        }
        try {
            String string2 = string.substring(n + 5);
            int[] nArray = new int[20];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (string2.indexOf(46, n3) < 0 && string2.length() >= 8) {
                nArray[0] = Integer.parseInt(string2.substring(0, 4));
                nArray[1] = Integer.parseInt(string2.substring(4, 6));
                nArray[2] = Integer.parseInt(string2.substring(6, 8));
            } else {
                while (n2 < 16 && n4 >= 0) {
                    n4 = string2.indexOf(46, n3);
                    String string3 = n4 < 0 ? string2.substring(n3) : string2.substring(n3, n4);
                    nArray[n2++] = Integer.parseInt(string3);
                    n3 = n4 + 1;
                }
            }
            int n5 = 0;
            while (true) {
                if (n5 >= 16 || nArray[n5] >= 90) {
                    if (nArray[n5] < 1000) {
                        int n6 = n5;
                        nArray[n6] = nArray[n6] + 1900;
                    }
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.set(nArray[n5], nArray[n5 + 1] - 1, nArray[n5 + 2]);
                    return gregorianCalendar.getTime();
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.readOnePkg(this.abbreviation);
        this.loaded = true;
    }

    public static PKGArticle lookupPKG(String string) {
        Article article = (Article)Article.index.get(string.toLowerCase());
        while (article != null) {
            if (article instanceof PKGArticle) {
                PKGArticle pKGArticle = (PKGArticle)article;
                if (pKGArticle.abbreviation.equals(string)) {
                    return pKGArticle;
                }
            }
            article = article.nextSame;
        }
        return null;
    }

    private void putIf(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            return;
        }
        ((Hashtable)properties).put(string, string3);
    }

    private void readInstallDirectory(File file, String string) {
    }

    private void readOnePkg(String string) {
        File file = new File("/var/sadm/pkg", string);
        this.readPkgInfo(file, string);
    }

    private void readPkgInfo(File file, String string) {
        this.mnemonic = string;
        this.setAttribute("mnemonic", string);
        try {
            Object object;
            File file2 = new File(file, "pkginfo");
            FileInputStream fileInputStream = new FileInputStream(file2);
            this.props.load(fileInputStream);
            fileInputStream.close();
            this.putIf(this.props, "title", "NAME");
            this.putIf(this.props, "vendor", "VENDOR");
            this.putIf(this.props, "tsemail", "EMAIL");
            this.putIf(this.props, "tsphone", "HOTLINE");
            String string2 = this.props.getProperty("VERSION");
            int n = string2.indexOf(",");
            String string3 = n > 0 ? string2.substring(0, n) : string2;
            Date date = Revision.nullDate;
            try {
                object = this.props.getProperty("INSTDATE");
                object = String.valueOf(((String)object).substring(4, 6)) + '-' + ((String)object).substring(0, 3) + '-' + ((String)object).substring(9, 11) + ' ' + ((String)object).substring(12, 17) + " AM";
                date = dfinst.parse((String)object);
            }
            catch (Exception exception) {}
            object = new Revision(string3, null, null, date);
            this.revise((Revision)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setAttribute("description", _.__("packageRemovedEr", string));
            this.health = 2;
            this.damageReason = _.__("packageRemovedWoInstallerEr");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readSaveDirectory(File file, String string) {
    }

    public String toString() {
        this.load();
        return super.toString();
    }
}

