/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.Article;
import com.sun.prodreg.CannotRegister;
import com.sun.prodreg.DataSheetStream;
import com.sun.prodreg.FileCount;
import com.sun.prodreg.LabelBlock;
import com.sun.prodreg.OutlineNode;
import com.sun.prodreg.ProdReg;
import com.sun.prodreg.RegException;
import com.sun.prodreg.Revision;
import com.sun.prodreg.SwingTreeNode;
import com.sun.prodreg.ViewableNode;
import com.sun.prodreg._;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Registry
implements ViewableNode {
    Vector articles;
    File database;
    File readlock;
    File writelock;
    String rootDir;
    String regTitle;
    String regDesc;
    Article[] visibleProducts;
    boolean collapsed = true;
    SwingTreeNode equivalent;
    Hashtable readInPkgs = new Hashtable();
    private static final int maxwait = 3;
    private static final int delayunit = 2000;
    private static CRC32 crc = new CRC32();

    private Registry(String string, String string2) {
        this.articles = new Vector();
        this.regTitle = string;
        this.regDesc = string2;
    }

    void add(Article article) {
        this.articles.addElement(article);
        article.includeInIndex();
    }

    private Article addAnArticle(String string, String string2, FileCount fileCount) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        properties.load(fileInputStream);
        if (string2 != null) {
            ((Hashtable)properties).put("installlocation", string2);
        }
        Article article = new Article(properties);
        article.chooseID();
        this.add(article);
        return article;
    }

    public Properties getAttrs() {
        Properties properties = new Properties();
        ((Hashtable)properties).put(this.regTitle, this.regDesc);
        ((Hashtable)properties).put(_.__("toSeeDetails"), _.__("clickLower"));
        return properties;
    }

    public OutlineNode getChild(int n) {
        return this.visibleProducts[n];
    }

    public int getChildCount() {
        return this.visibleProducts.length;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isDamaged() {
        return false;
    }

    public static String list(String string, String[] stringArray) throws Exception {
        Registry.openAllRegistries(false);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        while (n < ProdReg.allRegistries.length) {
            Registry registry = ProdReg.allRegistries[n];
            int n2 = 0;
            while (n2 < registry.articles.size()) {
                Article article = (Article)registry.articles.elementAt(n2);
                if (article.getAttribute(string) != null) {
                    printWriter.print(article.getAttribute(stringArray[0], ""));
                    int n3 = 1;
                    while (n3 < stringArray.length) {
                        printWriter.print('\t');
                        printWriter.print(article.getAttribute(stringArray[n3], ""));
                        ++n3;
                    }
                    printWriter.println();
                }
                ++n2;
            }
            ++n;
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    private void loadAll(boolean bl) throws IOException {
        if (bl) {
            this.loadWriteLock();
        } else {
            this.loadReadOnly();
        }
    }

    private static Article[] loadInDatasheets() throws Exception {
        Object[] objectArray;
        Vector<Article> vector = new Vector<Article>();
        InputStream inputStream = System.in;
        DataSheetStream dataSheetStream = new DataSheetStream(inputStream);
        while (dataSheetStream.reOpen()) {
            objectArray = new Properties();
            objectArray.load(dataSheetStream);
            String string = objectArray.getProperty("installlocation");
            if (string != null) {
                string = new File(string).getCanonicalPath();
                objectArray.put("installlocation", string);
            }
            vector.addElement(new Article((Properties)objectArray));
        }
        System.out.println();
        objectArray = new Article[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void loadNaked(File file) throws Exception {
        ZipEntry zipEntry;
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        this.articles = new Vector();
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            string = string.substring(0, string.lastIndexOf(46));
            Revision[] revisionArray = Revision.loadRevSection(zipInputStream);
            Article article = new Article(string);
            article.revisions = revisionArray;
            article.props.load(zipInputStream);
            article.id = article.props.getProperty("id");
            if (article.id == null) {
                System.err.println("No ID for article " + article.getTitle() + ", reassigning.");
                ((Hashtable)article.props).remove("chosenid");
                article.chooseID();
            }
            this.add(article);
            StringTokenizer stringTokenizer = new StringTokenizer(article.props.getProperty("pkgs", ""));
            while (stringTokenizer.hasMoreTokens()) {
                this.readInPkgs.put(stringTokenizer.nextToken(), article);
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
        fileInputStream.close();
    }

    private void loadReadOnly() throws IOException {
        File file = this.database;
        if (!file.exists()) {
            file = this.readlock;
        }
        if (!file.exists()) {
            return;
        }
        try {
            this.loadNaked(file);
        }
        catch (Exception exception) {
            throw new IOException(_.__("registryReadEr", exception.toString()));
        }
    }

    private void loadWriteLock() throws IOException {
        int n = 0;
        if (!this.database.exists()) {
            if (!this.readlock.exists() && !this.writelock.exists()) {
                return;
            }
            n = 0;
            while (n < 3) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.database.exists()) break;
                ++n;
            }
            if (n >= 3) {
                if (this.readlock.exists()) {
                    this.readlock.renameTo(this.database);
                } else if (this.writelock.exists()) {
                    this.writelock.renameTo(this.database);
                }
            }
        }
        try {
            n = 0;
            while (n < 3 && !this.database.renameTo(this.readlock)) {
                Thread.sleep(2000L);
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (n >= 3) {
            throw new IOException(_.__("regInaccessibleEr", this.database.toString()));
        }
        try {
            this.loadNaked(this.readlock);
        }
        catch (Exception exception) {
            throw new IOException(_.__("registryReadEr", exception.toString()));
        }
    }

    public static String lookup(String string) throws Exception {
        Registry.openAllRegistries(false);
        Article article = Article.lookup(string);
        String string2 = "";
        while (article != null) {
            string2 = String.valueOf(string2) + article.getSummaryParagraph() + "\n\n";
            article = article.getNextSame();
        }
        return string2;
    }

    public static String lookup(String string, String string2) throws Exception {
        Registry.openAllRegistries(false);
        Article article = Article.lookup(string, string2);
        if (article != null) {
            return String.valueOf(article.getSummaryParagraph()) + "\n\n";
        }
        return "";
    }

    private void mergeInNewArticles(Article article, String string, Vector vector, Article[] articleArray) throws RegException {
        String string2 = article.getAttribute("articles", " ");
        if (string2.length() == 0 || string2.charAt(string2.length() - 1) != ' ') {
            string2 = String.valueOf(string2) + ' ';
        }
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.indexOf(String.valueOf(string3) + ' ') >= 0) continue;
            vector2.addElement(string3);
        }
        int n = 0;
        while (n < vector2.size()) {
            String string4 = (String)vector2.elementAt(n);
            int n2 = 0;
            while (n2 < articleArray.length) {
                if (articleArray[n2] != null && articleArray[n2].mnemonic.equals(string4)) break;
                ++n2;
            }
            if (n2 >= articleArray.length) {
                throw new CannotRegister(_.__("articleNotRegEr", string4, article.mnemonic));
            }
            Article article2 = articleArray[n2];
            articleArray[n2] = null;
            article2.chooseID();
            this.add(article2);
            vector.addElement(article2);
            string2 = String.valueOf(string2) + string4 + ' ';
            ++n;
        }
        article.setAttribute("articles", string2);
    }

    static void openAllRegistries(boolean bl) throws IOException {
        if (!bl && ProdReg.allRegistries != null) {
            ProdReg.prTrace("returning from open all registries cuz its done aready");
            return;
        }
        ProdReg.prTrace("redoing all registries cuz its null");
        Article.resetIndex();
        Registry.openSystemRegistry(bl);
        String string = System.getProperty("prodreg.registries", "");
        String string2 = System.getProperty("user.name");
        if (string2.equals("root") || string.indexOf(117) < 0) {
            ProdReg.allRegistries = new Registry[]{ProdReg.systemRegistry};
            return;
        }
        Registry.openUserRegistry(bl);
        ProdReg.allRegistries = new Registry[]{ProdReg.systemRegistry, ProdReg.userRegistry};
    }

    static Registry openAppropriateRegistry(String string, boolean bl) throws IOException {
        String string2 = System.getProperty("user.name");
        String string3 = System.getProperty("prodreg.registries", "");
        if (string2.equals("root") || string3.indexOf(117) < 0) {
            Registry.openSystemRegistry(bl);
            return ProdReg.systemRegistry;
        }
        Registry.openUserRegistry(bl);
        return ProdReg.userRegistry;
    }

    public static Registry openContainingRegistry(Article article) throws Exception {
        if (ProdReg.allRegistries == null) {
            throw new Error("allRegistries not loaded yet");
        }
        int n = 0;
        while (n < ProdReg.allRegistries.length) {
            if (ProdReg.allRegistries[n].articles.contains(article)) break;
            ++n;
        }
        if (n >= ProdReg.allRegistries.length) {
            throw new RegException("openContainingRegistry: article not found (stale article ptr?)");
        }
        Registry registry = ProdReg.allRegistries[n];
        Article.resetIndex();
        Registry registry2 = new Registry(registry.regTitle, registry.regDesc);
        registry2.database = registry.database;
        registry2.readlock = registry.readlock;
        registry2.writelock = registry.writelock;
        registry2.rootDir = registry.rootDir;
        registry2.loadAll(true);
        return registry2;
    }

    static void openSystemRegistry(boolean bl) throws IOException {
        Registry registry = new Registry(_.__("systemSoftware"), _.__("swOnSystem"));
        registry.rootDir = "/var/sadm/install";
        registry.database = new File(String.valueOf(registry.rootDir) + "/swProductRegistry");
        registry.readlock = new File(String.valueOf(registry.rootDir) + "/swProductRegistry.backup");
        registry.writelock = new File(String.valueOf(registry.rootDir) + "/swProductRegistry.genesis");
        registry.loadAll(bl);
        registry.rootDir = "";
        ProdReg.systemRegistry = registry;
    }

    static void openUserRegistry(boolean bl) throws IOException {
        Registry registry = new Registry(_.__("userSoftware", System.getProperty("user.name")), _.__("yourHomeDirectory"));
        registry.rootDir = System.getProperty("user.home");
        registry.database = new File(String.valueOf(registry.rootDir) + "/.swProductRegistry");
        registry.readlock = new File(String.valueOf(registry.rootDir) + "/.swProductRegistry.backup");
        registry.writelock = new File(String.valueOf(registry.rootDir) + "/.swProductRegistry.genesis");
        registry.loadAll(bl);
        ProdReg.userRegistry = registry;
    }

    public static void register() throws Exception {
        Article[] articleArray = Registry.loadInDatasheets();
        Article article = articleArray[0];
        String string = article.getAttribute("installlocation");
        if (string != null) {
            string = new File(string).getCanonicalPath();
            article.setAttribute("installlocation", string);
        }
        Registry.openAllRegistries(false);
        String string2 = article.getAttribute("id");
        if (string2 != null) {
            Registry.reviseExistingDatasheets(articleArray, string, string2);
            return;
        }
        Article article2 = Article.lookupByLoc(article.getAttribute("mnemonic"), string);
        if (article2 != null) {
            String string3 = "###";
            if (article2.revisions != null) {
                string3 = article2.revisions[article2.revisions.length - 1].version;
            }
            String string4 = "@@@";
            if (article.revisions != null) {
                string4 = article.revisions[article.revisions.length - 1].version;
            }
            if (!string3.equals(string4)) {
                article2 = null;
            }
        }
        if (article2 != null) {
            Registry.reviseExistingDatasheets(articleArray, string, article2.id);
            return;
        }
        Article.resetIndex();
        Registry.welcomeNewDatasheets(articleArray, string);
    }

    public static String register(String string, String string2) throws Exception {
        return Registry.register(string, string2, null, null);
    }

    public static String register(String string, String string2, String string3, String string4) throws Exception {
        Article article;
        FileCount fileCount = null;
        if (!string.equals("-")) {
            string = new File(string).getCanonicalPath();
            fileCount = new FileCount(string);
        } else {
            string = null;
        }
        Registry registry = Registry.openAppropriateRegistry(string, true);
        try {
            article = registry.addAnArticle(string2, string, fileCount);
            if (string3 != null) {
                Article article2 = Article.lookup(string3, string4);
                if (article2 == null) {
                    throw new IllegalArgumentException(_.__("noSuchArticleEr", string3, string4));
                }
                article2.setAttribute("articles", String.valueOf(article2.getAttribute("articles", "")) + article.mnemonic + " ");
                article2.setAttribute("articleids", String.valueOf(article2.getAttribute("articleids", "")) + article.id + " ");
                article.setAttribute("parent", article2.mnemonic);
                article.setAttribute("parentid", article2.id);
            }
            registry.save();
        }
        catch (Exception exception) {
            registry.revert();
            System.err.println(_.__("regEr"));
            System.err.println(exception.toString());
            return "";
        }
        return article.getAttribute("id");
    }

    void remove(Article article) {
        this.articles.removeElement(article);
        article.removeFromIndex();
        String string = article.getAttribute("articles");
        if (string == null) {
            return;
        }
        String string2 = article.getAttribute("articleids");
        if (string2 == null) {
            throw new Error("No articleids attribute for " + article.getTitle());
        }
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < string2.length()) {
            int n3;
            int n4 = string.indexOf(" ", n);
            if (n4 < 0) {
                n4 = string.length();
            }
            if ((n3 = string2.indexOf(" ", n2)) < 0) {
                n3 = string2.length();
            }
            Article article2 = Article.lookup(string.substring(n, n4), string2.substring(n2, n3));
            this.remove(article2);
            n = n4 + 1;
            n2 = n3 + 1;
        }
    }

    void revert() {
        this.readlock.renameTo(this.database);
        try {
            this.writelock.delete();
        }
        catch (SecurityException securityException) {}
    }

    private void reviseArticle(Article article, Article article2, Vector vector, Article[] articleArray) throws RegException {
        Enumeration enumeration = ((Hashtable)article2.props).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = article2.getAttribute(string);
            if (string.equals("articles")) {
                this.mergeInNewArticles(article, string2.toLowerCase(), vector, articleArray);
                continue;
            }
            if (string.equals("articleids") || string.equals("parent") || string.equals("parentid") || string.equals("id") || string.equals("chosenid")) continue;
            article.setAttribute(string, string2);
        }
        if (article2.revisions != null) {
            article.revise(article2.revisions[0]);
        }
    }

    private static void reviseExistingDatasheets(Article[] articleArray, String string, String string2) throws Exception {
        Article article = Article.lookup(articleArray[0].mnemonic, string2);
        if (article == null) {
            System.err.println(_.__("noSuchArticleEr", articleArray[0].mnemonic, string2));
            return;
        }
        Registry registry = Registry.openContainingRegistry(article);
        article = Article.lookup(article.mnemonic, article.id);
        try {
            Vector vector = new Vector();
            registry.reviseTree(article, articleArray, vector);
            Object[] objectArray = new Article[vector.size()];
            vector.copyInto(objectArray);
            int n = 0;
            while (n < articleArray.length) {
                if (articleArray[n] != null) {
                    throw new CannotRegister(_.__("unlistedArticleEr", articleArray[n].mnemonic, article.mnemonic));
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                ((Article)objectArray[n2]).validate((Article[])objectArray);
                ++n2;
            }
            registry.save();
            System.out.println(_.__("registerSuccess"));
        }
        catch (Exception exception) {
            registry.revert();
            System.err.println(_.__("regEr"));
            System.err.println(exception.toString());
        }
    }

    private void reviseTree(Article article, Article[] articleArray, Vector vector) throws RegException {
        vector.addElement(article);
        int n = 0;
        while (n < articleArray.length) {
            if (articleArray[n] != null && articleArray[n].mnemonic.equals(article.mnemonic)) break;
            ++n;
        }
        if (n < articleArray.length) {
            this.reviseArticle(article, articleArray[n], vector, articleArray);
            articleArray[n] = null;
        }
        Enumeration enumeration = article.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Article article2 = (Article)enumeration.nextElement();
            if (article2 == null) continue;
            this.reviseTree(article2, articleArray, vector);
        }
    }

    void save() throws IOException {
        try {
            this.saveNaked();
            this.writelock.renameTo(this.database);
            try {
                this.readlock.delete();
            }
            catch (SecurityException securityException) {}
        }
        catch (Exception exception) {
            String string = _.__("registryWriteEr", this.database.toString(), exception.toString());
            if (exception instanceof FileNotFoundException) {
                string = String.valueOf(string) + _.__("registryWriteExcuses");
            }
            this.revert();
            throw new IOException(string);
        }
    }

    private void saveArticle(Article article, ZipOutputStream zipOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
        Revision.saveRevSection(byteArrayOutputStream, article.revisions);
        article.props.save(byteArrayOutputStream, article.mnemonic);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = 0;
        Article article2 = article;
        while (article2 != null) {
            ++n;
            article2 = article2.nextSame;
        }
        ZipEntry zipEntry = new ZipEntry(String.valueOf(article.mnemonic) + "." + n);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray);
        zipOutputStream.closeEntry();
    }

    private void saveNaked() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.writelock);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        int n = 0;
        while (n < this.articles.size()) {
            this.saveArticle((Article)this.articles.elementAt(n), zipOutputStream);
            ++n;
        }
        try {
            zipOutputStream.close();
        }
        catch (ZipException zipException) {
            if (this.articles.isEmpty()) {
                this.writelock.delete();
            }
            throw zipException;
        }
        fileOutputStream.close();
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public void setView(LabelBlock labelBlock) {
        labelBlock.title.setText(this.regTitle);
    }

    public String toString() {
        return this.regTitle;
    }

    public static void uninstall(String string, String string2) throws Exception {
        Registry.openAllRegistries(false);
        Article article = string2.equals("-") ? Article.lookup(string) : Article.lookupByUnLoc(string, string2);
        if (article == null) {
            System.err.println(_.__("noSuchArticleEr", string, string2));
            return;
        }
        article.uninstall();
        System.out.println(_.__("uninstallSuccess"));
    }

    public static void unregister(String string, String string2) throws Exception {
        Registry.openAllRegistries(false);
        Article article = string2.equals("-") ? Article.lookup(string) : Article.lookupByUnLoc(string, string2);
        if (article == null) {
            System.err.println(_.__("noSuchArticleEr", string, string2));
            return;
        }
        article.unregister();
        System.out.println(_.__("unregisterSuccess"));
    }

    private static void welcomeNewDatasheets(Article[] articleArray, String string) throws Exception {
        Registry registry;
        int n;
        try {
            n = 0;
            while (n < articleArray.length) {
                articleArray[n].chooseID();
                ++n;
            }
            int n2 = 0;
            while (n2 < articleArray.length) {
                articleArray[n2].validate(articleArray);
                ++n2;
            }
            registry = Registry.openAppropriateRegistry(string, true);
        }
        catch (Exception exception) {
            System.err.println(_.__("regEr"));
            System.err.println(exception.toString());
            return;
        }
        try {
            n = 0;
            while (n < articleArray.length) {
                registry.add(articleArray[n]);
                ++n;
            }
            registry.save();
            System.out.println(_.__("registerSuccess"));
        }
        catch (Exception exception) {
            registry.revert();
            System.err.println(_.__("regEr"));
            System.err.println(exception.toString());
        }
    }
}

