/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.KioskCanvas;
import com.sun.prodreg.awt.RegNode;
import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ProdReg;
import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Polygon;
import java.util.Locale;
import java.util.Vector;

class Node {
    static int nodeIndent = 15;
    static int nodeLeading = 18;
    static Locale currentLocale;
    boolean expand = false;
    static Color markerColor;
    static Color selectColor;
    static Color nonSelectableColor;
    static Color disabledColor;
    static Color fontColor;
    static Node nodeSelected;
    Node parent;
    Runtime rt = Runtime.getRuntime();
    static Cursor currentCursor;
    Label nameLabel = null;
    private Vector childCache = null;
    private ProdRegTreeNode node = null;

    static {
        markerColor = Color.darkGray;
        selectColor = Color.blue;
        nonSelectableColor = new Color(100, 100, 100);
        disabledColor = new Color(100, 100, 100);
        fontColor = Color.black;
        nodeSelected = null;
    }

    public Node(ProdRegTreeNode prodRegTreeNode, boolean bl) {
        this.node = prodRegTreeNode;
        this.expand = bl;
    }

    public ProdRegTreeNode getTreeNode() {
        return this.node;
    }

    public void paintMarker(Graphics graphics, boolean bl, Color color, int n, int n2) {
        Polygon polygon = new Polygon();
        if (!this.node.isLeaf()) {
            if (bl) {
                if (KioskCanvas.openImage != null) {
                    graphics.drawImage(KioskCanvas.openImage, n - 15, n2 - 10, null);
                    return;
                }
                graphics.setColor(color);
                polygon.addPoint(n - 13, n2 - 6);
                polygon.addPoint(n - 9, n2 - 2);
                polygon.addPoint(n - 5, n2 - 6);
                graphics.fillPolygon(polygon);
            } else {
                if (KioskCanvas.closeImage != null) {
                    graphics.drawImage(KioskCanvas.closeImage, n - 15, n2 - 10, null);
                    return;
                }
                graphics.setColor(color);
                polygon.addPoint(n - 11, n2 - 9);
                polygon.addPoint(n - 11, n2 - 1);
                polygon.addPoint(n - 7, n2 - 5);
                graphics.fillPolygon(polygon);
            }
        }
        if (this.node.getComponentDescription().isDamaged()) {
            graphics.drawImage(KioskCanvas.damageImage, n - 30, n2 - 15, null);
        }
    }

    public int paintNode(Graphics graphics, boolean bl, Vector vector, int n, int n2) {
        String string = "";
        this.verify();
        Color color = !bl ? disabledColor : (!this.node.isSelectable() ? nonSelectableColor : markerColor);
        this.paintMarker(graphics, this.expand, color, n, n2);
        if (!bl) {
            graphics.setColor(disabledColor);
        } else if (!this.node.isSelectable()) {
            graphics.setColor(nonSelectableColor);
        } else if (this == nodeSelected) {
            graphics.setColor(selectColor);
        } else if (this == nodeSelected) {
            graphics.setColor(selectColor);
        } else {
            graphics.setColor(fontColor);
        }
        String string2 = this.node.toString();
        vector.addElement(new RegNode(this, n, n2));
        graphics.drawString(string2, n, n2);
        if (this.node.isSelectable() && !this.node.isLeaf() && this.expand) {
            int n3 = n2;
            int n4 = this.childCache.size();
            int n5 = 0;
            while (n5 < n4) {
                Node node = (Node)this.childCache.elementAt(n5);
                n3 = node.paintNode(graphics, bl, vector, n + nodeIndent, n3 + nodeLeading);
                ++n5;
            }
            return n3;
        }
        return n2;
    }

    public void refresh(Vector vector, boolean bl) {
        this.childCache = null;
        this.verify();
        String string = this.node.getComponentDescription().getID();
        if (vector.contains(string)) {
            if (bl) {
                this.expand = true;
            }
            nodeSelected = this;
        }
        int n = this.childCache.size();
        int n2 = 0;
        while (n2 < n) {
            Node node = (Node)this.childCache.elementAt(n2);
            node.refresh(vector, bl);
            ++n2;
        }
    }

    public Dimension requiredSize(FontMetrics fontMetrics, int n) {
        this.verify();
        String string = this.toString();
        if (string == null) {
            string = Localizer.resolve("<L ProdRegResources.NoDisplayName>");
        }
        int n2 = 0;
        int n3 = 0;
        n3 += nodeLeading;
        n2 += n + fontMetrics.stringWidth(string);
        if (!this.node.isLeaf() && this.expand) {
            int n4 = this.childCache.size();
            int n5 = 0;
            while (n5 < n4) {
                Node node = (Node)this.childCache.elementAt(n5);
                Dimension dimension = node.requiredSize(fontMetrics, n + nodeIndent);
                n3 += dimension.height;
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                ++n5;
            }
        }
        return new Dimension(n2, n3);
    }

    private void verify() {
        if (this.childCache == null) {
            ComponentReference[] componentReferenceArray;
            this.childCache = new Vector();
            Vector vector = new Vector();
            if (this.node.getComponentDescription() != null && (componentReferenceArray = this.node.getComponentDescription().getChildren()) != null) {
                ComponentDescription componentDescription;
                int n = 0;
                while (n < componentReferenceArray.length) {
                    componentDescription = ComponentDescriptionLookup.get(componentReferenceArray[n].getID());
                    if (componentDescription != null) {
                        vector.addElement(componentDescription);
                    } else if (ProdReg.debug) {
                        String string = this.node.getComponentDescription().getID();
                        System.out.println("warning: could not findchild of " + string + "with id " + componentReferenceArray[n].getID() + " could not be found");
                    }
                    ++n;
                }
                vector = Utils.alphaCache(vector);
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    componentDescription = (ComponentDescription)vector.elementAt(n3);
                    ProdRegTreeNode prodRegTreeNode = new ProdRegTreeNode(componentDescription);
                    Node node = new Node(prodRegTreeNode, false);
                    this.childCache.addElement(node);
                    ++n3;
                }
            }
        }
    }
}

