/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminPropertyNotFoundException;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.common.AdminVersion;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AuthenticationFlavor;
import com.sun.admin.cis.service.security.ClientSecurityContext;
import com.sun.admin.cis.service.security.DigestAuthFlavor;
import com.sun.admin.cis.service.security.DigestClientSecurityContext;
import com.sun.admin.cis.service.security.DigestSecurityUtil;
import com.sun.admin.cis.service.security.WeakAuthFlavor;
import com.sun.admin.cis.service.security.WeakClientSecurityContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdminClientInfo {
    static final String ADM_DFLT_SERVER_NAME = "com.sun.admin.cis.server.AdminServer";
    static final int ADM_DFLT_PORT_NUMBER = 1099;
    static final String ADM_DFLT_AUTH_TYPE = "weak";
    static final String ADM_DFLT_SEC_PROVIDER = "sun.security.provider.SUN";
    static final String ADM_DFLT_LOCAL_HOST = "localhost";
    static final String ADM_SCOPE_FILE_NAME = "AdminScopes.properties";
    static final String CLIENT_TRACE_FILETYPE = "file";
    private String serverhost;
    private int portnum;
    private String svrname;
    private AdminProps cliProps;
    private String cliSecProv;
    private ClientSecurityContext cliSec;
    private AuthenticationFlavor cliAuth;
    private String scopepath;
    private String scopefile;
    private String clienthost;

    public AdminClientInfo(String string) throws AdminException {
        this.cliProps = string == null || string.trim().length() == 0 ? new AdminProps("admin.client.properties", "AdminClient.properties", 0) : new AdminProps(string, 0);
        this.initProperties();
        this.initScopes();
        this.initSecurity();
    }

    public void initTrace(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.getClientProperty("admin.trace.level");
        }
        catch (Exception exception) {
            string3 = null;
        }
        int n = 0;
        if (string3 != null && string3.trim().length() > 0) {
            try {
                n = new Integer(string3);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        string3 = null;
        try {
            string3 = this.getClientProperty("admin.trace.device");
        }
        catch (Exception exception) {
            string3 = null;
        }
        if (string3 == null || string3.trim().length() == 0) {
            string3 = CLIENT_TRACE_FILETYPE;
        }
        if (string3.equals(CLIENT_TRACE_FILETYPE)) {
            if (string != null && string.trim().length() > 0) {
                string3 = string;
            } else {
                n = 0;
            }
        }
        AdminCommonTools.CMN_TraceOpen(n, string3);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy 'at' hh:mm:ss z");
        string3 = simpleDateFormat.format(new Date());
        AdminCommonTools.CMN_Trace1(String.valueOf(string2) + ", version " + AdminVersion.getVersionString() + ", initializing at " + string3);
    }

    public ClientSecurityContext getSecurityContext() {
        return this.cliSec;
    }

    public String getClientHostName() {
        return this.clienthost;
    }

    public String getServerHostName() {
        return this.serverhost;
    }

    public void setServerHostName(String string) {
        this.serverhost = string;
    }

    public int getServerPort() {
        return this.portnum;
    }

    public void setServerPort(int n) {
        this.portnum = n;
    }

    public String getServerName() {
        return this.svrname;
    }

    public void setServerName(String string) {
        this.svrname = string;
    }

    public AuthenticationFlavor getAuthFlavor() {
        return this.cliAuth;
    }

    public void setAuthFlavor(AuthenticationFlavor authenticationFlavor) {
        this.cliAuth = authenticationFlavor;
    }

    public String getClientProperty(String string) throws AdminException {
        return this.cliProps.getAdminProp(string);
    }

    public Vector getClientPropertyList(String string) throws AdminException {
        return this.cliProps.getAdminPropList(string);
    }

    public void setClientProperty(String string, String string2) throws AdminException {
        this.cliProps.putAdminProp(string, string2);
    }

    public Vector getClientComponents() throws AdminException {
        return this.getClientPropertyList("admin.app");
    }

    public synchronized Vector getMgmtScopeList() throws AdminException {
        return this.readMgmtScopes(this.scopefile);
    }

    public synchronized void addMgmtScope(AdminMgmtScope adminMgmtScope) throws AdminException {
        Vector vector = null;
        if (adminMgmtScope != null) {
            String string = adminMgmtScope.getMgmtScopeName();
            String string2 = adminMgmtScope.toDirectoryTableURL();
            vector = this.readMgmtScopes(this.scopefile);
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                AdminMgmtScope adminMgmtScope2 = (AdminMgmtScope)vector.elementAt(n);
                if (string.equals(adminMgmtScope2.getMgmtScopeName())) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                vector.setElementAt(adminMgmtScope, n);
            } else {
                vector.addElement(adminMgmtScope);
            }
            this.writeMgmtScopes(this.scopefile, vector);
        }
    }

    public synchronized void removeMgmtScope(String string) throws AdminException {
        Vector vector = null;
        if (string != null) {
            vector = this.readMgmtScopes(this.scopefile);
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                AdminMgmtScope adminMgmtScope = (AdminMgmtScope)vector.elementAt(n);
                if (string.equals(adminMgmtScope.getMgmtScopeName())) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                vector.removeElementAt(n);
                this.writeMgmtScopes(this.scopefile, vector);
            }
        }
    }

    public AdminClientComponent createClientComponent(String string) throws AdminException {
        AdminClientComponent adminClientComponent = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Create component: cannot find class file for: " + string);
            throw new AdminClientException("EXM_CFC", string);
        }
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.Object")};
            Object[] objectArray = new Object[]{this};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            adminClientComponent = (AdminClientComponent)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            AdminCommonTools.CMN_Trace1("Create component: exception thrown by client constructor: " + throwable.getMessage());
            throw new AdminClientException("EXM_CCC", string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Create component: cannot create application client: " + exception.getMessage());
            throw new AdminClientException("EXM_CCC", string);
        }
        return adminClientComponent;
    }

    private void initProperties() throws AdminException {
        String string;
        try {
            this.clienthost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_NSH");
        }
        this.serverhost = this.getClientProperty("admin.server.default");
        if (this.serverhost == null || this.serverhost.trim().length() == 0) {
            throw new AdminClientException("EXM_NSH");
        }
        if (this.serverhost.equals(ADM_DFLT_LOCAL_HOST)) {
            this.serverhost = this.clienthost;
        }
        if ((string = this.getClientProperty("admin.server.name")) == null || string.trim().length() == 0) {
            throw new AdminClientException("EXM_NCP", "admin.server.name");
        }
        this.svrname = string.concat(AdminVersion.getVersionSuffix());
        string = this.getClientProperty("admin.server.port");
        if (string == null || string.trim().length() == 0) {
            throw new AdminClientException("EXM_NCP", "admin.server.port");
        }
        try {
            this.portnum = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AdminClientException("EXM_NCP", "admin.server.port");
        }
        String string2 = this.getClientProperty("admin.security.auth.flavor");
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminClientException("EXM_NCP", "admin.security.auth.flavor");
        }
        this.cliSecProv = this.getClientProperty("admin.security.provider");
        if (this.cliSecProv == null || this.cliSecProv.trim().length() == 0) {
            throw new AdminClientException("EXM_NCP", "admin.security.provider");
        }
        if (string2.equals(ADM_DFLT_AUTH_TYPE)) {
            this.cliAuth = new WeakAuthFlavor();
            return;
        }
        if (string2.equals("digest")) {
            int n;
            String string3 = this.getClientProperty("admin.security.digest.algo");
            if (string3 == null || string3.trim().length() == 0) {
                string3 = "SHA";
            }
            string3 = "SHA";
            String string4 = this.getClientProperty("admin.security.sign.algo");
            if (string4 == null || string4.trim().length() == 0) {
                string4 = "DSA";
            }
            string4 = "DSA";
            String string5 = this.getClientProperty("admin.security.key.algo");
            if (string5 == null || string5.trim().length() == 0) {
                string5 = "DSA";
            }
            string5 = "DSA";
            string = this.getClientProperty("admin.security.key.strength");
            if (string == null || string.trim().length() == 0) {
                string = "1024";
            }
            try {
                n = new Integer(string);
                if (n > 1024) {
                    n = 1024;
                }
            }
            catch (Exception exception) {
                n = -1;
            }
            this.cliAuth = new DigestAuthFlavor(string3, string4, string5, n);
            return;
        }
        if (string2.equals("encryption")) {
            throw new AdminSecurityException("EXSS_UAF", string2);
        }
        throw new AdminSecurityException("EXSS_UAF", string2);
    }

    private void initScopes() throws AdminException {
        this.scopepath = this.cliProps.getAdminProp("admin.client.workdir");
        if (this.scopepath == null || this.scopepath.trim().length() == 0) {
            throw new AdminPropertyNotFoundException("admin.client.workdir");
        }
        this.scopefile = String.valueOf(this.scopepath) + File.separator + ADM_SCOPE_FILE_NAME;
    }

    private void initSecurity() throws AdminException {
        ClientSecurityContext clientSecurityContext = null;
        Provider provider = null;
        long l = System.currentTimeMillis();
        int n = this.cliAuth.getAuthType();
        switch (n) {
            case 0: {
                clientSecurityContext = new WeakClientSecurityContext();
                break;
            }
            case 1: {
                DigestAuthFlavor digestAuthFlavor = (DigestAuthFlavor)this.cliAuth;
                provider = this.getSecurityProvider();
                DigestSecurityUtil.initialize(provider, digestAuthFlavor.getDigestAlgorithm(), digestAuthFlavor.getSignatureAlgorithm(), digestAuthFlavor.getKeyGenerationAlgorithm(), digestAuthFlavor.getKeyStrength());
                clientSecurityContext = new DigestClientSecurityContext(digestAuthFlavor);
                break;
            }
            case 2: {
                throw new AdminSecurityException("EXSS_UAF", new Integer(n));
            }
            default: {
                throw new AdminSecurityException("EXSS_UAF", new Integer(n));
            }
        }
        this.cliSec = clientSecurityContext;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        long l4 = l3 / 1000L;
        long l5 = l3 - l4 * 1000L;
        AdminCommonTools.CMN_Trace2("Perform: init security=" + l4 + "." + l5);
    }

    private Provider getSecurityProvider() throws AdminClientException {
        Provider provider = null;
        if (this.cliSecProv != null && (provider = Security.getProvider(this.cliSecProv)) == null) {
            throw new AdminClientException("EXM_CSP", this.cliSecProv);
        }
        return provider;
    }

    private Vector readMgmtScopes(String string) {
        BufferedReader bufferedReader;
        FileReader fileReader;
        Vector<AdminMgmtScope> vector = new Vector<AdminMgmtScope>();
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            AdminCommonTools.CMN_Trace1("Read scopes: management scopes file not found");
            return vector;
        }
        String string2 = "";
        while (string2 != null) {
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            if (string2 == null || (string2 = string2.trim()).startsWith("#")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
            String string3 = null;
            String string4 = null;
            try {
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_Trace1("Read scopes: invalid management scope");
                string3 = null;
            }
            AdminMgmtScope adminMgmtScope = null;
            if (string3 != null) {
                try {
                    adminMgmtScope = new AdminMgmtScope(string3, string4);
                }
                catch (AdminException adminException) {
                    AdminCommonTools.CMN_Trace1("Read scopes: invalid management scope");
                    adminMgmtScope = null;
                }
            }
            if (adminMgmtScope == null) continue;
            vector.addElement(adminMgmtScope);
        }
        try {
            bufferedReader.close();
            fileReader.close();
        }
        catch (Exception exception) {}
        return vector;
    }

    private void writeMgmtScopes(String string, Vector vector) throws AdminException {
        PrintWriter printWriter;
        BufferedWriter bufferedWriter;
        FileWriter fileWriter;
        String string2 = "scopes.tmp";
        String string3 = "scopes.old";
        String string4 = "";
        int n = string.lastIndexOf(File.separator);
        if (n > -1) {
            string4 = string.substring(0, n);
        }
        File file = new File(String.valueOf(string4) + File.separator + string2);
        File file2 = new File(string);
        File file3 = new File(String.valueOf(string4) + File.separator + string3);
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Write scopes: unable to remove temporary scopes file");
            throw new AdminClientException("EXM_NWP", string);
        }
        try {
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            printWriter = new PrintWriter(bufferedWriter);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Write scopes: unable to open temporary scopes file");
            throw new AdminClientException("EXM_NWP", string);
        }
        printWriter.println("### Management Scopes - DO NOT EDIT THIS FILE ###");
        if (!printWriter.checkError()) {
            n = 0;
            while (n < vector.size()) {
                AdminMgmtScope adminMgmtScope = (AdminMgmtScope)vector.elementAt(n);
                String string5 = adminMgmtScope.getMgmtScopeName();
                String string6 = adminMgmtScope.toDirectoryTableURL();
                printWriter.println(String.valueOf(string5) + "=" + string6);
                if (printWriter.checkError()) break;
                ++n;
            }
        }
        try {
            printWriter.close();
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Write scopes: error closing temporary scopes file");
        }
        if (printWriter.checkError()) {
            AdminCommonTools.CMN_Trace1("Write scopes: error writing to temporary scopes file");
            throw new AdminClientException("EXM_NWP", string);
        }
        try {
            if (file3.exists()) {
                file3.delete();
            }
            if (file2.exists()) {
                file2.renameTo(file3);
            }
            file.renameTo(file2);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Write scopes: error changing scope file names");
            throw new AdminClientException("EXM_NWP", string);
        }
    }
}

