/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.logging;

import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.logging.AdminLogException;
import com.sun.admin.cis.service.logging.LogFilter;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactory;
import com.sun.admin.cis.service.security.SecurityToken;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class LogServiceWrapper {
    private AdminSession session;
    private LogServiceFactory logFactory;
    private String[] viewerLogFiles;
    private String[] serverLogFiles;

    public LogServiceWrapper(AdminSession adminSession, LogServiceFactory logServiceFactory) {
        this.session = adminSession;
        this.logFactory = logServiceFactory;
    }

    public LogRecord readRecord(long l, int n, String string) throws AdminException {
        LogRecord logRecord;
        String string2 = this.matchFileName(string);
        SecurityToken securityToken = this.session.getSecurityToken();
        try {
            logRecord = this.logFactory.readRecord(securityToken, l, n, string2);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return logRecord;
    }

    public long getNumRecords(String string) throws AdminException {
        long l;
        String string2 = this.matchFileName(string);
        SecurityToken securityToken = this.session.getSecurityToken();
        try {
            l = this.logFactory.getNumRecords(securityToken, string2);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return l;
    }

    public Vector getList(int n, LogFilter logFilter, long l, String string) throws AdminException {
        Vector vector = null;
        SecurityToken securityToken = this.session.getSecurityToken();
        String string2 = this.matchFileName(string);
        try {
            vector = this.logFactory.getList(securityToken, n, logFilter, l, string2);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return vector;
    }

    public void clearLog(String string) throws AdminException {
        String string2 = this.matchFileName(string);
        try {
            Object[] objectArray = new Object[]{string2};
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.logFactory.clearLog(securityToken, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
    }

    public String[] listLogFiles() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        try {
            this.serverLogFiles = this.logFactory.listLogFiles(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        this.viewerLogFiles = new String[this.serverLogFiles.length];
        int n = 0;
        while (n < this.serverLogFiles.length) {
            int n2 = this.serverLogFiles[n].indexOf(".");
            long l = Long.parseLong(this.serverLogFiles[n].substring(n2 + 1));
            Date date = new Date(l);
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
            this.viewerLogFiles[n] = "Log_" + simpleDateFormat.format(date) + "_";
            simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(1);
            int n3 = n++;
            this.viewerLogFiles[n3] = String.valueOf(this.viewerLogFiles[n3]) + simpleDateFormat.format(date);
        }
        return this.viewerLogFiles;
    }

    public String getCurrentLogFileName() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        String string = null;
        try {
            string = this.logFactory.getCurrentLogFileName(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        this.listLogFiles();
        int n = string.indexOf(".");
        long l = Long.parseLong(string.substring(n + 1));
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
        String string2 = "Log_" + simpleDateFormat.format(date) + "_";
        simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(1);
        string2 = String.valueOf(string2) + simpleDateFormat.format(date);
        return string2;
    }

    public int getNumLogFiles() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        int n = 0;
        try {
            n = this.logFactory.getNumLogFiles(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return n;
    }

    public int getLogFileSize() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        int n = 0;
        try {
            n = this.logFactory.getLogFileSize(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return n;
    }

    public String getSyslogSwitch() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        String string = null;
        try {
            string = this.logFactory.getSyslogSwitch(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return string;
    }

    public String getLogStorageName() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        String string = null;
        try {
            string = this.logFactory.getLogStorageName(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return string;
    }

    public String getLogFileDir() throws AdminException {
        SecurityToken securityToken = this.session.getSecurityToken();
        String string = null;
        try {
            string = this.logFactory.getLogFileDir(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
        return string;
    }

    public void setProperties(int n, int n2, String string, String string2) throws AdminException {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), string, string2};
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.logFactory.setProperties(securityToken, n, n2, string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new AdminLogException("EXLOG_REMOTE");
        }
    }

    private String matchFileName(String string) {
        int n = 0;
        while (n < this.viewerLogFiles.length) {
            if (string.equalsIgnoreCase(this.viewerLogFiles[n])) {
                return this.serverLogFiles[n];
            }
            ++n;
        }
        return string;
    }
}

