/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.UnsupportedScopeTypeException;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrHelpListener;
import com.sun.admin.fsmgr.client.FsMgrPanel;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.FsMgrTree;
import com.sun.admin.fsmgr.client.apps.Apps;
import com.sun.admin.fsmgr.client.mount.Mount;
import com.sun.admin.fsmgr.client.share.Share;
import com.sun.admin.fsmgr.client.usage.Usage;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FsMgr
extends JPanel
implements AdminClientComponent {
    private static FsMgr fsMgr = null;
    private FsMgrClient fsMgrClient;
    private Apps appsPanel;
    private Share sharePanel;
    private Mount mountPanel;
    private Usage usagePanel;
    private FsMgrPanel currentPanel;
    private String currentId;
    public static final int PROGRESS_WAIT = 1500;
    private FsMgrTree theTree;
    private IClientComm clientComm;
    private ResourceBundle resourceBundle;
    private String[] fsMgrScopeTypes = new String[]{"file"};

    public FsMgr(IClientComm iClientComm) throws Exception {
        fsMgr = this;
        this.clientComm = iClientComm;
        AdminSession adminSession = iClientComm.getAdminSession();
        String string = adminSession.getMgmtScope().getMgmtScopeType();
        boolean bl = false;
        int n = 0;
        while (n < this.fsMgrScopeTypes.length) {
            if (this.fsMgrScopeTypes[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new UnsupportedScopeTypeException(string, "com.sun.admin.fsmgr.client.FsMgr");
        }
        this.resourceBundle = ResourceBundle.getBundle("com.sun.admin.fsmgr.resources.ResourceBundle", Locale.getDefault());
        this.fsMgrClient = FsMgrClient.instance();
        this.fsMgrClient.setUpConnection(iClientComm);
        this.setLayout(new GridBagLayout());
        this.appsPanel = new Apps();
        this.theTree = new FsMgrTree(this.appsPanel.getAppsCache());
        iClientComm.addToTreePanel(this.theTree);
    }

    public void setCurrentPanel(String string) {
        if (this.currentId != null && string.equals(this.currentId)) {
            return;
        }
        if (string.equals(FsMgrTree.MOUNT)) {
            if (this.mountPanel == null) {
                this.mountPanel = new Mount();
            }
            this.currentPanel = this.mountPanel;
            this.currentId = FsMgrTree.MOUNT;
        } else if (string.equals(FsMgrTree.SHARE)) {
            if (this.sharePanel == null) {
                this.sharePanel = new Share();
            }
            this.currentPanel = this.sharePanel;
            this.currentId = FsMgrTree.SHARE;
        } else if (string.equals(FsMgrTree.USAGE)) {
            if (this.usagePanel == null) {
                this.usagePanel = new Usage();
            }
            this.currentPanel = this.usagePanel;
            this.currentId = FsMgrTree.USAGE;
        } else if (string.equals(FsMgrTree.FSMGR)) {
            if (this.appsPanel == null) {
                this.appsPanel = new Apps();
            }
            this.currentPanel = this.appsPanel;
            this.currentId = FsMgrTree.FSMGR;
        } else {
            String string2 = FsMgrResourceStrings.getString("dbg_bad_case");
            AdminCommonTools.CMN_HandleOutput(String.valueOf(string2) + "setCurrentPanel()");
            return;
        }
        this.theTree.setSelectedNode(this.currentId);
        this.removeAll();
        this.setLayout(new GridBagLayout());
        Constraints.constrain(this, this.currentPanel, 0, -1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
        this.currentPanel.update();
    }

    public static FsMgr getFsMgr() {
        return fsMgr;
    }

    public FsMgrClient getFsMgrClient() {
        return this.fsMgrClient;
    }

    public JFrame getFrame() {
        return this.clientComm.getFrame();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public IClientComm getClientComm() {
        return this.clientComm;
    }

    public String getHelpUrlString(String string) {
        return this.clientComm.getHelpUrl("fsmgr", String.valueOf(string) + ".html");
    }

    public void addToHelpPanel(String string) {
        try {
            URL uRL = new URL(this.getHelpUrlString(string));
            this.clientComm.addToHelpPanel(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = FsMgrResourceStrings.getString("err_malformed_URL");
            AdminCommonTools.CMN_HandleOutput(String.valueOf(string2) + " " + malformedURLException);
            return;
        }
    }

    public void addHelpListener(AdminDialog adminDialog, Component component, String string) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(adminDialog, componentArray[n], string);
                ++n;
            }
        }
        component.addFocusListener(new FsMgrHelpListener(adminDialog.getInfoPanel(), string));
    }

    public void appReceivingMainFocus() {
        this.clientComm.addToMainView(this);
    }

    public void appLosingMainFocus() {
        this.theTree.removeSelectionRows(this.theTree.getSelectionRows());
        this.theTree.invalidate();
        this.theTree.validate();
        this.theTree.repaint();
        this.setStatusBar("");
        this.currentId = null;
    }

    public void appCloseDown() {
        try {
            this.fsMgrClient.terminateConnection();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static String getFsMgrImageDirectory() {
        String string = File.separator;
        String string2 = String.valueOf(string) + "fsmgr" + string + "client" + string + "images";
        return string2;
    }

    public void setStatusBar(String string) {
        this.clientComm.addToStatusPanel(string, 0);
    }

    public ImageIcon loadImageIcon(String string, String string2) {
        String string3 = String.valueOf(this.clientComm.getImagePath()) + FsMgr.getFsMgrImageDirectory() + File.separator + string;
        return new ImageIcon(string3, string2);
    }
}

