/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.fsmgr.client.BrowseDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrBooleanOption;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrHelpListener;
import com.sun.admin.fsmgr.client.FsMgrPropsPanel;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;
import com.sun.admin.fsmgr.client.mount.FsMgrMountPropDlg;
import com.sun.admin.fsmgr.client.mount.FsMgrMountPropTab;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMountDataException;
import com.sun.admin.fsmgr.common.FsMgrRemoteFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FsMgrMountPropMntTab
extends FsMgrPropsPanel
implements FsMgrMountPropTab {
    FsMgrMountPropDlg mountDlg;
    FsMgrMountData mountData;
    FsMgrBooleanOption roObject;
    JTextField directoryField;
    JRadioButton roRBtn;
    JRadioButton rwRBtn;
    JPanel resourceGB;
    JPanel mntpntGB;
    JPanel statusGB;
    JPanel accessGB;
    JPanel invisiblePanel;
    private static final String RESOURCE_HELP = new String("fs_ctx_dlg_mountprop_nfs_tab_mount_resourcedir");
    private static final String MOUNTPOINT_HELP = new String("fs_ctx_dlg_mountprop_nfs_tab_mount_mpointdir");
    private static final String MOUNTSTAT_HELP = new String("fs_ctx_dlg_mountprop_nfs_tab_mount_mountstat");
    private static final String READWRITE_HELP = new String("fs_ctx_dlg_mountprop_nfs_tab_mount_readwrite");

    public FsMgrMountPropMntTab(FsMgrMountPropDlg fsMgrMountPropDlg) {
        this.mountDlg = fsMgrMountPropDlg;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.mountData = this.mountDlg.getMountData();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(FsMgrResourceStrings.getString("mount_prop_mnt_resource"));
        this.resourceGB = new JPanel();
        this.resourceGB.setLayout(gridBagLayout);
        this.resourceGB.setBorder(titledBorder);
        Constraints.constrain(this, this.resourceGB, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 10, 10, 10, 10);
        JLabel jLabel = new JLabel(this.mountData.getResource());
        FsMgr.getFsMgr().addHelpListener(this.mountDlg, jLabel, RESOURCE_HELP);
        Constraints.constrain(this.resourceGB, jLabel, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 10, 10, 10, 0);
        titledBorder = BorderFactory.createTitledBorder(FsMgrResourceStrings.getString("mount_prop_mnt_point"));
        this.mntpntGB = new JPanel();
        this.mntpntGB.setLayout(gridBagLayout);
        this.mntpntGB.setBorder(titledBorder);
        Constraints.constrain(this, this.mntpntGB, 0, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 10, 10);
        jLabel = new JLabel(FsMgrResourceStrings.getString("share_wiz_dir"));
        Constraints.constrain(this.mntpntGB, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 10, 10, 10, 5);
        this.directoryField = new JTextField(this.mountData.getMountPoint(), 10);
        this.directoryField.setMinimumSize(this.directoryField.getPreferredSize());
        FsMgr.getFsMgr().addHelpListener(this.mountDlg, this.directoryField, MOUNTPOINT_HELP);
        Constraints.constrain(this.mntpntGB, this.directoryField, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 10, 5, 10, 5);
        JButton jButton = new JButton(FsMgrResourceStrings.getString("browse_button"));
        FsMgr.getFsMgr().addHelpListener(this.mountDlg, jButton, MOUNTPOINT_HELP);
        Constraints.constrain(this.mntpntGB, jButton, 2, 0, 1, 1, 0, 17, 1.0, 0.0, 10, 5, 10, 0);
        jButton.setEnabled(true);
        jButton.addActionListener(new BrowseBtnListener());
        titledBorder = BorderFactory.createTitledBorder(FsMgrResourceStrings.getString("mount_prop_mnt_status"));
        this.statusGB = new JPanel();
        this.statusGB.setLayout(gridBagLayout);
        this.statusGB.setBorder(titledBorder);
        Constraints.constrain(this, this.statusGB, 0, 2, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 10, 10);
        jLabel = new JLabel(this.mountDlg.getStatus());
        FsMgr.getFsMgr().addHelpListener(this.mountDlg, jLabel, MOUNTSTAT_HELP);
        Constraints.constrain(this.statusGB, jLabel, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 10, 10, 10, 0);
        titledBorder = BorderFactory.createTitledBorder(FsMgrResourceStrings.getString("mount_prop_mnt_access"));
        this.accessGB = new JPanel();
        this.accessGB.setLayout(gridBagLayout);
        this.accessGB.setBorder(titledBorder);
        Constraints.constrain(this, this.accessGB, 0, 3, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 10, 10);
        if (!this.mountData.getFsType().equals("hsfs")) {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.rwRBtn = new JRadioButton(FsMgrResourceStrings.getString("read_write"));
            FsMgr.getFsMgr().addHelpListener(this.mountDlg, this.rwRBtn, READWRITE_HELP);
            Constraints.constrain(this.accessGB, this.rwRBtn, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 5, 10, 0, 0);
            buttonGroup.add(this.rwRBtn);
            this.roRBtn = new JRadioButton(FsMgrResourceStrings.getString("read_only"));
            FsMgr.getFsMgr().addHelpListener(this.mountDlg, this.roRBtn, READWRITE_HELP);
            Constraints.constrain(this.accessGB, this.roRBtn, 0, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 10, 0);
            buttonGroup.add(this.roRBtn);
        } else {
            jLabel = new JLabel(FsMgrResourceStrings.getString("read_only"));
            FsMgr.getFsMgr().addHelpListener(this.mountDlg, jLabel, READWRITE_HELP);
            Constraints.constrain(this.accessGB, jLabel, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 10, 10, 10, 0);
        }
        this.invisiblePanel = new JPanel();
        Constraints.constrain(this, this.invisiblePanel, 0, 4, 1, 1, 1, 17, 1.0, 1.0, 0, 10, 10, 10);
        this.setOptions();
        if (this.mountData.getFsType().equals("nfs")) {
            this.focusListener = new FsMgrHelpListener(fsMgrMountPropDlg.getInfoPanel(), "fs_ctx_dlg_mountprop_nfs_tab_mount");
            return;
        }
        if (this.mountData.getFsType().equals("ufs")) {
            this.focusListener = new FsMgrHelpListener(fsMgrMountPropDlg.getInfoPanel(), "fs_ctx_dlg_mountprop_ufs_tab_mount");
            return;
        }
        if (this.mountData.getFsType().equals("hsfs")) {
            this.focusListener = new FsMgrHelpListener(fsMgrMountPropDlg.getInfoPanel(), "fs_ctx_dlg_mountprop_hsfs_tab_mount");
        }
    }

    public void setOptions() {
        if (!this.mountData.getFsType().equals("hsfs")) {
            this.roObject = (FsMgrBooleanOption)this.mountData.getOption(FsMgrMountData.RO);
            if (this.roObject == null || this.roObject != null && !this.roObject.getValue()) {
                this.rwRBtn.doClick();
                return;
            }
            this.roRBtn.doClick();
        }
    }

    public void updateMountData() throws FsMgrException {
        FsMgrClient fsMgrClient = FsMgrClient.instance();
        FsMgrRemoteFile fsMgrRemoteFile = null;
        this.mountData = this.mountDlg.getMountData();
        try {
            fsMgrRemoteFile = fsMgrClient.getFile(this.directoryField.getText());
        }
        catch (FsMgrException fsMgrException) {
            new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
        }
        if (fsMgrRemoteFile == null) {
            throw new FsMgrException(FsMgrResourceStrings.getString("share_wiz_dir_err1"));
        }
        if (!this.directoryField.getText().equals(this.mountData.getMountPoint())) {
            this.mountData.setMountPoint(this.directoryField.getText());
        }
        if (!this.mountData.getFsType().equals(FsMgrMountData.HSFS)) {
            if (this.roRBtn.isSelected()) {
                try {
                    this.mountData.setOption(FsMgrMountData.RO, true);
                }
                catch (FsMgrMountDataException fsMgrMountDataException) {
                    AdminCommonTools.CMN_HandleOutput("FsMgrMountDataException: mountData.setOption(RO, true)");
                }
            } else {
                try {
                    this.mountData.setOption(FsMgrMountData.RO, false);
                }
                catch (FsMgrMountDataException fsMgrMountDataException) {
                    AdminCommonTools.CMN_HandleOutput("FsMgrMountDataException: mountData.setOption(RO, false)");
                }
            }
        }
        this.mountDlg.setMountData(this.mountData);
    }

    class BrowseBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BrowseDialog browseDialog = new BrowseDialog(FsMgrResourceStrings.getString("browse_title"), FsMgrMountPropMntTab.this.directoryField);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)browseDialog).setLocation(dimension.width / 2 - browseDialog.getSize().width / 2, dimension.height / 2 - browseDialog.getSize().height / 2);
            ((Component)browseDialog).setVisible(true);
        }

        BrowseBtnListener() {
            FsMgrMountPropMntTab.this = FsMgrMountPropMntTab.this;
        }
    }
}

