/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.FileTableDefinitions;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.server.FsMgrFactoryImpl;
import com.sun.admin.fsmgr.server.FsMgrMountInterface;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class FsMgrMountTable
implements FsMgrMountInterface {
    public static final String MOUNTTAB = new String("mounttab");
    private static String resource = new String("resource");
    private static String fsckDevice = new String("fsckDevice");
    private static String mountPoint = new String("mountPoint");
    private static String fsType = new String("fsType");
    private static String fsckPass = new String("fsckPass");
    private static String bootMount = new String("bootMount");
    private static String options = new String("options");
    private int resourceColumn;
    private int fsckDeviceColumn;
    private int mountPointColumn;
    private int fsTypeColumn;
    private int fsckPassColumn;
    private int bootMountColumn;
    private int optionsColumn;
    private static final String umountCommand = new String("/usr/sbin/umount");
    private static final String mountCommand = new String("/usr/sbin/mount");
    private static final String mountOption = new String("-p");
    private static final String fileType = new String("File");
    private static final String FSM = new String("FSM");
    private static final String emptyString = new String("");
    private FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
    private File tempFile;
    private FsMgrFactoryImpl factoryImpl;

    public FsMgrMountTable(FsMgrFactoryImpl fsMgrFactoryImpl) throws DirectoryTableException {
        this.factoryImpl = fsMgrFactoryImpl;
        this.fileTableDefinitions.loadTableDefinitions(MOUNTTAB);
        this.resourceColumn = this.fileTableDefinitions.getColumnNumber(resource);
        this.fsckDeviceColumn = this.fileTableDefinitions.getColumnNumber(fsckDevice);
        this.mountPointColumn = this.fileTableDefinitions.getColumnNumber(mountPoint);
        this.fsTypeColumn = this.fileTableDefinitions.getColumnNumber(fsType);
        this.fsckPassColumn = this.fileTableDefinitions.getColumnNumber(fsckPass);
        this.bootMountColumn = this.fileTableDefinitions.getColumnNumber(bootMount);
        this.optionsColumn = this.fileTableDefinitions.getColumnNumber(options);
    }

    public Vector list() throws DirectoryTableException, FsMgrException {
        Vector<FsMgrMount> vector = new Vector<FsMgrMount>();
        DirectoryTable directoryTable = this.openMountTable();
        DirectoryRow directoryRow = directoryTable.getFirstRow();
        try {
            while (directoryRow != null) {
                FsMgrMount fsMgrMount = this.parseMountEntry(directoryRow);
                vector.addElement(fsMgrMount);
                directoryRow = directoryTable.getNextRow();
            }
            this.closeMountTable(directoryTable);
        }
        catch (DirectoryTableException directoryTableException) {
            this.closeMountTable(directoryTable);
            throw directoryTableException;
        }
        return vector;
    }

    public FsMgrMount getMountEntry(String string, String string2) throws DirectoryTableException, FsMgrException {
        DirectoryTable directoryTable = this.openMountTable();
        DirectoryRow directoryRow = null;
        FsMgrMount fsMgrMount = null;
        try {
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrMount = this.parseMountEntry(directoryRow);
                if (fsMgrMount != null) {
                    if (string.equals(fsMgrMount.getResource()) && string2.equals(fsMgrMount.getMountPoint())) break;
                    fsMgrMount = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            this.closeMountTable(directoryTable);
        }
        catch (DirectoryTableException directoryTableException) {
            this.closeMountTable(directoryTable);
            throw directoryTableException;
        }
        return fsMgrMount;
    }

    public void addMount(FsMgrMount fsMgrMount, SecurityToken securityToken) throws FsMgrException {
        Vector vector;
        String[] stringArray;
        String string = this.factoryImpl.getAdminSvr().getHostName();
        String string2 = fsMgrMount.getMountPoint();
        String string3 = fsMgrMount.getResource();
        String string4 = "";
        String string5 = "";
        long l = securityToken.getSecurityId().getValue();
        try {
            if (AdminServerLibrary.auditOn()) {
                try {
                    string4 = this.factoryImpl.getAdminSvr().getUserName(securityToken);
                    string5 = this.factoryImpl.getAdminSvr().getClientHost(securityToken);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        if ((stringArray = (String[])(vector = AdminCommonTools.CMN_exec(fsMgrMount.toArray(), true)).elementAt(1)).length != 0) {
            try {
                AdminServerLibrary.auditMount(string, string2, -1, string4, string5, l);
            }
            catch (Exception exception) {}
            this.factoryImpl.writeLog(2, "LM_4064", "LM_4099", stringArray[0], null, null, null);
            int n = stringArray[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_MOUNT_ERROR", string3, string2, stringArray[0].substring(n));
        }
        try {
            AdminServerLibrary.auditMount(string, string2, 0, string4, string5, l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void removeMount(FsMgrMount fsMgrMount, SecurityToken securityToken) throws FsMgrException {
        String[] stringArray;
        Vector vector;
        String[] stringArray2;
        String string = this.factoryImpl.getAdminSvr().getHostName();
        String string2 = fsMgrMount.getMountPoint();
        String string3 = "";
        String string4 = "";
        long l = securityToken.getSecurityId().getValue();
        try {
            if (AdminServerLibrary.auditOn()) {
                try {
                    string3 = this.factoryImpl.getAdminSvr().getUserName(securityToken);
                    string4 = this.factoryImpl.getAdminSvr().getClientHost(securityToken);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        if ((stringArray2 = (String[])(vector = AdminCommonTools.CMN_exec(stringArray = new String[]{umountCommand, string2}, true)).elementAt(1)).length != 0) {
            this.factoryImpl.writeLog(2, "LM_4065", "LM_4099", stringArray2[0], null, null, null);
            int n = stringArray2[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_UMOUNT_ERROR", string2, stringArray2[0].substring(n));
        }
        try {
            AdminServerLibrary.auditUMount(string, string2, string3, string4, l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void modifyMount(FsMgrMount fsMgrMount, FsMgrMount fsMgrMount2, SecurityToken securityToken) throws FsMgrException {
        this.removeMount(fsMgrMount, securityToken);
        try {
            this.addMount(fsMgrMount2, securityToken);
            return;
        }
        catch (FsMgrException fsMgrException) {
            this.addMount(fsMgrMount, securityToken);
            throw fsMgrException;
        }
    }

    private DirectoryTable openMountTable() throws DirectoryTableException, FsMgrException {
        String[] stringArray = new String[]{mountCommand, mountOption};
        Vector vector = AdminCommonTools.CMN_exec(stringArray, true);
        String[] stringArray2 = (String[])vector.elementAt(0);
        String[] stringArray3 = (String[])vector.elementAt(1);
        if (stringArray3.length != 0) {
            this.factoryImpl.writeLog(2, "LM_4068", "LM_4099", stringArray3[0], null, null, null);
            throw new FsMgrException(stringArray3[0]);
        }
        try {
            this.tempFile = AdminCommonTools.CMN_CreateTempFile(FSM);
            if (stringArray2.length != 0) {
                AdminCommonTools.CMN_WriteArray(this.tempFile, stringArray2);
            }
        }
        catch (IOException iOException) {
            this.factoryImpl.writeLog(2, "LM_4062", "LM_4063", this.tempFile.getAbsolutePath(), null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        String string = this.tempFile.getAbsolutePath();
        this.fileTableDefinitions.setMappedTableName(string);
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(fileType, emptyString, emptyString);
        directoryTable.open(this.fileTableDefinitions);
        return directoryTable;
    }

    private void closeMountTable(DirectoryTable directoryTable) throws DirectoryTableException {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        directoryTable.close();
    }

    private FsMgrMount parseMountEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.resourceColumn);
        String string2 = directoryRow.getColumn(this.fsckDeviceColumn);
        String string3 = directoryRow.getColumn(this.mountPointColumn);
        String string4 = directoryRow.getColumn(this.fsTypeColumn);
        String string5 = directoryRow.getColumn(this.fsckPassColumn);
        String string6 = directoryRow.getColumn(this.bootMountColumn);
        String string7 = directoryRow.getColumn(this.optionsColumn);
        string7 = this.optionsFixup(string7);
        FsMgrMount fsMgrMount = new FsMgrMount(string, string2, string3, string4, string5, string6, string7);
        return fsMgrMount;
    }

    public String optionsFixup(String string) {
        String string2;
        if (string == null) {
            return string;
        }
        if (string.startsWith("dev=")) {
            int n = string.indexOf(",");
            string2 = n == -1 ? new String("") : string.substring(n + 1);
        } else {
            int n = string.indexOf(",dev=");
            if (n == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n);
                ++n;
                if ((n = string.indexOf(44, n)) != -1) {
                    string2 = string2.concat(string.substring(n));
                }
            }
        }
        return string2;
    }
}

