/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FindDialog;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AdminAddGroupDialog;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminUserIconPane;
import com.sun.admin.usermgr.client.AdminUserTable;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.ConfActionListener;
import com.sun.admin.usermgr.client.ConfDelGroupPanel;
import com.sun.admin.usermgr.client.FilterObj;
import com.sun.admin.usermgr.client.FindNextActionListener;
import com.sun.admin.usermgr.client.FindObj;
import com.sun.admin.usermgr.client.IChangeView;
import com.sun.admin.usermgr.client.IEnableState;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class UMgrGroupTBar
extends JPanel
implements IEnableState,
IChangeView {
    private JButton deleteBtn;
    private JButton refreshBtn;
    private JButton findBtn;
    private JButton filterBtn;
    private JButton addGroupBtn;
    private JButton iconViewBtn;
    private JButton detailViewBtn;
    private JButton pasteBtn;
    private ImageIcon detailOpen;
    private ImageIcon detailClose;
    private ImageIcon iconViewOpen;
    private ImageIcon iconViewClose;
    private Border defaultBorder;
    private Border bevelBorder = BorderFactory.createBevelBorder(1);
    AdminAddGroupDialog adminAddGroupDialog;

    public void setEnableState() {
        try {
            Vector vector = UserMgrClient.instance().getUserRights();
            if (vector.contains("solaris.admin.usermgr.write")) {
                if (AdminViews.instance().getSelectedNodeNames().size() == 0) {
                    this.deleteBtn.setEnabled(false);
                    this.pasteBtn.setEnabled(false);
                    return;
                }
                this.deleteBtn.setEnabled(true);
                this.pasteBtn.setEnabled(true);
                return;
            }
            this.deleteBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
            this.addGroupBtn.setEnabled(false);
            return;
        }
        catch (Exception exception) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
            return;
        }
    }

    public void changeViewState() {
        if (AdminMainPanel.sharedInstance().getActiveComponent() instanceof AdminUserIconPane) {
            this.iconViewBtn.setBorder(this.bevelBorder);
            this.detailViewBtn.setBorder(this.defaultBorder);
            this.invalidate();
            this.validate();
            this.repaint();
        }
        if (AdminMainPanel.sharedInstance().getActiveComponent() instanceof AdminUserTable) {
            this.iconViewBtn.setBorder(this.defaultBorder);
            this.detailViewBtn.setBorder(this.bevelBorder);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    private void setUpButton(JButton jButton, String string) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new TBarBtnListener());
    }

    public UMgrGroupTBar() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addGroupBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("add_group_icon_temp.gif", "Add Group"));
        this.setUpButton(this.addGroupBtn, UMgrResourceStrings.getString("tbar_addgroup"));
        this.defaultBorder = this.addGroupBtn.getBorder();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.addGroupBtn, gridBagConstraints, -1);
        this.findBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_find.gif", "Find"));
        this.setUpButton(this.findBtn, UMgrResourceStrings.getString("tbar_find"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.add(this.findBtn, gridBagConstraints, -1);
        this.filterBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_filter.gif", "Filter"));
        this.setUpButton(this.filterBtn, UMgrResourceStrings.getString("tbar_filter"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.filterBtn, gridBagConstraints, -1);
        this.pasteBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("paste_temp.gif", "Paste"));
        this.setUpButton(this.pasteBtn, UMgrResourceStrings.getString("tbar_grouppaste"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 3;
        this.add(this.pasteBtn, gridBagConstraints, -1);
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.pasteBtn.addActionListener(new PasteListener());
        this.deleteBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_delete.gif", "Delete"));
        this.setUpButton(this.deleteBtn, UMgrResourceStrings.getString("warning_delete"));
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.deleteBtn, gridBagConstraints, -1);
        this.iconViewOpen = AdminMainPanel.sharedInstance().createImageIcon("toolbar_large_icons_enabled.gif", "IconViewOpen");
        this.iconViewBtn = new JButton(this.iconViewOpen);
        this.setUpButton(this.iconViewBtn, UMgrResourceStrings.getString("tbar_largeicons"));
        this.iconViewBtn.setBorder(this.bevelBorder);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.add(this.iconViewBtn, gridBagConstraints, -1);
        this.detailOpen = AdminMainPanel.sharedInstance().createImageIcon("toolbar_details_enabled.gif", "DetailOpen");
        this.detailViewBtn = new JButton(this.detailOpen);
        this.setUpButton(this.detailViewBtn, UMgrResourceStrings.getString("tbar_details"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.detailViewBtn, gridBagConstraints, -1);
        this.refreshBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_refresh_enabled.gif", "Refresh"));
        this.setUpButton(this.refreshBtn, UMgrResourceStrings.getString("tbar_refresh"));
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.add(this.refreshBtn, gridBagConstraints, -1);
    }

    class TBarBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JButton jButton = (JButton)actionEvent.getSource();
                ImageIcon imageIcon = (ImageIcon)jButton.getIcon();
                String string = imageIcon.getDescription();
                if (string.compareTo("Add Group") == 0) {
                    JFrame jFrame = AdminMainPanel.sharedInstance().jFrame;
                    UMgrGroupTBar.this.adminAddGroupDialog = new AdminAddGroupDialog(jFrame);
                    ((Component)UMgrGroupTBar.this.adminAddGroupDialog).setVisible(true);
                    return;
                }
                if (string.compareTo("Find") == 0) {
                    FindObj findObj = FindObj.instance();
                    FindDialog findDialog = new FindDialog((Frame)AdminMainPanel.sharedInstance().jFrame, findObj.getSearchString());
                    findDialog.addFindNextListener(new FindNextActionListener());
                    ((Component)findDialog).setVisible(true);
                    return;
                }
                if (string.equals("Filter")) {
                    new FilterObj(UMgrResourceStrings.getString("groups"), false);
                    return;
                }
                if (string.compareTo("Delete") == 0) {
                    JPanel jPanel = new JPanel();
                    String string2 = new String(UMgrResourceStrings.getString("warning"));
                    if (AdminViews.instance().getCurrentViewName().equals(UMgrResourceStrings.getString("groups"))) {
                        jPanel = new ConfDelGroupPanel();
                        string2 = UMgrResourceStrings.getString("warning_group");
                    } else {
                        new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, "Not in supported view");
                    }
                    new WarningDialog(AdminMainPanel.sharedInstance().jFrame, string2, jPanel, (ActionListener)new ConfActionListener(), UMgrResourceStrings.getString("warning_delete"));
                    return;
                }
                if (string.compareTo("DetailOpen") == 0) {
                    if (jButton.getBorder() != UMgrGroupTBar.this.bevelBorder) {
                        AdminMainPanel.sharedInstance().switchToDetailPanel();
                        return;
                    }
                } else if (string.compareTo("IconViewOpen") == 0) {
                    if (jButton.getBorder() != UMgrGroupTBar.this.bevelBorder) {
                        AdminMainPanel.sharedInstance().switchToIconPanel();
                        return;
                    }
                } else {
                    if (string.compareTo("Refresh") == 0) {
                        AdminViews.instance().refreshAllViews();
                        return;
                    }
                    AdminCommonTools.CMN_HandleOutput("Button not handled");
                }
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack(1, exception);
                return;
            }
        }

        TBarBtnListener() {
            UMgrGroupTBar.this = UMgrGroupTBar.this;
        }
    }

    class PasteListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)AdminViews.instance().getSelectedNodeNames().lastElement();
            if (string.equals(null)) {
                return;
            }
            GroupObj groupObj = null;
            groupObj = AdminViews.instance().getGroupObjFromName(string);
            if (groupObj == null) {
                return;
            }
            Transferable transferable = AdminViews.instance().getClipBoard().getContents(this);
            String string2 = null;
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    AdminCommonTools.CMN_TraceStack(1, exception);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                int n = stringTokenizer.countTokens();
                String[] stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    String string3;
                    if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()) != "") {
                        AdminCommonTools.CMN_HandleOutput("Token = " + string3);
                        AdminCommonTools.CMN_HandleOutput("Token count = " + n2);
                        stringArray[n2] = string3;
                    }
                    ++n2;
                }
                UserMgrClient.instance().addUsersToGroup(groupObj, stringArray);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    AdminCommonTools.CMN_HandleOutput("Array value " + n3 + "=" + stringArray[n3]);
                    ++n3;
                }
            }
        }

        PasteListener() {
            UMgrGroupTBar.this = UMgrGroupTBar.this;
        }
    }

    class BtnMouseListener
    extends MouseAdapter {
        JButton jb;

        public void mouseEntered(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            if (this.jb.isEnabled()) {
                this.jb.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            this.jb.setBorderPainted(false);
        }

        BtnMouseListener() {
            UMgrGroupTBar.this = UMgrGroupTBar.this;
        }
    }
}

