/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminUserIconPane;
import com.sun.admin.usermgr.client.AdminUserTable;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.IChangeView;
import com.sun.admin.usermgr.client.IEnableState;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class UMgrRootTBar
extends JPanel
implements IEnableState,
IChangeView {
    private JButton refreshBtn;
    private JButton iconViewBtn;
    private JButton detailViewBtn;
    private ImageIcon detailOpen;
    private ImageIcon detailClose;
    private ImageIcon iconViewOpen;
    private ImageIcon iconViewClose;
    private Border defaultBorder;
    private Border bevelBorder = BorderFactory.createBevelBorder(1);

    public void setEnableState() {
        AdminViews adminViews = AdminViews.instance();
        adminViews.getSelectedNodeNames().size();
    }

    public void changeViewState() {
        if (AdminMainPanel.sharedInstance().getActiveComponent() instanceof AdminUserIconPane) {
            this.iconViewBtn.setBorder(this.bevelBorder);
            this.detailViewBtn.setBorder(this.defaultBorder);
            this.invalidate();
            this.validate();
            this.repaint();
        }
        if (AdminMainPanel.sharedInstance().getActiveComponent() instanceof AdminUserTable) {
            this.iconViewBtn.setBorder(this.defaultBorder);
            this.detailViewBtn.setBorder(this.bevelBorder);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    private void setUpButton(JButton jButton, String string) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new TBarBtnListener());
    }

    public UMgrRootTBar() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.iconViewOpen = AdminMainPanel.sharedInstance().createImageIcon("toolbar_large_icons_enabled.gif", "IconViewOpen");
        this.iconViewBtn = new JButton(this.iconViewOpen);
        this.setUpButton(this.iconViewBtn, UMgrResourceStrings.getString("tbar_largeicons"));
        this.defaultBorder = this.iconViewBtn.getBorder();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.iconViewBtn, gridBagConstraints, -1);
        this.detailOpen = AdminMainPanel.sharedInstance().createImageIcon("toolbar_details_enabled.gif", "DetailOpen");
        this.detailViewBtn = new JButton(this.detailOpen);
        this.setUpButton(this.detailViewBtn, UMgrResourceStrings.getString("tbar_details"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.detailViewBtn, gridBagConstraints, -1);
    }

    class TBarBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JButton jButton = (JButton)actionEvent.getSource();
                ImageIcon imageIcon = (ImageIcon)jButton.getIcon();
                String string = imageIcon.getDescription();
                AdminCommonTools.CMN_HandleOutput("AdminToolBar:TbarBtnListnener, iconTxt= " + string);
                if (string.equals("DetailOpen")) {
                    AdminMainPanel.sharedInstance().switchToDetailPanel();
                    return;
                }
                if (string.equals("IconViewOpen")) {
                    AdminMainPanel.sharedInstance().switchToIconPanel();
                    return;
                }
                AdminCommonTools.CMN_HandleOutput("Button not handled");
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack(1, exception);
                return;
            }
        }

        TBarBtnListener() {
            UMgrRootTBar.this = UMgrRootTBar.this;
        }
    }

    class BtnMouseListener
    extends MouseAdapter {
        JButton jb;

        public void mouseEntered(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            if (this.jb.isEnabled()) {
                this.jb.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            this.jb.setBorderPainted(false);
        }

        BtnMouseListener() {
            UMgrRootTBar.this = UMgrRootTBar.this;
        }
    }
}

