#pragma ident  "@(#)atmioctl.h 1.92     04/05/07 SMI"

/*
 * Copyright (c) 1994 by Sun Microsystems, Inc.
 * Sun Proprietary / Confidential
 */

#ifndef _ATM_ATMIOCTL_H
#define	_ATM_ATMIOCTL_H

#include	<sys/ethernet.h>
#include	<atm/types.h>

#define	ATMIOC		('A' << 8)

#define	A_ALLOCBW	(ATMIOC|1)	/* alloc bandwidth */
#define	A_RELSEBW	(ATMIOC|2)	/* release bandwidth */
#define	A_ADDVC		(ATMIOC|3)	/* add receive channel */
#define	A_MODVC		(ATMIOC|4)	/* mod receive channel */
#define	A_DELVC		(ATMIOC|5)	/* del receive channel */
/*
 * A_ALLOCBW_VC (ATMIOC|6) and A_RELSEBW_VC (ATMIOC|7) are no longer supported.
 * ALLOCBW should be used on a seperate stream for each class of service
 * desired.
 */

/* MIB command */
#define	A_PortEntry21	(ATMIOC|10)
#define	A_LayerEntry21	(ATMIOC|11)
#define	A_StatsEntry21	(ATMIOC|12)
#define	A_PortEntry	(ATMIOC|13)
#define	A_LayerEntry	(ATMIOC|14)
#define	A_StatsEntry	(ATMIOC|15)

#define	A_GET_IPKTS	(ATMIOC|20)	/* get ipackets of the vc */
#define	A_GET_OPKTS	(ATMIOC|21)	/* get opackets of the vc */
#define	A_GET_DEV_COUNT	(ATMIOC|22)	/* get no. of devices in the system */
#define	A_GET_DEV_LIST	(ATMIOC|23)	/* get list of devices in the system */
#define	A_GET_MAC_ADDR	(ATMIOC|24)	/* get mac address */
#define	A_GET_MAX_MAC	(ATMIOC|25)	/* get atm_max_mac property */

/*
 * The following two ioctls were deprecated from SunATM 1.0 and replaced
 * with the SET_LINK_BW and GET_LINK_BW ioctls. Do not reuse these ioctl
 * numbers for something else, SunATM 1.0 interprets them as SET_IDLE etc.
 * #define	A_SET_IDLE_BW	(ATMIOC|25)
 * #define	A_GET_IDLE_BW	(ATMIOC|26)
 */

#define	A_GET_BWG_TABLE	(ATMIOC|27)	/* get bandwidth table */
#define	A_SET_LINK_BW	(ATMIOC|28)	/* set link rate */
#define	A_GET_LINK_BW	(ATMIOC|29)	/* get link rate */
#define	A_SET_LINK_BW_K (ATMIOC|32)
#define	A_GET_LINK_BW_K (ATMIOC|33)

#define	A_ALLOCBW_CBR	(ATMIOC|40)	/* "New" ALLOCBW, in 64 Kbps units */
#define	A_ALLOCBW_VBR	(ATMIOC|41)
#define	A_ALLOCBW_ABR	(ATMIOC|42)

#define	A_DUMP_STAT	(ATMIOC|100)	/* Debugging information */
#define	A_VC_ON		(ATMIOC|101)
#define	A_VC_OFF	(ATMIOC|102)

/*
 * There were used very early in the ATM development project, before
 * signalling was done (actually while Q.2931 was just a gleam in the
 * committee's eye). Don't re-use these ioctl numbers.
 *
 * #define	A_VC_ALLON	(ATMIOC|103)
 * #define	A_VC_ALLOFF	(ATMIOC|104)
 */

#define	A_DUMP_VCS	(ATMIOC|108)
#define	A_DUMP_SLC	(ATMIOC|109)

/*
 * Don't re-use these ioctl numbers. They were for a user-level
 * fault-tolerance app which never panned out.
 *
 * #define	A_ENABLE_TX		(ATMIOC|112)
 * #define	A_ENABLE_RX		(ATMIOC|113)
 * #define	A_DISABLE_TX	(ATMIOC|114)
 * #define	A_DISABLE_RX	(ATMIOC|115)
 */

/*
 * Request addvc/delvc information from driver to implement SNMP traps.
 * If no longer interested in this info close the stream, the driver
 * will figure you died and clean up its internal structures.
 */
#define	A_SNMPTRAP	(ATMIOC|116)

/*
 * Ask driver to walk the dev_info tree and find all ATM devices present.
 */
#define	A_GET_UNITS	(ATMIOC|118)

#define	A_SET_PHY_MODE	(ATMIOC|119)
#define	A_GET_PHY_MODE	(ATMIOC|120)

#define	A_PROMISCON_REQ	(ATMIOC|121)
#define	A_PROMISCOFF_REQ	(ATMIOC|122)

#define	A_GET_LOOP_MODE	(ATMIOC|123)
#define	A_SET_LOOP_MODE	(ATMIOC|124)

#define	A_SET_MARS_CMI	(ATMIOC|125)	/* Set a MARS CMI */
#define	A_GET_MARS_CMI	(ATMIOC|126)	/* Set a MARS CMI */

/* Get the number of ip streams bound to the device */
#define	A_GET_IPSTR_COUNT	(ATMIOC|127)


/* Flags for A_GET_MAC_ADDR */
#define	ATMMACADDR		0	/* get board addr if present, else get system addr */
#define	ATMSYSTEMADDR	1	/* get the system mac address */
#define	ATMBOARDADDR	2	/* get the card mac address */

typedef struct {
	int	bw;
} a_allocbw_t;

typedef a_allocbw_t a_allocbw_cbr_t;

typedef struct {
	int	peak_bw;
	int	avg_bw;
	int	max_burst;
	int	priority;
} a_allocbw_vbr_t;

#define	AVBR_HIGH_PRI	1
#define	AVBR_LO_PRI	2

typedef struct {
	vci_t	vp_vc;
	int	aal_type;
	int	encap;
	int	buf_type;	/* if aal_type is AAL5:			  */
					/*   0 and 1 -> 9K, 2 -> 64K	  */
					/* if null AAL -> number of cells */
} a_addVC_t;

/* aal_type */
#define	AAL0	0
#define	AAL3	3	/* AAL3/4, not fully supported */
#define	AAL4	4	/* AAL3/4, not fully supported */
#define	AAL5	5

/* buf_type for AAL5 */
#define	SMALL_BUF_TYPE	0	/* 9K */
#define	BIG_BUF_TYPE	1	/* 9K */
#define	HUGE_BUF_TYPE	2	/* 64K */

#define	NULL_ENCAP	0	/* no encapsulation */
#define	LLC_ENCAP	1	/* LLC (8 byte) encapsualtion */
#define	NLPID_ENCAP	2	/* NLPID encapsulation - not fully supported */
#define	MARS_ENCAP	3	/* MARS (12 byte) encapsulation, rfc2022 */

typedef a_addVC_t	a_modVC_t;

typedef struct {
	vci_t	vp_vc;
} a_delVC_t;

typedef	struct {
	int	type;
	struct	ether_addr etheraddr;
} a_get_mac_t;

typedef struct {
	int	buf_size;
	int	bwgt_size;
} a_get_bwgtable_hdr_t;

typedef struct {
	a_get_bwgtable_hdr_t	hdr;
	unsigned char		buf;
} a_get_bwgtable_t;

typedef	struct {
	int	intrs;
	int	inits;
	int	ipackets;
	int	opackets;
	int	ierrors;
	int	oerrors;
	int	rx_reset;
	int	tx_reset;
	int	rx_miss_cells;
	int	tx_miss_cells;
	int	outofrbuf;
	int	outoftbuf;
	int	small_buf_cnt;
	int	big_buf_cnt;
	int	nocanput;
	int	flowctl;
	int	copy_receive;
	int	cross_page;
	int	allocbfail;
	int	toomanybytes;
	int	rxoverflow;
	int	outoftxd;
	int	badcrc;
	int	vc_noreceiver;
	int	bufdrop;
	int	errencaps;
	int	sbus_error_ack;
	int	vci0;
	int	hcs_err;
	int	fifo_depth;
	int	ipdisvc;
} a_sa_counters_t;

/* For SunATM 1.0 source compatibility */
typedef a_sa_counters_t a_counters_t;

typedef	int	atm_time32_t;

typedef struct atm_timespec32 {
    atm_time32_t	tv_sec;		/* seconds */
    int				tv_nsec;	/* and nanoseconds */
} atm_timespec32_t;

typedef struct atm_timespec32 atm_timestruc32_t;

typedef	struct {
	int	vers;
	atm_timestruc32_t	tim;
	int	intrs;
	int	inits;
	int	ipackets;
	int	opackets;
	int	ierrors;
	int	oerrors;
	int	outofrbuf;
	int	outoftbuf;
	int	nocanput;
	int	flowctl;
	int	copy_receive;
	int	allocbfail;
	int	toomanybytes;
	int	rxoverflow;
	int	outoftxd;
	int	badcrc;
	int	vc_noreceiver;
	int	badack;
	int	errencaps;
	int	error_ack;
	int	hcs_err;
	int	txc_ovf;
	int	rxmemnotav;
	int	rxstatnotav;
	int	badcells;
	int	flush;
	int	dirty;
	int	rxuldrace;
	int	rxsbufnum;
	int	rxbbufnum;
	int	txdmafail;
	int	ipdisvc;
	int	amccreset;
	int	badber;
	int	rxhngwk;
	int	txhngwk;
	int	rinits;
	int	boguslen;
	int	targkicks;
	int	pfifofull;
	int	pfifoused;
	int	pcidtrto;
} a_ba_counters_t;

#define	BACOUNT_MAGIC	0xD0BAD000
#define	BACOUNT_VERS_MASK	0x000000ff
#define	BACOUNT_VERS	1

typedef struct {
	int		index;
	unsigned int	ipackets;
	unsigned int	opackets;
	unsigned int	sl_sap;
	int		bw;
	unsigned short	buf_size;
	unsigned char	aal_type;
	unsigned char	encap;
	signed short	bwg;
} a_dumpvcs_t;


typedef struct {
	uint	reset_id;
	uint	master_cfg;
	uint	interrupts;
	uint	clock_monitor;
	uint	master_ctrl;
	uint	rsop_int_enab;
	uint	resp_int_stat;
	uint	line_bip8_1;
	uint	line_bip8_2;
	uint	tsop_ctrl;
	uint	tsop_diag;
	uint	rlop_stat;
	uint	rlop_int_enab;
	uint	bit24_1;
	uint	bit24_2;
	uint	bit24_3;
	uint	line_febe_1;
	uint	line_febe_2;
	uint	line_febe_3;
	uint	tlop_ctrl;
	uint	tlop_diag;
	uint	rpop_stat;
	uint	rpop_int_stat;
	uint	rpop_int_enab;
	uint	rx_c2;
	uint	path_bip8_1;
	uint	path_bip8_2;
	uint	path_febe_1;
	uint	path_febe_2;
	uint	tpop_ctrl;
	uint	tpop_pntr;
	uint	tpop_src;
	uint	arb_ptr_1;
	uint	arb_ptr_2;
	uint	tx_c2;
	uint	tpop_path_stat;
	uint	racp_stat;
	uint	racp_int_enab;
	uint	hdr_patten;
	uint	hdr_mask;
	uint	corr_hcs_errs;
	uint	uncorr_hcs_errs;
	uint	tacp_stat;
	uint	idle_hdr_ptrn;
	uint	idle_pay_ptrn;
	uint	suni_test;
} atm_suni155_t;

typedef struct {
	uint	plpp_cfg;
	uint	plpp_int_enab;
	uint	plpp_int_stat;
	uint	plpp_ctrl;
	uint	plpp_master_reset;
	uint	rboc_cfg;
	uint	rboc_int_stat;
	uint	frmr_cfg;
	uint	frmr_int_enab;
	uint	frmr_int_stat;
	uint	frmr_stat;
	uint	rfdl_cfg;
	uint	rfdl_enab;
	uint	rfdl_stat;
	uint	rfdl_data;
	uint	pmon_para;
	uint	pmon_int;
	uint	pmon_line;
	uint	pmon_fram;
	uint	pmon_sum;
	uint	pmon_parity;
	uint	pmon_cbit_parity;
	uint	pmon_febe_count;
	uint	tran_cfg;
	uint	tran_diag;
	uint	xfdl_cfg;
	uint	xfdl_int_stat;
	uint	xfdl_tx_data;
	uint	xboc_code;
	uint	splr_cfg;
	uint	splr_int_enab;
	uint	splr_int_stat;
	uint	splr_stat;
	uint	splt_cfg;
	uint	splt_ctrl;
	uint	splt_diag;
	uint	splt_f1_oct;
	uint	cppm_clock;
	uint	cppm_perf;
	uint	cppm_bip8;
	uint	cppm_frame_err;
	uint	cppm_febe_count;
	uint	cppm_febe_hcs_err;
	uint	cppm_febe_rx_count;
	uint	cppm_febe_tx_count;
	uint	rxcp_ctrl;
	uint	rxcp_fram_ctrl;
	uint	rxcp_int_stat;
	uint	txcp_ctrl;
	uint	txcp_int_stat;
	uint	txcp_h1;
	uint	txcp_h2;
	uint	txcp_h3;
	uint	txcp_h4;
	uint	txcp_h5;
	uint	txcp_par_load;
} atm_ds3_t;

typedef	struct	{
	uint	phy_type;
	union {
		atm_suni155_t	sonet;
		atm_ds3_t	ds3;
	} phy;
} a_registers_t;

/* phy_type */
#define	SA_SUNI155	1
#define	SA_DS3		2

/*
 * Stream head silently enforces a 1K limit of size of ioctl argument.
 * If you try larger than 1024 bytes, it silently truncates to 1024 bytes.
 * 256 * sizeof (int) + sizeof (int) is 1028, too big. So only support
 * 128 interfaces
 */
#define	ATM_GETUNIT_MAX	128
typedef struct {
	unsigned int	numdevs;
	unsigned int	unit[ATM_GETUNIT_MAX];
} atm_getunit_t;

typedef struct {
	int	mode;
#define	ATM_PHY_SONET	0
#define	ATM_PHY_SDH	1
} atm_sdh_t;

/* Promiscuous flags */
#define	ATM_SNOOP_TX	0x80000000
#define	ATM_SNOOP_VPCI	0x00FFFFFF
#define	ATM_SNOOP_ENCAP	0x0F000000

#define	ATM_SNOOP_RAW	0x00000000
#define	ATM_SNOOP_LANE	0x01000000
#define	ATM_SNOOP_LLC	0x02000000
#define	ATM_SNOOP_MARS	0x03000000
#define	ATM_SNOOP_IFMP	0x04000000
#define	ATM_SNOOP_ILMI	0x05000000
#define	ATM_SNOOP_Q93B	0x06000000

/*
 * Loopback modes: For diagnostic testing purposes the ATM card
 * can be placed in loopback mode. Two loopback modes are recognized:
 * INTERNAL loopback sets the ASIC's loopback path, which is immediately
 * before the UTOPIA interface (i.e. packets are segmented into cells,
 * looped around at the media FIFO, and reassembled into packets).
 * PHY loopback sets the Sonet framer into loopback mode. OFF disables
 * loopback mode; the card will work normally again.
 *
 * Older versions of the ATM driver did not support A_?ET_LOOP_MODE,
 * and will fail with EINVAL. Your only option then is to ask the user
 * to add a fiber "pigtail" loopback.
 *
 * Not all Sonet framers support PHY loopback. The driver will fail
 * with ENOTSUP if you request PHY loopback with these framers. In
 * this case you should try again with INTERNAL loopback.
 */
typedef struct {
	int loopback;
#define	ATM_LOOPBACK_OFF		0
#define	ATM_INTERNAL_LOOPBACK_ON	1
#define	ATM_PHY_LOOPBACK_ON		2
} atm_loopback_t;

/* Get/Set Mars CMI */
typedef struct {
	unsigned int	sap;	/* The protocol SAP */
	unsigned short	cmi;	/* CMI for the given SAP */
} atm_marscmi_t;

/*
 * (SONET) async link notification
 *
 * The A_SONET_LINKNOTIF_REQ ioctl registers a streams
 * interest in receiving async link notification.
 *
 *	ioctl(fd, I_STR, &ioc);
 *
 * the ic_dp member of ioc should point at an atm_sonet_link_event_t
 * (definition below)
 */
#define A_SONET_LINKNOTIF_REQ		(ATMIOC|50)
/*
 * When there is a SONET link event, a M_PROTO message
 * is sent up the registered stream.
 *
 * The magic number below is specifically chosen by a random number
 * generator.  This was done so that the an ATM_SONET_LINKNOTIF_IND
 * message would never be confused with a current or future DLPI
 * message.
 */
#define ATM_SONET_LINKNOTIF_IND          0x430E7E06

/*
 * SONET link event structure:
 * This structure is used for both the request and indication messages.
 * For the request message:
 *     0 - do not send indications for this SONET state
 *     1 - send indications for this SONET state
 *
 * N.B. To deregister, set all indications to zero. (This happens
 *      automatically on close)
 *
 * For the indication message:
 *     0 - SONET state is not set (false)
 *     1 - SONET state is set (true)
 */
typedef struct {
	t_uscalar_t	primitive;	/* ATM_SONET_LINKNOTIF_IND */
	uint8_t		los;		/* Loss of signal */
	uint8_t		lof;		/* Loss of frame */
	uint8_t		prdi;		/* Path remote defect indication */
	uint8_t		lrdi;		/* Line remote defect indication */
} atm_sonet_link_event_t;

#endif /* _ATM_ATMIOCTL_H */
