/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import java.util.Random;

public class PasswordCredential {
    public static final int MAX_PASSWORD_SIZE = 16;
    public static final byte[] NULL_PASSWORD = new byte[16];
    private byte[] junk;
    private byte[] userpswd;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public PasswordCredential() {
        this.setup();
        this.userpswd = new byte[16];
        this.zap(this.userpswd);
    }

    public PasswordCredential(String string) {
        this.setup();
        this.userpswd = new byte[16];
        if (string != null && string.trim().length() > 0) {
            this.encode(this.userpswd, string);
        } else {
            this.zap(this.userpswd);
        }
    }

    public void clearUserPassword() {
        this.zap(this.userpswd);
    }

    protected String decode(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[16];
        System.arraycopy(this.junk, 0, byArray2, 0, 16);
        int n = 16;
        boolean bl = true;
        int n2 = 0;
        int n3 = n;
        while (n2 < n) {
            int n4 = n2;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray[n2]);
            if (bl && byArray2[n2] == 0) {
                bl = false;
                n3 = n2;
            }
            ++n2;
        }
        if (n3 > 0) {
            string = new String(byArray2, 0, n3);
        }
        return string;
    }

    protected void encode(byte[] byArray, String string) {
        if (string != null) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(this.junk, 0, byArray2, 0, 16);
            byte[] byArray3 = string.getBytes();
            int n = byArray3.length;
            if (n > 16) {
                n = 16;
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                byArray2[n3] = (byte)(byArray2[n3] ^ byArray3[n2]);
                ++n2;
            }
            if (n2 < 16) {
                int n4 = n2;
                byArray2[n4] = (byte)(byArray2[n4] ^ 0);
            }
            System.arraycopy(byArray2, 0, byArray, 0, 16);
        } else {
            this.zap(byArray);
        }
    }

    private byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = 0;
            char c = string.charAt(n2);
            int n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(n4 << 4 & 0xF0);
                    break;
                }
                ++n4;
            }
            c = string.charAt(++n2);
            n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(byArray[n3] | (byte)(n4 & 0xF));
                    break;
                }
                ++n4;
            }
            ++n3;
            ++n2;
        }
        return byArray;
    }

    public String getUserPassword() {
        return this.decode(this.userpswd);
    }

    public void setUserPassword(String string) {
        if (string != null && string.trim().length() > 0) {
            this.encode(this.userpswd, string);
        } else {
            this.zap(this.userpswd);
        }
    }

    private void setup() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        this.junk = new byte[16];
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        random.nextBytes(byArray);
        random.nextBytes(byArray2);
        l = System.currentTimeMillis();
        long l2 = 1L;
        long l3 = 0L;
        int n = 0;
        while (n < 16) {
            l3 = l & l2;
            this.junk[n] = l3 > 0L ? byArray[n] : byArray2[n];
            l2 <<= 1;
            ++n;
        }
    }

    private String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void zap(byte[] byArray) {
        System.arraycopy(NULL_PASSWORD, 0, byArray, 0, 16);
        byArray[0] = this.junk[0];
    }
}

