/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.common;

import com.sun.admin.diskmgr.common.DiskData;
import java.io.Serializable;

public class SliceData
implements Serializable,
Cloneable {
    protected static final int MIN_SLICE_NUM = 0;
    protected static final int MAX_SLICE_NUM = 7;
    protected static final int MAX_X86_SLICE_NUM = 9;
    protected static final short UNASSIGNED = 0;
    public static final String UNASSIGNEDSTR = "unassigned";
    protected static final short BOOT = 1;
    public static final String BOOTSTR = "boot";
    protected static final short ROOT = 2;
    public static final String ROOTSTR = "root";
    protected static final short SWAP = 3;
    public static final String SWAPSTR = "swap";
    protected static final short USR = 4;
    public static final String USRSTR = "usr";
    public static final short BACKUP = 5;
    public static final String BACKUPSTR = "backup";
    protected static final short STAND = 6;
    public static final String STANDSTR = "stand";
    protected static final short VAR = 7;
    public static final String VARSTR = "var";
    protected static final short HOME = 8;
    public static final String HOMESTR = "home";
    protected static final short ALTSCTR = 9;
    public static final String ALTSCTRSTR = "altsctr";
    protected static final short CACHE = 10;
    public static final String CACHESTR = "cache";
    public static final short MOUNT_RW = 0;
    public static final short UMOUNT_RW = 1;
    public static final short MOUNT_RO = 16;
    public static final short UMOUNT_RO = 17;
    private DiskData diskData;
    private short partition;
    private short tag;
    private short flag;
    private int startCylinder = 0;
    private int endCylinder = 0;
    private int numSectors = 0;
    private boolean fs = false;

    public SliceData(DiskData diskData, short s) {
        this.diskData = diskData;
        this.partition = s;
        this.startCylinder = 0;
        this.endCylinder = 0;
    }

    public SliceData(DiskData diskData, short s, short s2, short s3, int n, int n2, boolean bl) {
        this.diskData = diskData;
        this.partition = s;
        this.flag = s3;
        this.startCylinder = n;
        this.numSectors = n2;
        this.setTag(s2);
        this.fs = bl;
        this.calculateEndCylinder();
    }

    private void calculateEndCylinder() {
        if (this.tag == 5) {
            this.endCylinder = this.diskData.getSolarisCylinders() - 1;
            return;
        }
        this.endCylinder = this.startCylinder + this.diskData.sectorToCylinder(this.numSectors) - 1;
        if (this.endCylinder < 0) {
            this.endCylinder = 0;
        }
    }

    private void calculateNumSectors() {
        int n = this.endCylinder - this.startCylinder;
        if (n <= 0) {
            this.numSectors = 0;
            return;
        }
        this.numSectors = this.diskData.cylinderToSector(++n);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public float computeSize() {
        int n = this.endCylinder - this.startCylinder;
        return this.diskData.cylinderToMB(n);
    }

    public boolean equals(SliceData sliceData) {
        if (sliceData == null) {
            return false;
        }
        return this.getPartition() == sliceData.getPartition() && this.getTag() == sliceData.getTag() && this.getFlag() == sliceData.getFlag() && this.getStartCylinder() == sliceData.getStartCylinder() && this.getEndCylinder() == sliceData.getEndCylinder();
    }

    public String getCylRange() {
        Integer n = new Integer(this.getStartCylinder());
        Integer n2 = new Integer(this.getEndCylinder());
        String string = new String(String.valueOf(n.toString()) + " - " + n2.toString());
        return string;
    }

    public DiskData getDiskData() {
        return this.diskData;
    }

    public int getEndCylinder() {
        return this.endCylinder;
    }

    public boolean getFS() {
        return this.fs;
    }

    public short getFlag() {
        return this.flag;
    }

    public int getNumSectors() {
        this.calculateNumSectors();
        return this.numSectors;
    }

    public short getPartition() {
        return this.partition;
    }

    public String getSize() {
        return Float.toString(this.computeSize());
    }

    public String getSliceName() {
        return String.valueOf(this.diskData.getDiskName()) + "s" + this.partition;
    }

    public int getStartCylinder() {
        return this.startCylinder;
    }

    public short getTag() {
        return this.tag;
    }

    public String getTagAsString() {
        String string = null;
        if (this.tag == 0) {
            string = UNASSIGNEDSTR;
        } else if (this.tag == 1) {
            string = BOOTSTR;
        } else if (this.tag == 2) {
            string = ROOTSTR;
        } else if (this.tag == 3) {
            string = SWAPSTR;
        } else if (this.tag == 4) {
            string = USRSTR;
        } else if (this.tag == 5) {
            string = BACKUPSTR;
        } else if (this.tag == 6) {
            string = STANDSTR;
        } else if (this.tag == 7) {
            string = VARSTR;
        } else if (this.tag == 8) {
            string = HOMESTR;
        } else if (this.tag == 9) {
            string = ALTSCTRSTR;
        } else if (this.tag == 10) {
            string = CACHESTR;
        }
        return string;
    }

    public void print() {
        System.out.println("*************************************");
        System.out.println("Slice Number:\t" + this.partition);
        System.out.println("Tag:\t\t" + this.tag);
        System.out.println("Flag:\t\t" + this.flag);
        System.out.println("Start Cylinder:\t" + this.startCylinder);
        System.out.println("End Cylinder:\t" + this.endCylinder);
        System.out.println("Num Sectors:\t" + this.numSectors);
        System.out.println("File System:\t" + this.fs);
        System.out.println("*************************************");
    }

    public void setEndCylinder(int n) {
        this.endCylinder = n;
        this.calculateNumSectors();
    }

    public void setFS(boolean bl) {
        this.fs = bl;
    }

    public void setFlag(short s) {
        this.flag = s;
    }

    public void setNumSectors(int n) {
        this.numSectors = n;
        this.calculateEndCylinder();
    }

    public void setPartition(short s) {
        this.partition = s;
    }

    public void setStartCylinder(int n) {
        this.startCylinder = n;
        this.calculateNumSectors();
    }

    public void setTag(short s) {
        this.tag = s;
        if (s == 5) {
            this.startCylinder = 0;
            this.setEndCylinder(this.diskData.getSolarisCylinders() - 1);
        }
    }
}

