/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.I18N;
import com.sun.wbem.provider20.InstanceProvider;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Hashtable;

class LogFile {
    private static int ctimes = 0;
    private static Hashtable serviceClass;
    private static Hashtable serviceProvider;
    private static InstanceProvider logProvider;
    public static final int DEVELOPMENT = 4;
    public static final int DEBUG = 3;
    public static final int INFORMATIONAL = 2;
    public static final int WARNING = 1;
    public static final int CRITICAL = 0;
    private static final String newLine = "\n";
    private static boolean started;
    private static int logLevel;
    private static DataOutputStream fStream;
    private static String fileName;
    private static File f;
    private static boolean verbose;
    private static final String LOGCLASS = "Solaris_LogRecord";
    private static final String LOGDIRPARENT = "/var/sadm/wbem";

    static {
        logProvider = null;
        started = true;
        logLevel = 1;
        fileName = "cimom.log";
        f = null;
        verbose = false;
    }

    LogFile() {
    }

    public static void add(int n, String string) throws CIMException {
        if (logLevel >= n) {
            CIMInstance cIMInstance = LogFile.getLogInstance();
            if (cIMInstance == null) {
                return;
            }
            cIMInstance.setProperty("DetailedMessage", new CIMValue((Object)I18N.loadString(string)));
            LogFile.setProperties(cIMInstance, string, n);
            if (logLevel < 3) {
                try {
                    logProvider.createInstance(new CIMObjectPath(cIMInstance.getClassName(), "/root/cimv2"), cIMInstance);
                }
                catch (CIMException cIMException) {
                    System.out.println((Object)cIMException);
                    throw cIMException;
                }
            }
            LogFile.addInfo(cIMInstance.toString());
        }
    }

    public static void add(int n, String string, Object object) throws CIMException {
        LogFile.add(n, string, new Object[]{object});
    }

    public static void add(int n, String string, Object object, Object object2) throws CIMException {
        LogFile.add(n, string, new Object[]{object, object2});
    }

    public static void add(int n, String string, Object object, Object object2, Object object3) throws CIMException {
        LogFile.add(n, string, new Object[]{object, object2, object3});
    }

    public static void add(int n, String string, Object[] objectArray) throws CIMException {
        if (logLevel >= n) {
            MessageFormat messageFormat = new MessageFormat(I18N.loadString(string));
            messageFormat.setLocale(I18N.locale);
            CIMInstance cIMInstance = LogFile.getLogInstance();
            if (cIMInstance == null) {
                return;
            }
            cIMInstance.setProperty("DetailedMessage", new CIMValue((Object)messageFormat.format(objectArray)));
            LogFile.setProperties(cIMInstance, string, n);
            if (logLevel < 3) {
                try {
                    logProvider.createInstance(new CIMObjectPath(cIMInstance.getClassName(), "/root/cimv2"), cIMInstance);
                }
                catch (CIMException cIMException) {
                    System.out.println((Object)cIMException);
                    throw cIMException;
                }
            }
            LogFile.addInfo(cIMInstance.toString());
        }
    }

    private static void addInfo(String string) {
        if (f.length() > 5000000L) {
            try {
                f.delete();
                f.createNewFile();
                fStream = new DataOutputStream(new FileOutputStream(f.getAbsolutePath()));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        try {
            fStream.writeBytes(string);
            fStream.writeBytes(newLine);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getFileName() {
        return fileName;
    }

    public static int getLevel() {
        return logLevel;
    }

    private static CIMInstance getLogInstance() {
        if (serviceClass == null) {
            return null;
        }
        CIMClass cIMClass = (CIMClass)serviceClass.get(LOGCLASS);
        if (cIMClass == null) {
            return null;
        }
        logProvider = (InstanceProvider)serviceProvider.get(LOGCLASS);
        if (logProvider == null) {
            return null;
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        return cIMInstance;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void initialize(Hashtable hashtable, Hashtable hashtable2) throws CIMException {
        serviceClass = hashtable;
        serviceProvider = hashtable2;
        try {
            String string = System.getProperty("logdir", String.valueOf(System.getProperty("logparent", LOGDIRPARENT)) + File.separator + "logr");
            f = new File(String.valueOf(string) + File.separator + fileName);
            f.createNewFile();
            fStream = new DataOutputStream(new FileOutputStream(String.valueOf(string) + File.separator + fileName));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void methodEntry(String string) throws CIMException {
        LogFile.add(4, "METHOD_ENTRY", string);
    }

    public static void methodReturn(String string) throws CIMException {
        LogFile.add(4, "METHOD_RETURN", string);
    }

    public static void setLevel(int n) {
        logLevel = n;
    }

    private static void setProperties(CIMInstance cIMInstance, String string, int n) {
        cIMInstance.setProperty("SummaryMessage", new CIMValue((Object)string));
        cIMInstance.setProperty("AppName", new CIMValue((Object)"CIMOM"));
        cIMInstance.setProperty("category", new CIMValue((Object)new Integer(0)));
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 0: {
                n = 2;
                break;
            }
        }
        cIMInstance.setProperty("severity", new CIMValue((Object)new Integer(n)));
        cIMInstance.setProperty("UserName", new CIMValue((Object)"CIMOM"));
        cIMInstance.setProperty("ClientMachineName", new CIMValue((Object)"<none>"));
        String string2 = ".";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {}
        cIMInstance.setProperty("ServerMachineName", new CIMValue((Object)string2));
        cIMInstance.setProperty("data", new CIMValue((Object)""));
        cIMInstance.setProperty("syslogflag", new CIMValue((Object)new Boolean(false)));
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void start() {
        started = true;
    }
}

