/*
 * "@(#)NativeProvider.java	1.5 1.5 SMI"
 *
 * Copyright 1998-1999 Sun Microsystems, Inc.,
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * For more on the Java Native Interface surf to :       
 * http://www.javasoft.com/docs/books/tutorial/native1.1/index.html
 *
 */

import com.sun.wbem.cim.*;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.CIMProvider;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.provider.MethodProvider;
import java.util.*;
import java.io.*;

    /**
     *
     *
     * @author	Sun Microsystems, Inc.
     * @version    1.5, 02/18/00
     * @since      WBEM 1.0
     */
public class NativeProvider implements InstanceProvider, MethodProvider {

    private CIMOMHandle cimomhandle = null;

    public void initialize(CIMOMHandle cimom) 
    throws CIMException {
        this.cimomhandle = cimomhandle;
    }

    public void cleanup() 
    throws CIMException {
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc,
    boolean localOnly)
    throws CIMException {
	if (op.getObjectName().equalsIgnoreCase("native_example")) {
	    Native_Example ne = new Native_Example();
	    return ne.enumerateInstances(op);
	}
	return new Vector();
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc)
    throws CIMException {
	if (op.getObjectName().equalsIgnoreCase("native_example")) {
	    Native_Example ne = new Native_Example();
	    return ne.enumerateInstances(op);
	}
	return new Vector();
    }

    public CIMInstance getInstance(CIMObjectPath op, CIMClass cc, 
    boolean localOnly) 
    throws CIMException {
	if (op.getObjectName().equalsIgnoreCase("native_example")) {
	    Native_Example ne = new Native_Example();
	    return ne.getInstance(op, cc);
	}
		return new CIMInstance();
    }


    public CIMValue invokeMethod(CIMObjectPath op, String methodName, 
	Vector inParams, Vector outParams) throws CIMException {
	if (op.getObjectName().equalsIgnoreCase("native_example")) {
	    Native_Example ne = new Native_Example();
            if (methodName.equalsIgnoreCase("helloworld")) {
	        return new CIMValue(ne.HelloWorld());
            }
	}
        return null;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) 
    throws CIMException {
        throw(new CIMException(CIMException.CIM_ERR_NOT_SUPPORTED));
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) 
    throws CIMException {
        throw(new CIMException(CIMException.CIM_ERR_NOT_SUPPORTED));
    }

    public void deleteInstance(CIMObjectPath cp) 
    throws CIMException {
        throw(new CIMException(CIMException.CIM_ERR_NOT_SUPPORTED));
    }

    public Vector execQuery(CIMObjectPath op, String query, int ql, CIMClass cc)
    { return null; }

}
