/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common.iconpanel;

import com.sun.admin.cis.common.iconpanel.IconPanel;
import com.sun.admin.cis.common.iconpanel.IconPanelElement;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class IconPanelButton
extends JButton {
    private Object dObject;
    private int elementIndex = -1;
    private boolean selected = false;
    private String name;
    private ImageIcon icon;
    private Color selectedColor = IconPanel.DEFAULT_SELECTED_COLOR;
    private Color unselectedColor = IconPanel.DEFAULT_UNSELECTED_COLOR;

    public IconPanelButton(IconPanelElement iconPanelElement, int n, IconPanel iconPanel) {
        super(iconPanelElement.getName(), iconPanelElement.getIcon());
        this.name = iconPanelElement.getName();
        this.icon = iconPanelElement.getIcon();
        this.dObject = iconPanelElement.getDataObject();
        this.elementIndex = n;
        this.selectedColor = iconPanel.getSelectedColor();
        this.unselectedColor = iconPanel.getUnselectedColor();
        this.setSelected(iconPanelElement.getSelected());
        this.setAppearance();
    }

    public IconPanelButton(String string, ImageIcon imageIcon, Object object, int n) {
        super(string, imageIcon);
        this.name = string;
        this.icon = imageIcon;
        this.dObject = object;
        this.elementIndex = n;
        this.setAppearance();
    }

    public IconPanelButton(String string, ImageIcon imageIcon, Object object) {
        super(string, imageIcon);
        this.name = string;
        this.icon = imageIcon;
        this.dObject = object;
        this.setAppearance();
    }

    public IconPanelButton(String string, ImageIcon imageIcon) {
        super(string, imageIcon);
        this.name = string;
        this.icon = imageIcon;
        this.setAppearance();
    }

    public IconPanelButton(String string) {
        super(string);
        this.name = string;
        this.setAppearance();
    }

    public IconPanelButton(ImageIcon imageIcon) {
        super(imageIcon);
        this.icon = imageIcon;
        this.setAppearance();
    }

    public IconPanelButton() {
        this.setAppearance();
    }

    public Object getDataObject() {
        return this.dObject;
    }

    public void setDataObject(Object object) {
        this.dObject = object;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public void setElementIndex(int n) {
        this.elementIndex = n;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        this.selected = bl;
        if (this.selected) {
            this.setBackground(this.selectedColor);
            return;
        }
        this.setBackground(this.unselectedColor);
    }

    public void copyFromIconPanelElement(IconPanelElement iconPanelElement, int n, IconPanel iconPanel) {
        if (iconPanelElement.getName() != this.name) {
            this.name = iconPanelElement.getName();
            this.setText(this.name);
        }
        if (iconPanelElement.getIcon() != this.icon) {
            this.icon = iconPanelElement.getIcon();
            this.setIcon(this.icon);
        }
        this.selectedColor = iconPanel.getSelectedColor();
        this.unselectedColor = iconPanel.getUnselectedColor();
        this.setSelected(iconPanelElement.getSelected());
        this.dObject = iconPanelElement.getDataObject();
        this.elementIndex = n;
    }

    private void setAppearance() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setBackground(this.unselectedColor);
    }
}

