/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.admin.cis.service.directorytable.DnsTableDefinitions;
import com.sun.admin.cis.service.directorytable.SearchTemplate;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.cis.service.directorytable.TableSetup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.StringCharacterIterator;
import java.util.Vector;

public class DnsDirectoryTable
implements DirectoryTable,
TableSetup {
    private static final String nslookupCmd = "/usr/sbin/nslookup";
    private static final String grepCmd = "/bin/grep";
    TableDefinitions tableDefinitions;
    String serverName;
    String domainName;
    String[] lines;
    int currentLine;
    boolean needsFlush;

    public int access(String string) throws DirectoryTableException {
        if (string.equals("hosts")) {
            return 4;
        }
        return 0;
    }

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (tableDefinitions.getTableName().equals("hosts")) {
            return 4;
        }
        return 0;
    }

    public void open(String string) throws DirectoryTableException {
        this.tableDefinitions = new DnsTableDefinitions();
        this.tableDefinitions.loadTableDefinitions(string);
        this.lines = null;
        this.currentLine = 0;
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        String string = tableDefinitions.getTableName();
        if (!string.equals("hosts")) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
        this.tableDefinitions = tableDefinitions;
        this.lines = null;
        this.currentLine = 0;
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        throw new DirectoryTableOperationNotSupportedException("create");
    }

    public void create(String string) throws DirectoryTableException {
        throw new DirectoryTableOperationNotSupportedException("create");
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        throw new DirectoryTableOperationNotSupportedException("delete");
    }

    public void delete(String string) throws DirectoryTableException {
        throw new DirectoryTableOperationNotSupportedException("delete");
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException directoryTableException) {
            this.needsFlush = false;
        }
        this.tableDefinitions = null;
        this.lines = null;
        this.currentLine = 0;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        this.needsFlush = true;
    }

    public void deleteRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        this.needsFlush = true;
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        this.needsFlush = true;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(directoryRow);
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(directoryRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.getFirstLine();
        if (string == null) {
            return null;
        }
        this.parseStringIntoRow(string, directoryRow, 1);
        if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
            return directoryRow;
        }
        string = this.getNextLine();
        while (string != null) {
            directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            string = this.getNextLine();
        }
        return null;
    }

    public DirectoryRow getNextRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.getNextLine();
        while (string != null) {
            directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            string = this.getNextLine();
        }
        return null;
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        String string = this.getFirstLine();
        int n = 1;
        int n2 = 0;
        if (string == null) {
            return null;
        }
        n2 = this.parseStringIntoRow(string, directoryRow, n);
        string = this.getNextLine();
        while (string != null) {
            if (n2 > 0) {
                directoryRow.addRows(1);
                ++n;
            }
            n2 = this.parseStringIntoRow(string, directoryRow, n);
            string = this.getNextLine();
        }
        if (n == 1 && directoryRow.isEmpty(n)) {
            return null;
        }
        return directoryRow;
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        DirectoryRow directoryRow2 = null;
        String string = this.getFirstLine();
        int n = 0;
        if (string == null) {
            return directoryRow2;
        }
        directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        this.parseStringIntoRow(string, directoryRow, 1);
        if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
            if (n == 0) {
                directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                n = 1;
            }
            this.parseStringIntoRow(string, directoryRow2, n);
            ++n;
        }
        string = this.getNextLine();
        while (string != null) {
            directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                if (n == 0) {
                    directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                    n = 1;
                } else {
                    directoryRow2.addRows(1);
                }
                this.parseStringIntoRow(string, directoryRow2, n);
                ++n;
            }
            string = this.getNextLine();
        }
        return directoryRow2;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int n) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), n);
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new DnsTableDefinitions();
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public void setContext(String string) throws DirectoryTableException {
        this.domainName = "";
        try {
            this.serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new DirectoryTableException("EXM_INTERNAL");
        }
        int n = 0;
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n2 > 0) {
            this.serverName = string.substring(n, n2);
        }
        if (n2 == string.length()) {
            return;
        }
        n = n2 + 1;
        if ((n2 = string.indexOf("/", n)) == -1) {
            n2 = string.length();
        }
        if (n2 - n > 0) {
            this.domainName = string.substring(n, n2);
        }
        if (n2 == string.length()) {
            return;
        }
    }

    public Vector getScopes(int n) {
        String string;
        String[] stringArray = new String[]{"sh", "-c", "/usr/sbin/nslookup localhost </dev/null"};
        String string2 = null;
        Vector<String> vector = null;
        int n2 = -1;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return vector;
        }
        String[] stringArray2 = AdminCommonTools.CMN_exec(stringArray);
        int n3 = 0;
        while (n3 < stringArray2.length) {
            n2 = stringArray2[n3].indexOf("Server:");
            if (n2 != -1) {
                string2 = stringArray2[n3].substring(n2 + 1).trim();
            }
            ++n3;
        }
        if (string2 == null) {
            return vector;
        }
        String string3 = string2.substring(string2.indexOf(".") + 1);
        if (string3.equals("")) {
            return vector;
        }
        DnsTableDefinitions dnsTableDefinitions = new DnsTableDefinitions();
        try {
            dnsTableDefinitions.loadTableDefinitions("hosts");
        }
        catch (Exception exception) {
            return vector;
        }
        String string4 = dnsTableDefinitions.getMappedTableName();
        if ((n & 2) != 2) {
            vector = new Vector<String>();
            vector.addElement("dns:/" + string + "/" + string3);
        }
        return vector;
    }

    public void setup() {
    }

    public void refreshSetup() {
    }

    protected int parseStringIntoRow(String string, DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = 0;
        String string2 = new String(string);
        string2.trim();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.tableDefinitions.getColumnSeparators());
        char c = stringCharacterIterator.first();
        char c2 = stringCharacterIterator.next();
        while (c2 != '\uffff') {
            string2 = string2.replace(c2, c);
            c2 = stringCharacterIterator.next();
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if ((n5 = string2.indexOf(c, n4)) == -1) {
                if (n4 == string2.length() - 1) {
                    return n2;
                }
                directoryRow.putColumn(n3, n, string2.substring(n4).trim());
                return ++n2;
            }
            if (this.tableDefinitions.getColumnName(n3).equals("aliases")) {
                directoryRow.putColumn(n3, n, string2.substring(n4).trim());
                return ++n2;
            }
            directoryRow.putColumn(n3, n, string2.substring(n4, n5).trim());
            ++n2;
            ++n3;
            if (n5 < string2.length() && string2.charAt(n5) == c) {
                ++n5;
            }
            while (n5 < string2.length() && string2.charAt(n5) == c) {
                ++n5;
                if ((this.tableDefinitions.getTableAttributes() & 2) != 2) continue;
                ++n3;
            }
            if (n5 == string2.length()) {
                return n2;
            }
            n4 = n5;
        }
    }

    protected String getFirstLine() throws DirectoryTableException {
        String[] stringArray = new String[]{"sh", "-c", "echo 'ls " + this.domainName + "' | " + nslookupCmd};
        this.lines = AdminCommonTools.CMN_exec(stringArray);
        this.currentLine = 0;
        if (this.currentLine < this.lines.length) {
            ++this.currentLine;
            return this.lines[this.currentLine - 1];
        }
        this.currentLine = 0;
        this.lines = null;
        return null;
    }

    protected String getNextLine() throws DirectoryTableException {
        if (this.currentLine < this.lines.length) {
            ++this.currentLine;
            return this.lines[this.currentLine - 1];
        }
        this.currentLine = 0;
        this.lines = null;
        return null;
    }
}

