/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.security.AdminSecurityException;
import java.io.Serializable;
import java.security.Principal;

public class AdminPrincipal
implements Principal,
Cloneable,
Serializable {
    public static final int ADM_SOLARIS_USER = 0;
    public static final int ADM_NT_USER = 1;
    public static final int ADM_MGMT_SERVER = 2;
    private int type;
    private String name;
    private String domType;
    private String domName;

    public AdminPrincipal(int n, String string, String string2, String string3) throws AdminSecurityException {
        if (n < 0 || n > 2) {
            throw new AdminSecurityException("EXSS_IPT", new Integer(n));
        }
        this.type = n;
        if (string == null || string.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_IPN");
        }
        this.name = string;
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_IPDT");
        }
        this.domType = string2;
        if (string3 == null || string3.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_IPDN");
        }
        this.domName = string3;
    }

    public boolean equals(Object object) {
        AdminPrincipal adminPrincipal = null;
        return object instanceof AdminPrincipal && (adminPrincipal = (AdminPrincipal)object).getUserType() == this.type && this.name.equals(adminPrincipal.getName());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "Solaris-user: ";
                break;
            }
            case 1: {
                string = "NT-user: ";
                break;
            }
            case 2: {
                string = "Mgmt-server: ";
                break;
            }
            default: {
                string = "Unknown-type: ";
            }
        }
        return String.valueOf(string) + this.name + " in " + this.domName + "(" + this.domType + ")";
    }

    public int hashCode() {
        return new String(String.valueOf(this.type) + this.name).hashCode();
    }

    public String getUserName() {
        int n = this.name.indexOf(46);
        String string = n < 0 ? this.name : this.name.substring(0, n);
        return string;
    }

    public String getDomainName() {
        return this.domName;
    }

    public int getUserType() {
        return this.type;
    }

    public String getDomainType() {
        return this.domType;
    }

    public AdminPrincipal newCopy() throws AdminException {
        return new AdminPrincipal(this.type, this.name, this.domType, this.domName);
    }
}

