/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.LimitInputDocument;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.cis.common.WizardStep;
import com.sun.admin.fsmgr.client.BrowseDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrBooleanOption;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.FsMgrAddShareWizard;
import com.sun.admin.fsmgr.client.share.FsMgrShareData;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrRemoteFile;
import com.sun.admin.fsmgr.common.FsMgrShare;
import com.sun.admin.fsmgr.common.FsMgrShareDataException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FsMgrAddShareDirectoryStep
implements WizardStep {
    private String directory = "";
    private String description = "";
    FsMgrClient fsMgrClient = FsMgrClient.instance();
    FsMgrAddShareWizard wizard;
    FsMgrShareData shareData;
    JTextField directoryField;
    JTextField descriptionField;
    JCheckBox subdirsChk;
    JPanel stepPanel;
    ErrorDialog errorDlg;
    WarningDialog warningDlg;
    WarningListener warningListener = new WarningListener();

    public FsMgrAddShareDirectoryStep() {
        this.stepPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.stepPanel.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(FsMgrResourceStrings.getString("share_wiz_dir_explain"));
        Constraints.constrain(this.stepPanel, flowArea, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        Constraints.constrain(this.stepPanel, jPanel, 0, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        JLabel jLabel = new JLabel(FsMgrResourceStrings.getString("share_wiz_dir"));
        Constraints.constrain(jPanel, jLabel, 0, 0, 2, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 10);
        this.directoryField = new JTextField("", 20);
        Constraints.constrain(jPanel, this.directoryField, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 10, 0);
        this.directoryField.getDocument().addDocumentListener(new DirectoryFieldListener());
        JButton jButton = new JButton(FsMgrResourceStrings.getString("browse_button"));
        Constraints.constrain(jPanel, jButton, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 5, 10, 5);
        jButton.setEnabled(true);
        jButton.addActionListener(new BrowseBtnListener());
        jLabel = new JLabel(FsMgrResourceStrings.getString("share_wiz_desc"));
        Constraints.constrain(jPanel, jLabel, 0, 2, 2, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 10);
        LimitInputDocument limitInputDocument = new LimitInputDocument(255);
        this.descriptionField = new JTextField(limitInputDocument, "", 20);
        Constraints.constrain(jPanel, this.descriptionField, 0, 3, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 10, 0);
        this.subdirsChk = new JCheckBox(FsMgrResourceStrings.getString("share_wiz_subdirs"), true);
        Constraints.constrain(jPanel, this.subdirsChk, 0, 4, 2, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 0);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain(this.stepPanel, jPanel2, 0, 2, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
    }

    public String getDescription() {
        return FsMgrResourceStrings.getString("share_wiz_dir_step");
    }

    public Component getComponent() {
        return this.stepPanel;
    }

    public void setActive(int n) {
        this.wizard = FsMgrAddShareWizard.instance();
        this.shareData = this.wizard.getShareData();
        if (this.shareData == null) {
            this.subdirsChk.setSelected(true);
            this.directoryField.setText("");
            this.descriptionField.setText("");
            return;
        }
        this.directoryField.setText(this.shareData.getPathname());
        this.descriptionField.setText(this.shareData.getDescription());
        FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)this.shareData.getOption(FsMgrShareData.NOSUB);
        this.subdirsChk.setSelected(fsMgrBooleanOption == null || !fsMgrBooleanOption.getValue());
    }

    public boolean setInactive(int n) {
        FsMgrShare fsMgrShare = null;
        FsMgrShare fsMgrShare2 = null;
        FsMgrRemoteFile fsMgrRemoteFile = null;
        String string = this.directoryField.getText();
        if (!string.startsWith("/")) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("share_wiz_dir_err1"));
            return false;
        }
        try {
            fsMgrRemoteFile = this.fsMgrClient.getFile(string);
        }
        catch (FsMgrException fsMgrException) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
            return false;
        }
        if (fsMgrRemoteFile == null) {
            this.warningDlg = new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("warning_dlg_title"), FsMgrResourceStrings.getString("MntPntDirDoesntExist"), (ActionListener)this.warningListener, FsMgrResourceStrings.getString("ok_button"));
            try {
                fsMgrRemoteFile = this.fsMgrClient.getFile(string);
            }
            catch (FsMgrException fsMgrException) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
            }
            if (fsMgrRemoteFile == null) {
                return false;
            }
        }
        try {
            fsMgrShare = this.fsMgrClient.getShareEntry(FsMgrShareData.DFSTAB, string);
            if (fsMgrShare != null) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("share_wiz_dir_err2"));
                return false;
            }
        }
        catch (FsMgrException fsMgrException) {}
        try {
            fsMgrShare2 = this.fsMgrClient.getShareEntry(FsMgrShareData.SHARETAB, string);
            if (fsMgrShare2 != null) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("share_wiz_dir_err2"));
                return false;
            }
        }
        catch (FsMgrException fsMgrException) {}
        if (this.shareData == null) {
            try {
                this.shareData = new FsMgrShareData(this.directoryField.getText());
            }
            catch (FsMgrShareDataException fsMgrShareDataException) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
                return false;
            }
        } else {
            this.shareData.setPathname(this.directoryField.getText());
        }
        this.shareData.setDescription(this.descriptionField.getText());
        try {
            if (!this.subdirsChk.isSelected()) {
                this.shareData.setOption(FsMgrShareData.NOSUB, true);
            } else {
                this.shareData.setOption(FsMgrShareData.NOSUB, false);
            }
        }
        catch (FsMgrShareDataException fsMgrShareDataException) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
            return false;
        }
        this.wizard.setShareData(this.shareData);
        return true;
    }

    class DirectoryFieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            FsMgrAddShareDirectoryStep.this.wizard.setForwardEnabled(documentEvent.getDocument().getLength() != 0);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        DirectoryFieldListener() {
            FsMgrAddShareDirectoryStep.this = FsMgrAddShareDirectoryStep.this;
        }
    }

    class BrowseBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BrowseDialog browseDialog = new BrowseDialog(FsMgrResourceStrings.getString("browse_title"), FsMgrAddShareDirectoryStep.this.directoryField);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)browseDialog).setLocation(dimension.width / 2 - browseDialog.getSize().width / 2, dimension.height / 2 - browseDialog.getSize().height / 2);
            ((Component)browseDialog).setVisible(true);
        }

        BrowseBtnListener() {
            FsMgrAddShareDirectoryStep.this = FsMgrAddShareDirectoryStep.this;
        }
    }

    class WarningListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FsMgrAddShareDirectoryStep.this.fsMgrClient.makeDirectory(FsMgrAddShareDirectoryStep.this.directoryField.getText());
                return;
            }
            catch (FsMgrException fsMgrException) {
                FsMgrAddShareDirectoryStep.this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
                return;
            }
        }

        WarningListener() {
            FsMgrAddShareDirectoryStep.this = FsMgrAddShareDirectoryStep.this;
        }
    }
}

