/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.QuickVector;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.iconpanel.IconPanel;
import com.sun.admin.cis.common.iconpanel.IconPanelButton;
import com.sun.admin.cis.common.iconpanel.IconPanelElement;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.hostmgr.client.AbstractIconModel;
import com.sun.admin.hostmgr.client.ListView;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public abstract class AbstractIconView
extends ListView {
    private IconPanel iconPanel;
    private boolean ascendSort = true;
    private QuickVector iconPanelElements = new QuickVector(1);
    private QuickVector selectedIconPanelElements = new QuickVector(1);
    ResourceBundle bundle = Main.getApp().getResourceBundle();
    private Vector dataCache = new Vector();
    private ButtonMouseListener buttonMouseListener = new ButtonMouseListener();

    protected abstract void onDoubleClick();

    protected abstract AbstractIconModel getIconModel();

    public AbstractIconView() {
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
    }

    public void setDataCache(Vector vector) {
        this.dataCache = vector;
    }

    public int getViewType() {
        return 1;
    }

    public void populate() {
        this.clear();
        String string = ResourceStrings.getString(this.bundle, "PopulateIconView");
        Object[] objectArray = new Object[2];
        objectArray[1] = new Integer(this.dataCache.size());
        Dimension dimension = new Dimension(this.getIconModel().getButtonWidth(), 90);
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        this.iconPanel.setElementSize(dimension);
        IconPanelElement iconPanelElement = null;
        this.iconPanelElements.setSize(this.dataCache.size());
        int n = 0;
        while (n < this.dataCache.size()) {
            Object e = this.dataCache.elementAt(n);
            ImageIcon imageIcon = this.getIconModel().getIcon(e);
            if ((n + 1) % 100 == 0) {
                objectArray[0] = new Integer(n + 1);
                Main.getApp().setStatusBar(MessageFormat.format(string, objectArray));
            }
            iconPanelElement = new IconPanelElement(this.getIconModel().getIconLabel(e), imageIcon, e);
            this.iconPanelElements.setElementAt(iconPanelElement, n);
            ++n;
        }
        this.iconPanel.setElements(this.iconPanelElements);
        this.paintView();
    }

    public void clear() {
        this.clearSelection();
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        this.iconPanelElements.removeAllElements();
        this.iconPanel.setElements(this.iconPanelElements);
        this.iconPanel.updateIcons();
    }

    public void append(Vector vector) {
        IconPanelElement iconPanelElement = null;
        int n = this.iconPanelElements.size();
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        Dimension dimension = new Dimension(this.getIconModel().getButtonWidth(), 90);
        this.iconPanel.setElementSize(dimension);
        this.iconPanelElements.setSize(n + vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e = vector.elementAt(n2);
            this.dataCache.addElement(e);
            ImageIcon imageIcon = this.getIconModel().getIcon(e);
            iconPanelElement = new IconPanelElement(this.getIconModel().getIconLabel(e), imageIcon, e);
            this.iconPanelElements.setElementAt(iconPanelElement, n2 + n);
            ++n2;
        }
        this.iconPanel.setElements(this.iconPanelElements);
        this.iconPanel.updateIcons();
    }

    private void paintView() {
        Sort.sort(this.iconPanelElements, (Compare)new ClientDataCompare());
        this.fireSortChanged();
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        this.iconPanel.updateIcons();
    }

    private void handlePopupTrigger(MouseEvent mouseEvent) {
        IconPanelButton iconPanelButton = (IconPanelButton)mouseEvent.getComponent();
        if (!iconPanelButton.getSelected()) {
            this.clearSelection();
            this.select(iconPanelButton);
        }
        this.firePopupTriggered(SwingUtilities.convertMouseEvent(iconPanelButton, mouseEvent, this.iconPanel));
    }

    private void select(IconPanelButton iconPanelButton) {
        Main.getApp().setHelp(this.getIconModel().getHelpName(iconPanelButton.getDataObject()));
        if (iconPanelButton.getSelected()) {
            return;
        }
        iconPanelButton.setSelected(true);
        ((IconPanelElement)this.iconPanelElements.quickElementAt(iconPanelButton.getElementIndex())).setSelected(true);
        this.selectedIconPanelElements.addElement(this.iconPanelElements.quickElementAt(iconPanelButton.getElementIndex()));
        this.fireItemPressed(0);
    }

    private void select(IconPanelElement iconPanelElement) {
        Main.getApp().setHelp(this.getIconModel().getHelpName(iconPanelElement.getDataObject()));
        if (iconPanelElement.getSelected()) {
            return;
        }
        iconPanelElement.setSelected(true);
        this.selectedIconPanelElements.addElement(iconPanelElement);
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        this.iconPanel.updateIcons();
        this.fireItemPressed(0);
    }

    public void clearSelection() {
        int n = 0;
        while (n < this.selectedIconPanelElements.size()) {
            IconPanelElement iconPanelElement = (IconPanelElement)this.selectedIconPanelElements.quickElementAt(n);
            iconPanelElement.setSelected(false);
            ++n;
        }
        this.selectedIconPanelElements.removeAllElements();
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        this.iconPanel.updateIcons();
        this.fireItemPressed(0);
    }

    public void unselect(IconPanelButton iconPanelButton) {
        if (!iconPanelButton.getSelected()) {
            return;
        }
        iconPanelButton.setSelected(false);
        ((IconPanelElement)this.iconPanelElements.quickElementAt(iconPanelButton.getElementIndex())).setSelected(false);
        int n = this.selectedIconPanelElements.indexOf(this.iconPanelElements.quickElementAt(iconPanelButton.getElementIndex()));
        if (n < 0) {
            return;
        }
        this.selectedIconPanelElements.removeElementAt(n);
        this.fireItemPressed(0);
    }

    public void selectAll() {
        this.selectedIconPanelElements.removeAllElements();
        int n = 0;
        while (n < this.iconPanelElements.size()) {
            IconPanelElement iconPanelElement = (IconPanelElement)this.iconPanelElements.elementAt(n);
            iconPanelElement.setSelected(true);
            this.selectedIconPanelElements.addElement(iconPanelElement);
            ++n;
        }
        if (this.iconPanel == null) {
            this.createIconPanel();
        }
        this.iconPanel.updateIcons();
        this.fireItemPressed(0);
    }

    public Vector getSelected() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.selectedIconPanelElements.size()) {
            IconPanelElement iconPanelElement = (IconPanelElement)this.selectedIconPanelElements.elementAt(n);
            vector.addElement(iconPanelElement.getDataObject());
            ++n;
        }
        return vector;
    }

    public void setSelected(Vector vector) {
        if (this.iconPanelElements.size() == 0) {
            return;
        }
        this.clearSelection();
        if (vector.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.iconPanelElements.size()) {
            IconPanelElement iconPanelElement = (IconPanelElement)this.iconPanelElements.elementAt(n);
            Object object = iconPanelElement.getDataObject();
            if (vector.indexOf(object) >= 0) {
                this.select(iconPanelElement);
            }
            ++n;
        }
    }

    public int getNumSelections() {
        return this.selectedIconPanelElements.size();
    }

    public void sortAscending() {
        if (this.ascendSort) {
            return;
        }
        this.ascendSort = true;
        1 var1_1 = new 1();
        var1_1.start();
    }

    public void sortDescending() {
        if (!this.ascendSort) {
            return;
        }
        this.ascendSort = false;
        2 var1_1 = new 2();
        var1_1.start();
    }

    public void sortByAttribute(String string) {
    }

    public int getSortOrder() {
        if (this.ascendSort) {
            return 3;
        }
        return 4;
    }

    public void find(String string) {
        if (this.iconPanelElements.size() == 0) {
            return;
        }
        int n = -1;
        if (this.getNumSelections() > 0) {
            IconPanelElement iconPanelElement = (IconPanelElement)this.selectedIconPanelElements.quickElementAt(this.getNumSelections() - 1);
            n = this.iconPanelElements.indexOf(iconPanelElement);
        }
        int n2 = 0;
        while (n2++ < this.iconPanelElements.size()) {
            if (++n == this.iconPanelElements.size()) {
                n = 0;
            }
            IconPanelElement iconPanelElement = (IconPanelElement)this.iconPanelElements.quickElementAt(n);
            Object object = iconPanelElement.getDataObject();
            String string2 = this.getIconModel().getIconLabel(object);
            if (string2.length() == 0 || string2.indexOf(string) < 0) continue;
            this.clearSelection();
            this.select(iconPanelElement);
            if (this.iconPanel == null) {
                this.createIconPanel();
            }
            this.iconPanel.scrollToElement(n);
            return;
        }
        Main.getApp().reportErrorException(new HostException("EXM_HST_GUI_FIND_FAILED", string));
    }

    public void find(Object object) {
        if (this.iconPanelElements.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.iconPanelElements.size()) {
            IconPanelElement iconPanelElement = (IconPanelElement)this.iconPanelElements.quickElementAt(n);
            Object object2 = iconPanelElement.getDataObject();
            if (object2 == object) {
                this.clearSelection();
                this.select(iconPanelElement);
                if (this.iconPanel == null) {
                    this.createIconPanel();
                }
                this.iconPanel.scrollToElement(n);
                return;
            }
            ++n;
        }
    }

    private void createIconPanel() {
        JViewport jViewport = this.getViewport();
        Dimension dimension = new Dimension(90, 90);
        this.iconPanel = new IconPanel(null, dimension, Color.white, Constants.ICONCOLOR);
        this.iconPanel.addIconMouseListener(this.buttonMouseListener);
        jViewport.add(this.iconPanel);
    }

    class ButtonMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractIconView.this.handlePopupTrigger(mouseEvent);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                IconPanelButton iconPanelButton = (IconPanelButton)mouseEvent.getComponent();
                if (mouseEvent.isControlDown()) {
                    if (iconPanelButton.getSelected()) {
                        AbstractIconView.this.unselect(iconPanelButton);
                        return;
                    }
                    AbstractIconView.this.select(iconPanelButton);
                    return;
                }
                AbstractIconView.this.clearSelection();
                AbstractIconView.this.select(iconPanelButton);
                if (mouseEvent.getClickCount() == 2) {
                    AbstractIconView.this.onDoubleClick();
                }
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractIconView.this.handlePopupTrigger(mouseEvent);
                return;
            }
        }

        ButtonMouseListener() {
            AbstractIconView.this = AbstractIconView.this;
        }
    }

    private final class 1
    extends Thread {
        public void run() {
            Main.getApp().getClientComm().waitOn();
            AbstractIconView.this.paintView();
            Main.getApp().getClientComm().waitOff();
            Main.getApp().getTree().getCurrentContentPanel().updateStatusBar();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends Thread {
        public void run() {
            Main.getApp().getClientComm().waitOn();
            AbstractIconView.this.paintView();
            Main.getApp().getClientComm().waitOff();
            Main.getApp().getTree().getCurrentContentPanel().updateStatusBar();
        }

        /* synthetic */ 2() {
        }
    }

    private class ClientDataCompare
    implements Compare {
        public int doCompare(Object object, Object object2) {
            Object object3 = ((IconPanelElement)object).getDataObject();
            Object object4 = ((IconPanelElement)object2).getDataObject();
            int n = AbstractIconView.this.getIconModel().compare(object3, object4);
            if (n != 0) {
                if (AbstractIconView.this.getSortOrder() == 3) {
                    return n;
                }
                return -n;
            }
            return 0;
        }

        ClientDataCompare() {
            AbstractIconView.this = AbstractIconView.this;
        }
    }
}

