/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ListFetch;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.hostmgr.client.ClientProxy;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.HostContentPanel;
import com.sun.admin.hostmgr.client.HostPropsDialog;
import com.sun.admin.hostmgr.client.HostRenameDialog;
import com.sun.admin.hostmgr.client.ListView;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class HostContentPanel
extends ContentPanel {
    private final String[] filterKeys = new String[]{"hostListComputerName", "hostListIPAddress", "hostListComment", "hostListAliases"};
    private Vector filters;
    private int serverChunkSize = -99999;
    private int displayChunkSize = -99999;

    public void createProperties() {
        HostPropsDialog hostPropsDialog = new HostPropsDialog(Main.getApp().getFrame(), new HostData(""), true);
        hostPropsDialog.show();
    }

    public void viewProperties() {
        ListView listView = this.getCurrentView();
        Vector vector = listView.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        HostData hostData = (HostData)vector.elementAt(0);
        HostPropsDialog hostPropsDialog = new HostPropsDialog(Main.getApp().getFrame(), hostData, false);
        hostPropsDialog.show();
    }

    public void deleteSelected() {
        Vector vector = Main.getApp().getHostMgr().getUserRights();
        if (!vector.contains("solaris.admin.hostmgr.write")) {
            return;
        }
        ListView listView = this.getCurrentView();
        Vector vector2 = listView.getSelected();
        if (vector2.isEmpty()) {
            return;
        }
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            n = Integer.parseInt(ResourceStrings.getString(resourceBundle, "ConfirmDeleteNumColumns"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        FlowArea flowArea = new FlowArea(ResourceStrings.getString(resourceBundle, "ConfirmDeleteHost"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
        flowArea = new FlowArea(ResourceStrings.getString(resourceBundle, "ConfirmDeleteHostWill"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
        ImageIcon imageIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "DialogBulletGif"), "DialogBulletGif");
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        Constraints.constrain(jPanel, jButton, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        flowArea = new FlowArea(ResourceStrings.getString(resourceBundle, "ConfirmDeleteHostBullet1"), n - 5);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        String string = ResourceStrings.getString(resourceBundle, "DeleteHostTitle");
        int n2 = Math.max(string.length(), 10);
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 1, n2, true);
        progressPanel.setRange(0, vector2.size() + 1);
        progressPanel.setValue(0);
        progressPanel.setTitle(string);
        1 var13_13 = new 1(resourceBundle, progressPanel, this, vector2);
        new WarningDialog(Main.getApp().getFrame(), ResourceStrings.getString(resourceBundle, "ConfirmDeleteHostTitle"), jPanel, (ActionListener)var13_13, ResourceStrings.getString(resourceBundle, "Delete"));
    }

    public void renameSelected() {
        ListView listView = this.getCurrentView();
        Vector vector = listView.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        HostData hostData = (HostData)vector.elementAt(0);
        HostRenameDialog hostRenameDialog = new HostRenameDialog(Main.getApp().getFrame(), hostData);
        hostRenameDialog.show();
    }

    public String whatAmI() {
        return "hosts";
    }

    public String[] getFilterAttributes() {
        return this.filterKeys;
    }

    public Vector getFilters() {
        return this.filters;
    }

    public boolean isFilteringSupported() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        return networkData2 == null && networkData.getNetworkAddress().length() == 0;
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    public void refresh() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.vDataCache.removeAllElements();
        System.gc();
        ListView listView = this.getCurrentView();
        listView.clear();
        Main.getApp().setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        String string = ResourceStrings.getString(resourceBundle, "FetchHostsTitle");
        String string2 = ResourceStrings.getString(resourceBundle, "HostBatchReceived");
        String string3 = String.valueOf(string) + ResourceStrings.getString(resourceBundle, "Ellipsis");
        String string4 = String.valueOf(string) + " " + ResourceStrings.getString(resourceBundle, "RefreshInterrupted") + ResourceStrings.getString(resourceBundle, "Ellipsis");
        int n = Math.max(string.length(), string3.length());
        n = Math.max(n, string2.length());
        n = Math.max(n, string4.length());
        n = Math.max(n, 10);
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 1, n, true, true);
        progressPanel.setRange(0, 100);
        progressPanel.setValue(0);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        progressPanel.setStopListener(new 3(string4, myListFetch, progressPanel));
        progressPanel.show();
        myListFetch.addListFetchListener(new 4(string2, progressPanel, this, listView));
        Main.getApp().getClientComm().waitOn();
        myListFetch.start();
        this.bRefresh = true;
        this.setBackground(Color.white);
    }

    public boolean offerNew(Object object, boolean bl) {
        if (object == null || !(object instanceof HostData)) {
            return false;
        }
        HostData hostData = (HostData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        NetworkData networkData3 = networkData;
        if (networkData3.getNetworkAddress().length() == 0) {
            networkData3 = networkData2;
        }
        boolean bl2 = true;
        if (networkData3 != null) {
            bl2 = networkData3.belongsNetwork(hostData.getNetworkAddress());
        }
        if (bl || !bl2) {
            return bl2;
        }
        this.getDataCache().addElement(hostData);
        return true;
    }

    public boolean offerDelete(Object object, boolean bl) {
        if (object != null && !(object instanceof HostData)) {
            return false;
        }
        HostData hostData = (HostData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        NetworkData networkData3 = networkData;
        if (networkData3.getNetworkAddress().length() == 0) {
            networkData3 = networkData2;
        }
        boolean bl2 = true;
        if (networkData3 != null) {
            bl2 = networkData3.belongsNetwork(hostData.getNetworkAddress());
        }
        if (bl || !bl2) {
            return bl2;
        }
        if (Main.getApp().getTree().getCurrentContentPanel() == this) {
            this.getDataCache().removeElement(hostData);
        } else {
            Vector vector = this.getDataCache();
            int n = 0;
            while (n < vector.size()) {
                HostData hostData2 = (HostData)vector.elementAt(n);
                if (hostData2.equals(hostData)) {
                    vector.removeElement(hostData2);
                    break;
                }
                ++n;
            }
        }
        if (networkData.getNetworkAddress().length() == 0 || networkData.isStaticNetwork()) {
            return true;
        }
        Main.getApp().getTree().removeNetwork(defaultMutableTreeNode, networkData);
        return true;
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        String string = ResourceStrings.getString(resourceBundle, "HostListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        Main.getApp().setStatusBar(string2);
    }

    private int getServerChunkSize() {
        if (this.serverChunkSize != -99999) {
            return this.serverChunkSize;
        }
        try {
            ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
            this.serverChunkSize = Integer.parseInt(ResourceStrings.getString(resourceBundle, "ServerChunkSizeForHosts"));
        }
        catch (NumberFormatException numberFormatException) {
            this.serverChunkSize = 1000;
        }
        return this.serverChunkSize;
    }

    private int getDisplayChunkSize() {
        if (this.displayChunkSize != -99999) {
            return this.displayChunkSize;
        }
        try {
            ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
            this.displayChunkSize = Integer.parseInt(ResourceStrings.getString(resourceBundle, "PreferredDisplayChunkSize"));
        }
        catch (NumberFormatException numberFormatException) {
            this.displayChunkSize = 10;
        }
        return this.displayChunkSize;
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ HostContentPanel this$0;
        private final /* synthetic */ ResourceBundle val$bundle;
        private final /* synthetic */ Vector val$vSelected;
        private final /* synthetic */ ProgressPanel val$progressPanel;

        public void actionPerformed(ActionEvent actionEvent) {
            2 var2_2 = new 2(this.val$bundle, this.val$progressPanel, this.this$0, this.val$vSelected);
            var2_2.start();
        }

        /* synthetic */ 1(ResourceBundle resourceBundle, ProgressPanel progressPanel, HostContentPanel hostContentPanel, Vector vector) {
            this.val$bundle = resourceBundle;
            this.val$progressPanel = progressPanel;
            this.this$0 = hostContentPanel;
            this.val$vSelected = vector;
        }
    }

    private static final class 3
    implements ActionListener {
        private final /* synthetic */ String val$interruptedMsg;
        private final /* synthetic */ ProgressPanel val$progressPanel;
        private final /* synthetic */ ListFetch val$listFetch;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.val$listFetch.isInterrupted()) {
                this.val$progressPanel.setText(this.val$interruptedMsg);
                this.val$listFetch.interrupt();
            }
        }

        /* synthetic */ 3(String string, ListFetch listFetch, ProgressPanel progressPanel) {
            this.val$interruptedMsg = string;
            this.val$listFetch = listFetch;
            this.val$progressPanel = progressPanel;
        }
    }

    private static final class 4
    implements ListFetchListener {
        private final /* synthetic */ ListView val$view;
        private final /* synthetic */ String val$batchMsg;
        private final /* synthetic */ ProgressPanel val$progressPanel;
        private final /* synthetic */ HostContentPanel this$0;

        public synchronized void batchReady(ListFetchEvent listFetchEvent) {
            Vector vector = listFetchEvent.getBatch();
            if (vector == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                this.this$0.updateStatusBar();
                this.val$progressPanel.dispose();
                Main.getApp().getClientComm().waitOff();
                return;
            }
            if (listFetchEvent.getSize() > 0) {
                this.val$progressPanel.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                Object[] objectArray = new Object[]{new Integer(listFetchEvent.getNumReceived()), new Integer(listFetchEvent.getSize())};
                String string = MessageFormat.format(this.val$batchMsg, objectArray);
                this.val$progressPanel.appendText(string);
                if (listFetchEvent.getNumReceived() >= listFetchEvent.getSize()) {
                    this.val$progressPanel.setValue(100);
                }
            }
            this.val$view.append(vector);
        }

        public synchronized void errorException(Exception exception) {
            Main.getApp().reportErrorException(exception);
        }

        /* synthetic */ 4(String string, ProgressPanel progressPanel, HostContentPanel hostContentPanel, ListView listView) {
            this.val$batchMsg = string;
            this.val$progressPanel = progressPanel;
            this.this$0 = hostContentPanel;
            this.val$view = listView;
        }
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ClientProxy hostMgr;
        NetworkData networkData;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            HostContentPanel.this = HostContentPanel.this;
            try {
                this.listProps = new ListProperties();
                if (HostContentPanel.this.getCurrentView().getSortOrder() == 3) {
                    this.listProps.setSortOrderAscending();
                } else {
                    this.listProps.setSortOrderDescending();
                }
                this.listProps.setSortColumn(HostContentPanel.this.getCurrentView().getSortAttribute());
                this.listProps.setChunkSize(n);
                if (HostContentPanel.this.filters != null) {
                    this.listProps.setFilters(HostContentPanel.this.filters);
                }
            }
            catch (Exception exception) {}
            this.hostMgr = Main.getApp().getHostMgr();
            TreeNodeData treeNodeData = (TreeNodeData)HostContentPanel.this.treeNode.getUserObject();
            this.networkData = treeNodeData.getNetworkData();
            if (this.networkData.getNetworkAddress().length() == 0) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)HostContentPanel.this.treeNode.getParent();
                treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
                this.networkData = treeNodeData.getNetworkData();
            }
        }

        public int listPrime() throws AdminException {
            if (this.networkData == null) {
                return this.hostMgr.listHostsPrime(this.listProps);
            }
            return this.hostMgr.listHostsByNetworkPrime(this.networkData, this.listProps);
        }

        public Vector listNext() throws AdminException {
            if (this.networkData == null) {
                return this.hostMgr.listHostsNext();
            }
            return this.hostMgr.listHostsByNetworkNext();
        }

        public void listEnd() throws AdminException {
            if (this.networkData == null) {
                this.hostMgr.listHostsEnd();
                return;
            }
            this.hostMgr.listHostsByNetworkEnd();
        }

        public Vector listAll() throws AdminException {
            if (this.networkData == null) {
                return this.hostMgr.listHosts(this.listProps);
            }
            return this.hostMgr.listHostsByNetwork(this.networkData, this.listProps);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString(Main.getApp().getResourceBundle(), "toolname");
        }
    }
}

