/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ListFetch;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.hostmgr.client.ClientProxy;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.ListView;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.client.NetworkContentPanel;
import com.sun.admin.hostmgr.client.NetworkPropsDialog;
import com.sun.admin.hostmgr.client.ShowNetworksDialog;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NetworkContentPanel
extends ContentPanel {
    private int displayChunkSize = -99999;

    public void createProperties() {
        NetworkPropsDialog networkPropsDialog = new NetworkPropsDialog(Main.getApp().getFrame(), new NetworkData());
        networkPropsDialog.show();
    }

    public void viewProperties() {
        ListView listView = this.getCurrentView();
        Vector vector = listView.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        try {
            NetworkData networkData = (NetworkData)vector.elementAt(0);
            NetworkPropsDialog networkPropsDialog = new NetworkPropsDialog(Main.getApp().getFrame(), networkData);
            if (networkData.getNetworkAddress().length() == 0) {
                throw new HostException("EXM_HST_GUI_CANT_VIEW_UNREAL_NETWORK", networkData.getNetworkName());
            }
            networkPropsDialog.show();
            return;
        }
        catch (HostException hostException) {
            Main.getApp().reportErrorException(hostException);
            return;
        }
    }

    public void deleteSelected() {
        Vector vector = Main.getApp().getHostMgr().getUserRights();
        if (!vector.contains("solaris.admin.hostmgr.write")) {
            return;
        }
        ListView listView = this.getCurrentView();
        Vector vector2 = listView.getSelected();
        if (vector2.isEmpty()) {
            return;
        }
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            n = Integer.parseInt(ResourceStrings.getString(resourceBundle, "ConfirmDeleteNumColumns"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        FlowArea flowArea = new FlowArea(ResourceStrings.getString(resourceBundle, "ConfirmDeleteNetwork"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
        flowArea = new FlowArea(ResourceStrings.getString(resourceBundle, "ConfirmDeleteNetworkWill"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
        ImageIcon imageIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "DialogBulletGif"), "DialogBulletGif");
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        Constraints.constrain(jPanel, jButton, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        flowArea = new FlowArea(ResourceStrings.getString(resourceBundle, "ConfirmDeleteNetworkBullet1"), n - 5);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        String string = ResourceStrings.getString(resourceBundle, "DeleteNetworkTitle");
        int n2 = Math.max(string.length(), 10);
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 1, n2, true);
        progressPanel.setRange(0, vector2.size() + 1);
        progressPanel.setValue(0);
        progressPanel.setTitle(string);
        1 var13_13 = new 1(resourceBundle, progressPanel, this, vector2);
        new WarningDialog(Main.getApp().getFrame(), ResourceStrings.getString(resourceBundle, "ConfirmDeleteNetworkTitle"), jPanel, (ActionListener)var13_13, ResourceStrings.getString(resourceBundle, "Delete"));
    }

    public String whatAmI() {
        return "networks";
    }

    public void refresh() {
        String string;
        String string2;
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        this.vDataCache.removeAllElements();
        System.gc();
        ListView listView = this.getCurrentView();
        listView.clear();
        Main.getApp().setStatusBar("");
        Main.getApp().getTree().removeAllNetworks(this.treeNode);
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        if (networkData == null) {
            string2 = ResourceStrings.getString(resourceBundle, "FetchNetworksTitle");
            string = ResourceStrings.getString(resourceBundle, "NetworkBatchReceived");
        } else {
            string2 = ResourceStrings.getString(resourceBundle, "FetchSubnetworksTitle");
            string = ResourceStrings.getString(resourceBundle, "SubnetworkBatchReceived");
        }
        String string3 = string2;
        String string4 = string;
        String string5 = String.valueOf(string3) + ResourceStrings.getString(resourceBundle, "Ellipsis");
        String string6 = String.valueOf(string3) + " " + ResourceStrings.getString(resourceBundle, "RefreshInterrupted") + ResourceStrings.getString(resourceBundle, "Ellipsis");
        int n = Math.max(string3.length(), string5.length());
        n = Math.max(n, string4.length());
        n = Math.max(n, string6.length());
        n = Math.max(n, 10);
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 1, n, true, true);
        progressPanel.setRange(0, 100);
        progressPanel.setValue(0);
        progressPanel.setTitle(string3);
        progressPanel.setText(string5);
        progressPanel.setStopListener(new 3(string6, myListFetch, progressPanel));
        progressPanel.show();
        myListFetch.addListFetchListener(new 4(string4, progressPanel, this, listView));
        Main.getApp().getClientComm().waitOn();
        myListFetch.start();
        this.bRefresh = true;
        this.setBackground(Color.white);
    }

    public boolean offerNew(Object object, boolean bl) {
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        Object object3;
        int n;
        if (object != null && !(object instanceof NetworkData)) {
            return false;
        }
        NetworkData networkData = (NetworkData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData2 = treeNodeData.getNetworkData();
        if (!networkData.isNetwork() && networkData2 != null) {
            networkData.setNetmaskForSubnet(networkData2.getNetmask());
        }
        Integer n2 = (Integer)AdminCommonTools.CMN_getPreference("hostmgr", "ShowNetworks", new Integer(1));
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (n2 == 2) {
            n = 0;
            while (n < ContentPanel.getNumInstances()) {
                long l;
                long l2;
                object3 = ContentPanel.getInstance(n);
                serializable2 = ((ContentPanel)object3).getTreeNode();
                object2 = (TreeNodeData)serializable2.getUserObject();
                serializable = ((TreeNodeData)object2).getNetworkData();
                if (serializable != null && serializable.getNetworkAddress().length() != 0 && (l2 = serializable.getNetworkAddressLong()) == (l = networkData.getNetworkAddressLong())) {
                    defaultMutableTreeNode = serializable2;
                    break;
                }
                ++n;
            }
        }
        n = 1;
        if (defaultMutableTreeNode != null) {
            n = 1;
        } else if (networkData2 != null) {
            n = networkData2.belongsNetwork(networkData.getNetworkAddress());
        } else if (!networkData.isNetwork()) {
            n = 0;
        }
        if (bl || n == 0) {
            return n != 0;
        }
        if (defaultMutableTreeNode != null) {
            object3 = (TreeNodeData)defaultMutableTreeNode.getUserObject();
            serializable2 = ((TreeNodeData)object3).getNetworkData();
            object2 = (DefaultMutableTreeNode)Main.getApp().getTree().getLastSelectedPathComponent();
            if (object2 == defaultMutableTreeNode) {
                Main.getApp().getTree().clearSelection();
            }
            serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Main.getApp().getTree().removeNetwork((DefaultMutableTreeNode)serializable, (NetworkData)serializable2);
        }
        this.getDataCache().addElement(networkData);
        Main.getApp().getTree().addNetwork(this.treeNode, networkData);
        if (Main.getApp().getTree().isSelectionEmpty()) {
            object3 = new TreePath(this.treeNode.getPath());
            Main.getApp().getTree().setSelectionPath((TreePath)object3);
        }
        return true;
    }

    public boolean offerDelete(Object object, boolean bl) {
        if (object != null && !(object instanceof NetworkData)) {
            return false;
        }
        NetworkData networkData = (NetworkData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData2 = treeNodeData.getNetworkData();
        boolean bl2 = true;
        if (networkData2 != null) {
            bl2 = networkData2.belongsNetwork(networkData.getNetworkAddress());
        } else if (!networkData.isNetwork()) {
            bl2 = false;
        }
        if (bl || !bl2) {
            return bl2;
        }
        if (Main.getApp().getTree().getCurrentContentPanel() == this) {
            this.getDataCache().removeElement(networkData);
        } else {
            Vector vector = this.getDataCache();
            int n = 0;
            while (n < vector.size()) {
                NetworkData networkData3 = (NetworkData)vector.elementAt(n);
                if (networkData3.equals(networkData)) {
                    vector.removeElement(networkData3);
                    break;
                }
                ++n;
            }
        }
        Main.getApp().getTree().removeNetwork(this.treeNode, networkData);
        return true;
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        if (networkData == null) {
            String string = ResourceStrings.getString(resourceBundle, "NetworkListContents");
            Object[] objectArray = new Object[2];
            int n = Math.max(0, this.getDataCache().size() - 1);
            objectArray[0] = new Integer(n);
            objectArray[1] = new Integer(1);
            String string2 = MessageFormat.format(string, objectArray);
            Main.getApp().setStatusBar(string2);
            return;
        }
        String string = ResourceStrings.getString(resourceBundle, "SubnetworkListContents");
        Object[] objectArray = new Object[2];
        int n = Math.max(0, this.getDataCache().size() - 1);
        objectArray[0] = new Integer(n);
        objectArray[1] = new Integer(1);
        String string3 = MessageFormat.format(string, objectArray);
        Main.getApp().setStatusBar(string3);
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        if (this.displayChunkSize != -99999) {
            return this.displayChunkSize;
        }
        try {
            ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
            this.displayChunkSize = Integer.parseInt(ResourceStrings.getString(resourceBundle, "PreferredDisplayChunkSize"));
        }
        catch (NumberFormatException numberFormatException) {
            this.displayChunkSize = 10;
        }
        return this.displayChunkSize;
    }

    public boolean isShowByTypeSupported() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        return networkData == null;
    }

    public void showByType() {
        Integer n = (Integer)AdminCommonTools.CMN_getPreference("hostmgr", "ShowNetworks", new Integer(1));
        ShowNetworksDialog showNetworksDialog = new ShowNetworksDialog(Main.getApp().getFrame(), n);
        showNetworksDialog.getOKBtn().addActionListener(new 5(showNetworksDialog, this));
        showNetworksDialog.show();
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ NetworkContentPanel this$0;
        private final /* synthetic */ ResourceBundle val$bundle;
        private final /* synthetic */ Vector val$vSelected;
        private final /* synthetic */ ProgressPanel val$progressPanel;

        public void actionPerformed(ActionEvent actionEvent) {
            2 var2_2 = new 2(this.val$bundle, this.val$progressPanel, this.this$0, this.val$vSelected);
            var2_2.start();
        }

        /* synthetic */ 1(ResourceBundle resourceBundle, ProgressPanel progressPanel, NetworkContentPanel networkContentPanel, Vector vector) {
            this.val$bundle = resourceBundle;
            this.val$progressPanel = progressPanel;
            this.this$0 = networkContentPanel;
            this.val$vSelected = vector;
        }
    }

    private static final class 3
    implements ActionListener {
        private final /* synthetic */ String val$interruptedMsg;
        private final /* synthetic */ ProgressPanel val$progressPanel;
        private final /* synthetic */ ListFetch val$listFetch;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.val$listFetch.isInterrupted()) {
                this.val$progressPanel.setText(this.val$interruptedMsg);
                this.val$listFetch.interrupt();
            }
        }

        /* synthetic */ 3(String string, ListFetch listFetch, ProgressPanel progressPanel) {
            this.val$interruptedMsg = string;
            this.val$listFetch = listFetch;
            this.val$progressPanel = progressPanel;
        }
    }

    private static final class 4
    implements ListFetchListener {
        private final /* synthetic */ ListView val$view;
        private final /* synthetic */ String val$batchMsg;
        private final /* synthetic */ ProgressPanel val$progressPanel;
        private final /* synthetic */ NetworkContentPanel this$0;

        public synchronized void batchReady(ListFetchEvent listFetchEvent) {
            Vector vector = listFetchEvent.getBatch();
            if (vector == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                this.this$0.updateStatusBar();
                this.val$progressPanel.dispose();
                Main.getApp().getClientComm().waitOff();
                return;
            }
            if (listFetchEvent.getSize() > 0) {
                this.val$progressPanel.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                Object[] objectArray = new Object[]{new Integer(listFetchEvent.getNumReceived()), new Integer(listFetchEvent.getSize())};
                String string = MessageFormat.format(this.val$batchMsg, objectArray);
                this.val$progressPanel.appendText(string);
                if (listFetchEvent.getNumReceived() >= listFetchEvent.getSize()) {
                    this.val$progressPanel.setValue(100);
                }
            }
            this.val$view.append(vector);
            Main.getApp().getTree().appendToNode(this.this$0.treeNode, vector);
        }

        public synchronized void errorException(Exception exception) {
            Main.getApp().reportErrorException(exception);
        }

        /* synthetic */ 4(String string, ProgressPanel progressPanel, NetworkContentPanel networkContentPanel, ListView listView) {
            this.val$batchMsg = string;
            this.val$progressPanel = progressPanel;
            this.this$0 = networkContentPanel;
            this.val$view = listView;
        }
    }

    private static final class 5
    implements ActionListener {
        private final /* synthetic */ NetworkContentPanel this$0;
        private final /* synthetic */ ShowNetworksDialog val$d;

        public void actionPerformed(ActionEvent actionEvent) {
            AdminCommonTools.CMN_setPreference("hostmgr", "ShowNetworks", new Integer(this.val$d.getShowValue()));
            this.val$d.dispose();
            this.this$0.refresh();
        }

        /* synthetic */ 5(ShowNetworksDialog showNetworksDialog, NetworkContentPanel networkContentPanel) {
            this.val$d = showNetworksDialog;
            this.this$0 = networkContentPanel;
        }
    }

    class MyListFetch
    extends ListFetchAdapter {
        ClientProxy hostMgr;
        NetworkData networkData;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            NetworkContentPanel.this = NetworkContentPanel.this;
            try {
                this.listProps = new ListProperties();
                if (NetworkContentPanel.this.getCurrentView().getSortOrder() == 3) {
                    this.listProps.setSortOrderAscending();
                } else {
                    this.listProps.setSortOrderDescending();
                }
                this.listProps.setSortColumn(NetworkContentPanel.this.getCurrentView().getSortAttribute());
                this.listProps.setChunkSize(n);
            }
            catch (Exception exception) {}
            this.hostMgr = Main.getApp().getHostMgr();
            TreeNodeData treeNodeData = (TreeNodeData)NetworkContentPanel.this.treeNode.getUserObject();
            this.networkData = treeNodeData.getNetworkData();
        }

        public Vector listCustomStart() {
            Vector<NetworkData> vector = new Vector<NetworkData>();
            NetworkData networkData = new NetworkData();
            String string = ResourceStrings.getString(Main.getApp().getResourceBundle(), "AllNetworkHosts");
            networkData.setNetworkName(string);
            vector.addElement(networkData);
            return vector;
        }

        public Vector listAll() throws AdminException {
            Integer n = (Integer)AdminCommonTools.CMN_getPreference("hostmgr", "ShowNetworks", new Integer(1));
            if (n == 3) {
                return new Vector();
            }
            boolean bl = n == 2;
            this.listProps.setCustomBooleanArg1(bl);
            if (this.networkData == null) {
                return this.hostMgr.listNetworks(this.listProps);
            }
            return this.hostMgr.listNetworkSubnets(this.networkData, this.listProps);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString(Main.getApp().getResourceBundle(), "toolname");
        }
    }
}

